/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.developer.action;

import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.service.developer.service.DeveloperInfoService;
import com.xdja.cssp.open.system.entity.TUser;
import com.xdja.cssp.open.system.service.SystemService;
import com.xdja.open.service.log.entity.SystemLog;
import com.xdja.platform.core.Constants;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/developer"})
public class DeveloperManagementAction
extends BaseAction {
    private DeveloperInfoService developerInfoService = (DeveloperInfoService)DefaultServiceRefer.getServiceRefer(DeveloperInfoService.class);
    private SystemService systemService = (SystemService)DefaultServiceRefer.getServiceRefer(SystemService.class);

    @RequestMapping(value={"/list.do"}, produces={"application/json; charset=utf-8"}, method={RequestMethod.POST})
    @ResponseBody
    public ReturnCodeUtil list(Integer devType, Integer status, Integer acctType, Long timeStart, Long timeEnd, Long auditTimeStart, Long auditTimeEnd, String keyword, Integer pageNo, Integer pageSize) {
        if (pageNo == null || pageSize == null) {
            return new ReturnCodeUtil(101, "missing_required_parameters");
        }
        if (pageNo < 1 || pageSize < 1) {
            return new ReturnCodeUtil(1, "pageNo\u6216\u8005pageSize\u503c\u9519\u8bef");
        }
        long count = this.developerInfoService.count(devType, status, acctType, timeStart, timeEnd, auditTimeStart, auditTimeEnd, keyword, pageNo, pageSize);
        List list = this.developerInfoService.list(devType, status, acctType, timeStart, timeEnd, auditTimeStart, auditTimeEnd, keyword, pageNo, pageSize);
        if (list != null && list.size() > 0) {
            return new ReturnCodeUtil(Long.valueOf(count), Long.valueOf(pageNo.intValue()), pageSize.intValue(), list);
        }
        return new ReturnCodeUtil(Long.valueOf(0L), Long.valueOf(0L), pageSize.intValue(), null);
    }

    @RequestMapping(value={"/finduserbyid.do"}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public Object findDeveloperById(Long id) throws InvalidKeyException, NumberFormatException, NoSuchAlgorithmException {
        if (id == null) {
            return new ReturnCodeUtil(101, "missing_required_parameters");
        }
        Map map = this.developerInfoService.findDeveloperById(id);
        if (map != null) {
            Long headimgTime;
            HashMap<String, Object> temp = new HashMap<String, Object>();
            Long time = (Long)map.get("devTime");
            if (null == time || time <= Constants.FILE_SWITCH_TIME) {
                if (null != map.get("cardfThumbPath") && StringUtils.isNotBlank((CharSequence)map.get("cardfThumbPath").toString())) {
                    map.put("cardfThumbPath", Constants.FASTDFS_DOWNLOAD_URL + map.get("cardfThumbPath").toString());
                }
                if (null != map.get("cardbThumbPath") && StringUtils.isNotBlank((CharSequence)map.get("cardbThumbPath").toString())) {
                    map.put("cardbThumbPath", Constants.FASTDFS_DOWNLOAD_URL + map.get("cardbThumbPath").toString());
                }
                if (null != map.get("cardpThumbPath") && StringUtils.isNotBlank((CharSequence)map.get("cardpThumbPath").toString())) {
                    map.put("cardpThumbPath", Constants.FASTDFS_DOWNLOAD_URL + map.get("cardpThumbPath").toString());
                }
                if (null != map.get("cardfPath") && StringUtils.isNotBlank((CharSequence)map.get("cardfPath").toString())) {
                    map.put("cardfPath", Constants.FASTDFS_DOWNLOAD_URL + map.get("cardfPath").toString());
                }
                if (null != map.get("cardbPath") && StringUtils.isNotBlank((CharSequence)map.get("cardbPath").toString())) {
                    map.put("cardbPath", Constants.FASTDFS_DOWNLOAD_URL + map.get("cardbPath").toString());
                }
                if (null != map.get("cardpPath") && StringUtils.isNotBlank((CharSequence)map.get("cardpPath").toString())) {
                    map.put("cardpPath", Constants.FASTDFS_DOWNLOAD_URL + map.get("cardpPath").toString());
                }
                if (null != map.get("licensefPath") && StringUtils.isNotBlank((CharSequence)map.get("licensefPath").toString())) {
                    map.put("licensefPath", Constants.FASTDFS_DOWNLOAD_URL + map.get("licensefPath").toString());
                }
                if (null != map.get("licensebPath") && StringUtils.isNotBlank((CharSequence)map.get("licensebPath").toString())) {
                    map.put("licensebPath", Constants.FASTDFS_DOWNLOAD_URL + map.get("licensebPath").toString());
                }
                if (null != map.get("licensefThumbPath") && StringUtils.isNotBlank((CharSequence)map.get("licensefThumbPath").toString())) {
                    map.put("licensefThumbPath", Constants.FASTDFS_DOWNLOAD_URL + map.get("licensefThumbPath").toString());
                }
                if (null != map.get("licensebThumbPath") && StringUtils.isNotBlank((CharSequence)map.get("licensebThumbPath").toString())) {
                    map.put("licensebThumbPath", Constants.FASTDFS_DOWNLOAD_URL + map.get("licensebThumbPath").toString());
                }
            } else {
                if (null != map.get("cardfThumbPath") && StringUtils.isNotBlank((CharSequence)map.get("cardfThumbPath").toString())) {
                    map.put("cardfThumbPath", this.developerInfoService.getUploadPicUrl(map.get("cardfThumbPath").toString(), null, Boolean.valueOf(false)));
                }
                if (null != map.get("cardbThumbPath") && StringUtils.isNotBlank((CharSequence)map.get("cardbThumbPath").toString())) {
                    map.put("cardbThumbPath", this.developerInfoService.getUploadPicUrl(map.get("cardbThumbPath").toString(), null, Boolean.valueOf(false)));
                }
                if (null != map.get("cardpThumbPath") && StringUtils.isNotBlank((CharSequence)map.get("cardpThumbPath").toString())) {
                    map.put("cardpThumbPath", this.developerInfoService.getUploadPicUrl(map.get("cardpThumbPath").toString(), null, Boolean.valueOf(false)));
                }
                if (null != map.get("cardfPath") && StringUtils.isNotBlank((CharSequence)map.get("cardfPath").toString())) {
                    map.put("cardfPath", this.developerInfoService.getUploadPicUrl(map.get("cardfPath").toString(), null, Boolean.valueOf(false)));
                }
                if (null != map.get("cardbPath") && StringUtils.isNotBlank((CharSequence)map.get("cardbPath").toString())) {
                    map.put("cardbPath", this.developerInfoService.getUploadPicUrl(map.get("cardbPath").toString(), null, Boolean.valueOf(false)));
                }
                if (null != map.get("cardpPath") && StringUtils.isNotBlank((CharSequence)map.get("cardpPath").toString())) {
                    map.put("cardpPath", this.developerInfoService.getUploadPicUrl(map.get("cardpPath").toString(), null, Boolean.valueOf(false)));
                }
                if (null != map.get("licensefPath") && StringUtils.isNotBlank((CharSequence)map.get("licensefPath").toString())) {
                    map.put("licensefPath", this.developerInfoService.getUploadPicUrl(map.get("licensefPath").toString(), null, Boolean.valueOf(false)));
                }
                if (null != map.get("licensebPath") && StringUtils.isNotBlank((CharSequence)map.get("licensebPath").toString())) {
                    map.put("licensebPath", this.developerInfoService.getUploadPicUrl(map.get("licensebPath").toString(), null, Boolean.valueOf(false)));
                }
                if (null != map.get("licensefThumbPath") && StringUtils.isNotBlank((CharSequence)map.get("licensefThumbPath").toString())) {
                    map.put("licensefThumbPath", this.developerInfoService.getUploadPicUrl(map.get("licensefThumbPath").toString(), null, Boolean.valueOf(false)));
                }
                if (null != map.get("licensebThumbPath") && StringUtils.isNotBlank((CharSequence)map.get("licensebThumbPath").toString())) {
                    map.put("licensebThumbPath", this.developerInfoService.getUploadPicUrl(map.get("licensebThumbPath").toString(), null, Boolean.valueOf(false)));
                }
            }
            if (null == (headimgTime = (Long)map.get("headimgTime")) || headimgTime <= Constants.FILE_SWITCH_TIME) {
                if (null != map.get("headImgPath") && StringUtils.isNotBlank((CharSequence)map.get("headImgPath").toString())) {
                    map.put("headImgPath", Constants.FASTDFS_DOWNLOAD_URL + map.get("headImgPath").toString());
                }
            } else {
                map.put("headImgPath", this.developerInfoService.getUploadPicUrl(map.get("headImgPath").toString(), null, Boolean.valueOf(false)));
            }
            temp.put("result", true);
            temp.put("message", map);
            return temp;
        }
        return new ReturnCodeUtil(103, "server_internal_exception");
    }

    @RequestMapping(value={"/auditdeveloper.do"})
    @ResponseBody
    public ReturnCodeUtil auditDeveloper(Long id, Integer status, String auditRemark) {
        if (id == null || status == null) {
            return new ReturnCodeUtil(101, "missing_required_parameters");
        }
        if (status != 4 && status != 5) {
            return new ReturnCodeUtil(105, "required_parameters_error");
        }
        if (status == 5 && StringUtils.isEmpty((CharSequence)auditRemark)) {
            return new ReturnCodeUtil(101, "missing_required_parameters");
        }
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        Long userid = user.getId();
        int result = this.developerInfoService.auditDeveloper(id, status, auditRemark, userid);
        if (result == 1) {
            if (status == 4) {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u901a\u8fc7\u4e86\u5f00\u53d1\u8005\u5ba1\u6838\u7533\u8bf7,\u5f00\u53d1\u8005ID\u4e3a{}", (Object)user.getUserName(), (Object)id);
            } else if (status == 5) {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u62d2\u7edd\u4e86\u5f00\u53d1\u8005\u5ba1\u6838\u7533\u8bf7,\u5f00\u53d1\u8005ID\u4e3a{},\u62d2\u7edd\u7406\u7531\u4e3a{}", new Object[]{user.getUserName(), id, auditRemark});
            }
            return new ReturnCodeUtil();
        }
        return new ReturnCodeUtil(103, "server_internal_exception");
    }

    @RequestMapping(value={"/getdics.do"})
    @ResponseBody
    public ReturnCodeUtil getDics(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return new ReturnCodeUtil(101, "missing_required_parameters");
        }
        List list = this.systemService.getDicValues(key);
        if (list != null && list.size() > 0) {
            return new ReturnCodeUtil(Long.valueOf(0L), Long.valueOf(0L), 0, list);
        }
        return new ReturnCodeUtil(2, "\u65e0\u6570\u636e");
    }

    @RequestMapping(value={"/upgrade.do"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ReturnCodeUtil upgrade(Long id, Integer accType) {
        if (id == null || accType == null) {
            return new ReturnCodeUtil(1, "id\u6216\u8005accType\u4e3anull");
        }
        if (accType != 1 && accType != 2) {
            return new ReturnCodeUtil(1, "accType\u53ea\u80fd\u4e3a1\u6216\u80052");
        }
        int oldAccType = accType == 2 ? 1 : 2;
        int result = this.developerInfoService.upgrade(id, accType, oldAccType);
        if (result == 1) {
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            if (accType == 1) {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u63d0\u5347\u7528\u6237\u4e3a\u5185\u90e8\u5f00\u53d1\u8005\uff0c\u5f00\u53d1\u8005ID\u4e3a{}", (Object)currUser.getUserName(), (Object)id);
            } else if (accType == 2) {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u53d6\u6d88\u7528\u6237\u5185\u90e8\u5f00\u53d1\u8005\uff0c\u5f00\u53d1\u8005ID\u4e3a{}", (Object)currUser.getUserName(), (Object)id);
            }
            return new ReturnCodeUtil();
        }
        return new ReturnCodeUtil(103, "server_internal_exception");
    }
}

