/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.sdk.action;

import com.xdja.cssp.open.bean.SdkInfoCondition;
import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.core.util.SHA1SUMUtil;
import com.xdja.cssp.open.core.util.ZipUtil;
import com.xdja.cssp.open.service.developer.service.DeveloperInfoService;
import com.xdja.cssp.open.service.sdk.service.TSdkInfoService;
import com.xdja.cssp.open.system.entity.TUser;
import com.xdja.cssp.open.system.service.SystemService;
import com.xdja.cssp.open.web.util.FileUtil;
import com.xdja.cssp.open.web.util.HttpSessionUtil;
import com.xdja.cssp.open.web.util.SpellUtil;
import com.xdja.cssp.open.web.util.UUIDUtil;
import com.xdja.open.service.log.entity.SystemLog;
import com.xdja.platform.core.ApplicationInit;
import com.xdja.platform.core.Constants;
import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Controller
public class SdkInfoAction
extends BaseAction {
    private static Logger logger = LoggerFactory.getLogger(SdkInfoAction.class);
    private TSdkInfoService tSdkInfoService = (TSdkInfoService)DefaultServiceRefer.getServiceRefer(TSdkInfoService.class);
    private SystemService systemService = (SystemService)DefaultServiceRefer.getServiceRefer(SystemService.class);
    private DeveloperInfoService developerInfoService = (DeveloperInfoService)DefaultServiceRefer.getServiceRefer(DeveloperInfoService.class);
    String mdPath = "";
    String htmlPath = "";

    @RequestMapping(value={"/sdk/add/getSdkId.do"})
    @ResponseBody
    public ReturnCodeUtil getSdkId(HttpServletResponse response) {
        return new ReturnCodeUtil((Object)UUIDUtil.getUUID());
    }

    @RequestMapping(value={"/sdk/add/checkVersionIsExist.do"})
    @ResponseBody
    public ReturnCodeUtil checkVersionIsExist(Integer platform, String sdkId, String version, String internalVersion) {
        String message = "success";
        if (StringUtils.isBlank((CharSequence)sdkId) || null == platform || platform == 0) {
            message = "\u53c2\u6570\u9519\u8bef";
            return new ReturnCodeUtil(1, message);
        }
        if (StringUtils.isBlank((CharSequence)version) && StringUtils.isBlank((CharSequence)internalVersion)) {
            message = "\u53c2\u6570\u9519\u8bef";
            return new ReturnCodeUtil(1, message);
        }
        try {
            boolean flag = this.tSdkInfoService.checkVersionIsExist(sdkId, platform, version, internalVersion);
            if (flag) {
                message = "\u7248\u672c\u53f7\u91cd\u590d";
                return new ReturnCodeUtil(2, message);
            }
            return new ReturnCodeUtil((Object)"\u7248\u672c\u53f7\u4e0d\u540c");
        }
        catch (Exception e) {
            message = "\u68c0\u6d4b\u7248\u672c\u53f7\u662f\u5426\u91cd\u590d\u9519\u8bef";
            e.printStackTrace();
            return new ReturnCodeUtil(3, message);
        }
    }

    @RequestMapping(value={"/sdk/add/saveSdkInfo.do"})
    @ResponseBody
    public ReturnCodeUtil saveSDKInfo(MultipartFile logoFile, SdkInfoCondition condition) {
        if (null == logoFile || StringUtils.isBlank((CharSequence)condition.getName()) || null == condition.getPlatform() || StringUtils.isBlank((CharSequence)condition.getPlatformVersion()) || null == condition.getSdkAuthority() || StringUtils.isBlank((CharSequence)condition.getCopyright()) || StringUtils.isBlank((CharSequence)condition.getPreposeVersion()) || StringUtils.isBlank((CharSequence)condition.getVersion()) || StringUtils.isBlank((CharSequence)condition.getInternalVersion()) || StringUtils.isBlank((CharSequence)condition.getZipPath()) || StringUtils.isBlank((CharSequence)condition.getZipHashVal()) || StringUtils.isBlank((CharSequence)condition.getZipInfo()) || StringUtils.isBlank((CharSequence)condition.getExpHashVal1()) || StringUtils.isBlank((CharSequence)condition.getExpPath1()) || StringUtils.isBlank((CharSequence)condition.getDemo1Intro())) {
            return new ReturnCodeUtil(210, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            boolean flag = this.tSdkInfoService.checkSdkNamePlatform(condition.getName(), condition.getPlatform());
            if (flag) {
                return new ReturnCodeUtil(211, "\u8be5\u5e73\u53f0\u4e0b\u7684SDK\u5df2\u7ecf\u6dfb\u52a0\uff0c\u8bf7\u8fdb\u884cSDK\u66f4\u65b0\u64cd\u4f5c");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6821\u9a8csdk\u540d\u79f0\u548c\u5e73\u53f0\u9519\u8bef");
            String message = "\u6821\u9a8csdk\u548c\u5e73\u53f0\u51fa\u9519";
            return new ReturnCodeUtil(212, message);
        }
        String sdkId = condition.getSdkId();
        try {
            String fid = FileUtil.uploadLogo((InputStream)logoFile.getInputStream(), (String)logoFile.getOriginalFilename());
            logger.info("\u5411fastdfs\u4e0a\u4f20logo\u56fe\u7247\u6210\u529f\uff0cSDK\u7684sdkId\u4e3a" + sdkId);
            condition.setLogoPath(ApplicationInit.sysProp.get("fast.server.url") + fid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(213, "\u4e0a\u4f20\u7f29\u7565\u56fe\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u6dfb\u52a0SDK");
        }
        try {
            ReturnCodeUtil result = this.copyFileToDirectory(condition);
            if (!result.isResult()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(314, "\u53d1\u5e03SDK\u5f02\u5e38");
        }
        try {
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            condition.setOperateId(currUser.getId());
            this.tSdkInfoService.saveSdkInfo(condition);
            logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u6dfb\u52a0\u4e86\u5e73\u53f0\u4e3a{}\u7684SDK[{}]\uff0c\u5916\u90e8\u7248\u672c\u53f7\u4e3a{}", new Object[]{currUser.getUserName(), condition.getPlatform(), condition.getName(), condition.getVersion()});
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(314, "\u53d1\u5e03SDK\u5f02\u5e38");
        }
        return new ReturnCodeUtil();
    }

    @RequestMapping(value={"/sdk/info/updateSdkVer.do"})
    @ResponseBody
    public ReturnCodeUtil updateSDKInfo(MultipartFile logoFile, SdkInfoCondition condition) {
        try {
            ReturnCodeUtil result = this.copyFileToDirectory(condition);
            if (!result.isResult()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(203, "\u53d1\u5e03SDK\u5f02\u5e38");
        }
        try {
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            condition.setOperateId(currUser.getId());
            this.tSdkInfoService.updateSdkVer(condition);
            logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u66f4\u65b0\u4e86SDK[{}]\uff0c\u5916\u90e8\u7248\u672c\u53f7\u4e3a{}", new Object[]{currUser.getUserName(), condition.getSdkId(), condition.getVersion()});
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(203, "\u66f4\u65b0SDK\u5f02\u5e38");
        }
        return new ReturnCodeUtil();
    }

    public String unZipAndGetMd(String zipPath, String sdkId, List<File> fileList) {
        this.mdPath = "";
        String descPath = Constants.SDK_API_URL + zipPath.substring(0, zipPath.lastIndexOf(".zip"));
        zipPath = Constants.SDK_CDN_URL + zipPath;
        File descDir = new File(descPath);
        if (!descDir.exists()) {
            descDir.mkdirs();
        }
        fileList.add(descDir);
        new ZipUtil().unZip(zipPath, descPath);
        if (descDir.exists()) {
            this.getMdPath(descDir, sdkId);
            return this.mdPath.replace("\\", "/");
        }
        return "";
    }

    public void getMdPath(File file, String sdkId) {
        if (file.isFile() && file.getAbsolutePath().endsWith(".md")) {
            String path = file.getPath();
            this.mdPath = path.substring(path.indexOf(sdkId));
            System.out.println(this.mdPath);
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!file.isDirectory()) continue;
                this.getMdPath(files[i], sdkId);
            }
        }
    }

    public String unZipAndGetIndex(String zipPath, String sdkId, List<File> listFile) {
        this.htmlPath = "";
        String descPath = Constants.SDK_API_URL + zipPath.substring(0, zipPath.lastIndexOf(".zip"));
        zipPath = Constants.SDK_CDN_URL + zipPath;
        File descDir = new File(descPath);
        if (!descDir.exists()) {
            descDir.mkdirs();
        }
        listFile.add(descDir);
        new ZipUtil().unZip(zipPath, descPath);
        if (descDir.exists()) {
            this.getIndexPath(descDir, sdkId);
            return this.htmlPath.replace("\\", "/");
        }
        return "";
    }

    public void getIndexPath(File file, String sdkId) {
        if (file.isFile() && file.getAbsolutePath().endsWith("index.html")) {
            String path = file.getPath();
            this.htmlPath = path.substring(path.indexOf(sdkId));
            System.out.println(this.htmlPath);
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!file.isDirectory()) continue;
                this.getIndexPath(files[i], sdkId);
            }
        }
    }

    @RequestMapping(value={"/sdk/add/checkFileSHA1.do"})
    @ResponseBody
    public ReturnCodeUtil checkFileSHA1(MultipartFile file, String sha1Value) {
        String message = "success";
        try {
            if (null != file && StringUtils.isNotBlank((CharSequence)sha1Value)) {
                InputStream in = file.getInputStream();
                String newSha1Sum = SHA1SUMUtil.getSHA1SUM((InputStream)in);
                if (!newSha1Sum.trim().equalsIgnoreCase(sha1Value.trim())) {
                    return new ReturnCodeUtil(1, "\u6563\u5217\u503c\u586b\u5199\u9519\u8bef\u6216ZIP\u5305\u4e0a\u4f20\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\uff01");
                }
                return new ReturnCodeUtil((Object)"\u6563\u5217\u503c\u76f8\u540c");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u6821\u9a8c\u9519\u8bef";
            return new ReturnCodeUtil(2, message);
        }
        return null;
    }

    private void deleteDirectory(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.deleteDirectory(files[i]);
            }
        }
        logger.info("\u5220\u9664\u6587\u4ef6\uff1a" + file.getAbsolutePath());
        file.delete();
    }

    private void deleteDirectory(List<File> fileList) {
        for (File file : fileList) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.deleteDirectory(files[i]);
                }
            }
            logger.info("\u5220\u9664\u6587\u4ef6\uff1a" + file.getAbsolutePath());
            file.delete();
        }
    }

    @RequestMapping(value={"/sdk/add/getSdkName.do"})
    @ResponseBody
    public ReturnCodeUtil getSdkName() {
        String message = "success";
        try {
            List nameList = this.systemService.getDicValues("sdkName");
            return new ReturnCodeUtil((Object)nameList);
        }
        catch (Exception e) {
            message = "\u83b7\u53d6SDK\u540d\u79f0\u9519\u8bef";
            e.printStackTrace();
            return new ReturnCodeUtil(1, message);
        }
    }

    public File checkFileName(String filePath, String fileName) {
        int n = 0;
        File fi = new File(filePath, fileName);
        String newFileName = fileName.substring(0, fileName.lastIndexOf(46));
        String fileNameFormat = fileName.substring(fileName.lastIndexOf("."));
        while (fi.exists()) {
            fi = new File(filePath, newFileName + "(" + ++n + ")" + fileNameFormat);
        }
        return fi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(InputStream in, File file) {
        OutputStream fs = null;
        try {
            logger.info("\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)file.getPath());
            if (!file.exists()) {
                file.createNewFile();
            }
            fs = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int byteread = 0;
            while ((byteread = in.read(buffer)) != -1) {
                ((FileOutputStream)fs).write(buffer, 0, byteread);
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\uff1a" + file.getName());
            logger.error("\u6587\u4ef6\u4e22\u5931--------!", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u81f3\u670d\u52a1\u5668\u51fa\u9519!", (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ine) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u8f93\u5165\u6d41\u51fa\u9519!", (Throwable)ine);
            }
            try {
                if (fs != null) {
                    fs.flush();
                    ((FileOutputStream)fs).close();
                }
            }
            catch (Exception fse) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u8f93\u51fa\u6d41\u51fa\u9519!", (Throwable)fse);
            }
        }
        logger.info("\u4e0a\u4f20\u6587\u4ef6\u6267\u884c\u5b8c\u6bd5........");
    }

    @RequestMapping(value={"/sdk/add/checkSdkNamePlatform.do"})
    @ResponseBody
    public ReturnCodeUtil checkSdkNamePlatform(String sdkName, Integer platform) {
        String message = "success";
        if (StringUtils.isBlank((CharSequence)sdkName) || null == platform) {
            return new ReturnCodeUtil(1, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            boolean flag = this.tSdkInfoService.checkSdkNamePlatform(sdkName, platform);
            if (flag) {
                return new ReturnCodeUtil(2, "\u8be5\u5e73\u53f0\u4e0b\u7684SDK\u5df2\u7ecf\u6dfb\u52a0\uff0c\u8bf7\u8fdb\u884cSDK\u66f4\u65b0\u64cd\u4f5c");
            }
            return new ReturnCodeUtil();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6821\u9a8csdk\u540d\u79f0\u548c\u5e73\u53f0\u9519\u8bef");
            message = "\u6821\u9a8csdk\u548c\u5e73\u53f0\u51fa\u9519";
            return new ReturnCodeUtil(2, message);
        }
    }

    @RequestMapping(value={"/sdk/add/handleFile.do"})
    @ResponseBody
    public ReturnCodeUtil handleFileSHA1(Integer type, String SHA1Value, String sdkId, String version, @RequestParam(value="file") CommonsMultipartFile file, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)sdkId) || StringUtils.isBlank((CharSequence)version) || null == file) {
            return new ReturnCodeUtil(210, "\u53c2\u6570\u9519\u8bef");
        }
        if (type == 2) {
            if (StringUtils.isBlank((CharSequence)SHA1Value)) {
                return new ReturnCodeUtil(210, "\u53c2\u6570\u9519\u8bef");
            }
            ReturnCodeUtil sha1SUMCode = this.checkFileSHA1((MultipartFile)file, SHA1Value);
            if (!sha1SUMCode.isResult()) {
                return new ReturnCodeUtil(213, "SHA1\u503c\u4e0eZIP\u5305\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\uff01");
            }
        }
        try {
            return this.handlerFile(sdkId, version, (MultipartFile)file, request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(212, "\u4e0a\u4f20ZIP\u5305\u5f02\u5e38");
        }
    }

    public ReturnCodeUtil handlerFile(String sdkId, String version, MultipartFile file, HttpServletRequest resuest) {
        try {
            Integer appSize = ApplicationInit.sysProp.getInt("sdk.package.size");
            if (appSize > 0 && file.getSize() > (long)(appSize * 1000 * 1000)) {
                file = null;
                logger.warn("\u4e0a\u4f20\u7684\u6587\u4ef6\u5927\u4e8e\u7cfb\u7edf\u670d\u52a1\u6700\u5927\u9650\u989d" + appSize + "M");
                return new ReturnCodeUtil(203, "\u4e0a\u4f20\u7684\u6587\u4ef6\u5927\u4e8e\u7cfb\u7edf\u670d\u52a1\u6700\u5927\u9650\u989d" + appSize + "M");
            }
            String fileName = file.getOriginalFilename();
            if (FileUtil.isInstallPackage((String)fileName)) {
                String newFilePath = HttpSessionUtil.getTempFilePath() + "/" + sdkId;
                File newFile = new File(newFilePath);
                if (!newFile.exists()) {
                    newFile.mkdirs();
                }
                String renameFile = this.renameFile(sdkId, fileName, version);
                File fi = new File(newFilePath, renameFile);
                DecimalFormat format = new DecimalFormat("0.00");
                String size = format.format(Double.parseDouble(file.getSize() + "") / 1000000.0);
                this.copyFile(file.getInputStream(), fi);
                logger.info("\u4e0a\u4f20\u5b89\u88c5\u5305\u5927\u5c0f\uff1a{}M,\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a{}", (Object)size, (Object)fi.getPath());
                logger.info("\u5904\u7406\u5e94\u7528\u4e0a\u4f20\u6587\u4ef6\u7ed3\u675f......");
                return new ReturnCodeUtil((Object)(sdkId + "/" + renameFile));
            }
            return new ReturnCodeUtil(204, "\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return new ReturnCodeUtil(205, "\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519");
        }
    }

    public String renameFile(String sdkId, String fileName, String version) {
        Date currentTime = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String dateString = formatter.format(currentTime);
        String newFileName = fileName.substring(0, fileName.lastIndexOf(46));
        String fileNameFormat = fileName.substring(fileName.lastIndexOf("."));
        String name = SpellUtil.converterToFirstSpell((String)newFileName);
        String result = StringUtils.isNotBlank((CharSequence)version) ? name + "_v" + version : name + dateString;
        File dir = new File(HttpSessionUtil.getTempFilePath() + "/" + sdkId);
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (!file.getName().substring(0, file.getName().lastIndexOf(".")).equals(result)) continue;
                result = result + dateString;
            }
        }
        return result + fileNameFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnCodeUtil copyFileToDirectory(SdkInfoCondition condition) {
        String newFilePath = Constants.SDK_CDN_URL + condition.getSdkId();
        File newFileDirectory = new File(newFilePath);
        if (!newFileDirectory.exists()) {
            newFileDirectory.mkdir();
        }
        InputStream in = null;
        ArrayList fileList = new ArrayList();
        ArrayList tempFileList = new ArrayList();
        try {
            if (StringUtils.isBlank((CharSequence)condition.getExpHashVal2())) {
                condition.setExpHashVal2("");
                condition.setDemo2Intro("");
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getSummaryPath())) {
                condition.setSummaryPathHtml(condition.getSummaryPath());
                logger.info("\u4fdd\u5b58SDK\u6982\u8ff0\u6210\u529f\uff0c\u8be5SDK\u7684sdkId\u4e3a" + condition.getSdkId());
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getNewGuide())) {
                condition.setNewGuideMd(condition.getNewGuide());
                logger.info("\u4fdd\u5b58SDK\u65b0\u624b\u6307\u5357\u6210\u529f\uff0c\u8be5SDK\u7684sdkId\u4e3a" + condition.getSdkId());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getDevGuide()})) {
                condition.setDevGuideMd(condition.getDevGuide());
                logger.info("\u4fdd\u5b58SDK\u5f00\u53d1\u6307\u5357\u6210\u529f\uff0c\u8be5SDK\u7684sdkId\u4e3a" + condition.getSdkId());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getApiPath()})) {
                condition.setApiMd(condition.getApiPath());
                logger.info("\u4fdd\u5b58SDK API\u6587\u6863\u6210\u529f\uff0c\u8be5SDK\u7684sdkId\u4e3a" + condition.getSdkId());
            }
        }
        catch (Exception e1) {
            logger.error("\u5c06\u5b89\u88c5\u5305\u62f7\u8d1d\u5230CDN\u540c\u6b65\u6587\u4ef6\u5939\u5931\u8d25,\u5e94\u7528sdkId\u4e3a" + condition.getSdkId());
            e1.printStackTrace();
            this.deleteDirectory(fileList);
            ReturnCodeUtil returnCodeUtil = new ReturnCodeUtil(312, "\u53d1\u5e03SDK\u5931\u8d25\uff01");
            return returnCodeUtil;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (tempFileList.size() > 0) {
            this.deleteDirectory(tempFileList);
        }
        return new ReturnCodeUtil();
    }

    @RequestMapping(value={"sdk/add/handleBlankFile.do"})
    @ResponseBody
    public ReturnCodeUtil handleBlankFile() {
        return new ReturnCodeUtil();
    }

    @RequestMapping(value={"/getUploadFileUrl.do"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ReturnCodeUtil getUploadFileUrl(String fileUrl, Integer trunk) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            String url = this.developerInfoService.getUploadPicUrl(fileUrl, trunk, Boolean.valueOf(true));
            return new ReturnCodeUtil((Object)url);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u6216\u4e0b\u8f7d\u5730\u5740\u5f02\u5e38");
            if (StringUtils.isBlank((CharSequence)fileUrl)) {
                return new ReturnCodeUtil(205, "\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u6216\u4e0b\u8f7d\u5730\u5740\u5f02\u5e38");
            }
            return new ReturnCodeUtil(205, "\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u5730\u5740\u6216\u4e0b\u8f7d\u5730\u5740\u5f02\u5e38");
        }
    }
}

