/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.sdk.action;

import com.xdja.cssp.open.bean.SdkInfoCondition;
import com.xdja.cssp.open.bean.SdkQueryCondition;
import com.xdja.cssp.open.core.util.ListMessage;
import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.service.developer.service.DeveloperInfoService;
import com.xdja.cssp.open.service.sdk.service.TSdkInfoService;
import com.xdja.cssp.open.system.entity.TUser;
import com.xdja.cssp.open.system.service.SystemService;
import com.xdja.open.service.log.entity.SystemLog;
import com.xdja.platform.core.Constants;
import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.io.File;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SdkManageAction
extends BaseAction {
    private TSdkInfoService tSdkInfoService = (TSdkInfoService)DefaultServiceRefer.getServiceRefer(TSdkInfoService.class);
    private SystemService systemService = (SystemService)DefaultServiceRefer.getServiceRefer(SystemService.class);
    private DeveloperInfoService developerInfoService = (DeveloperInfoService)DefaultServiceRefer.getServiceRefer(DeveloperInfoService.class);
    private static Logger logger = LoggerFactory.getLogger(SdkManageAction.class);

    @RequestMapping(value={"/sdk/info/countSDK.do"})
    @ResponseBody
    public ReturnCodeUtil countSDK(Integer status, SdkQueryCondition condition) {
        String message = "success";
        Long count = 0L;
        if (null == status) {
            message = "\u53c2\u6570\u9519\u8bef";
            return new ReturnCodeUtil(1, message);
        }
        try {
            count = this.tSdkInfoService.countSDK(status, condition);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(2, "\u7edf\u8ba1\u53d1\u5e03SDK\u6570\u91cf\u9519\u8bef");
        }
        return new ReturnCodeUtil((Object)count);
    }

    @RequestMapping(value={"/sdk/info/queryPublishedSdkList.do"})
    @ResponseBody
    public ReturnCodeUtil ajaxPublishedSdkList(Long pageNo, Integer pageSize, SdkQueryCondition sdkQueryCondition) {
        ReturnCodeUtil returnCodeUtil;
        String message = "success";
        if (null == pageNo || pageNo < 1L) {
            message = "\u53c2\u6570\u9519\u8bef";
            return new ReturnCodeUtil(1, message);
        }
        if (null == pageSize || pageSize < 1) {
            message = "\u53c2\u6570\u9519\u8bef";
            return new ReturnCodeUtil(1, message);
        }
        try {
            returnCodeUtil = this.tSdkInfoService.ajaxPublishedSdkList(pageNo, pageSize.intValue(), sdkQueryCondition);
            this.getNameByDicCode(returnCodeUtil);
        }
        catch (Exception e) {
            returnCodeUtil = new ReturnCodeUtil(2, "\u67e5\u8be2\u5df2\u53d1\u5e03SDK\u5217\u8868\u5931\u8d25");
        }
        return returnCodeUtil;
    }

    @RequestMapping(value={"/sdk/info/queryRemovedSdkList.do"})
    @ResponseBody
    public ReturnCodeUtil ajaxRemovedSdkList(Long pageNo, Integer pageSize, SdkQueryCondition sdkQueryCondition) {
        ReturnCodeUtil returnCodeUtil;
        String message = "success";
        if (null == pageNo || pageNo < 1L) {
            message = "\u53c2\u6570\u9519\u8bef";
            return new ReturnCodeUtil(1, message);
        }
        if (null == pageSize || pageSize < 1) {
            message = "\u53c2\u6570\u9519\u8bef";
            return new ReturnCodeUtil(1, message);
        }
        try {
            returnCodeUtil = this.tSdkInfoService.ajaxUnShelveSdkList(pageNo, pageSize.intValue(), sdkQueryCondition);
            this.getNameByDicCode(returnCodeUtil);
        }
        catch (Exception e) {
            returnCodeUtil = new ReturnCodeUtil(1, "\u67e5\u8be2\u5df2\u4e0b\u67b6SDK\u5217\u8868\u5931\u8d25");
            e.printStackTrace();
        }
        return returnCodeUtil;
    }

    public ReturnCodeUtil getNameByDicCode(ReturnCodeUtil returnCodeUtil) {
        ListMessage listMessage = (ListMessage)returnCodeUtil.getMessage();
        if (listMessage.getTotal() > 0L) {
            List dataList = listMessage.getDataList();
            for (int i = 0; i < dataList.size(); ++i) {
                String devGuidePath;
                String newGuidePath;
                String summaryPath;
                String apiPath;
                String expPath2;
                SdkInfoCondition info = (SdkInfoCondition)dataList.get(i);
                String name = info.getName();
                String platformVersion = info.getPlatformVersion();
                if (info.getPlatform() == 1) {
                    info.setPlatformVersion(this.systemService.getDicName(platformVersion, "Android").get("name").toString());
                } else if (info.getPlatform() == 2) {
                    info.setPlatformVersion(this.systemService.getDicName(platformVersion, "Windows").get("name").toString());
                } else if (info.getPlatform() == 3) {
                    info.setPlatformVersion(this.systemService.getDicName(platformVersion, "Linux").get("name").toString());
                }
                if (StringUtils.isNotBlank((CharSequence)info.getName())) {
                    info.setName(this.systemService.getDicName(info.getName(), "sdkName").get("name").toString());
                }
                String zipPath = info.getZipPath();
                info.setZipPath(Constants.SERVER_SDK_CDN_URL + zipPath);
                String expPath1 = info.getExpPath1();
                if (StringUtils.isNotBlank((CharSequence)expPath1)) {
                    info.setExpPath1(Constants.SERVER_SDK_CDN_URL + expPath1);
                }
                if (StringUtils.isNotEmpty((CharSequence)(expPath2 = info.getExpPath2()))) {
                    info.setExpPath2(Constants.SERVER_SDK_CDN_URL + expPath2);
                }
                if (StringUtils.isNotEmpty((CharSequence)(apiPath = info.getApiPath()))) {
                    info.setApiPath(Constants.SERVER_SDK_CDN_URL + apiPath);
                }
                if (StringUtils.isNotEmpty((CharSequence)(summaryPath = info.getSummaryPath()))) {
                    info.setSummaryPath(Constants.SERVER_SDK_CDN_URL + summaryPath);
                }
                if (StringUtils.isNotEmpty((CharSequence)(newGuidePath = info.getNewGuide()))) {
                    info.setNewGuide(Constants.SERVER_SDK_CDN_URL + newGuidePath);
                }
                if (!StringUtils.isNotEmpty((CharSequence)(devGuidePath = info.getNewGuide()))) continue;
                info.setDevGuide(Constants.SERVER_SDK_CDN_URL + devGuidePath);
            }
        }
        return returnCodeUtil;
    }

    public SdkInfoCondition getNameByDicCode(SdkInfoCondition condition) throws InvalidKeyException, NumberFormatException, NoSuchAlgorithmException {
        String summaryPath;
        String devGuide;
        String newGuide;
        Integer platform;
        String name = condition.getName();
        String platformVersion = condition.getPlatformVersion();
        if (StringUtils.isNotBlank((CharSequence)platformVersion)) {
            condition.setName(this.systemService.getDicName(name, "sdkName").get("name").toString());
        }
        if (null != (platform = condition.getPlatform()) && platform != 0) {
            if (condition.getPlatform() == 1) {
                condition.setPlatformVersion(this.systemService.getDicName(platformVersion, "Android").get("name").toString());
            } else if (condition.getPlatform() == 2) {
                condition.setPlatformVersion(this.systemService.getDicName(platformVersion, "Windows").get("name").toString());
            } else if (condition.getPlatform() == 3) {
                condition.setPlatformVersion(this.systemService.getDicName(platformVersion, "Linux").get("name").toString());
            }
        }
        Integer status = condition.getStatus();
        String zipPath = condition.getZipPath();
        String expPath1 = condition.getExpPath1();
        String expPath2 = condition.getExpPath2();
        String apiPath = condition.getApiPath();
        if (StringUtils.isNotBlank((CharSequence)zipPath)) {
            if (zipPath.startsWith("group")) {
                condition.setZipPath(this.developerInfoService.getUploadPicUrl(zipPath, null, Boolean.valueOf(false)));
            } else {
                condition.setZipPath(Constants.SERVER_SDK_CDN_URL + zipPath);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)expPath1)) {
            if (expPath1.startsWith("group")) {
                condition.setExpPath1(this.developerInfoService.getUploadPicUrl(expPath1, null, Boolean.valueOf(false)));
            } else {
                condition.setExpPath1(Constants.SERVER_SDK_CDN_URL + expPath1);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)expPath2)) {
            if (expPath2.startsWith("group")) {
                condition.setExpPath2(this.developerInfoService.getUploadPicUrl(expPath2, null, Boolean.valueOf(false)));
            } else {
                condition.setExpPath2(Constants.SERVER_SDK_CDN_URL + expPath2);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)apiPath) && !apiPath.startsWith("<")) {
            if (apiPath.startsWith("group")) {
                condition.setApiPath(this.developerInfoService.getUploadPicUrl(apiPath, null, Boolean.valueOf(false)));
            } else {
                condition.setApiPath(Constants.SERVER_SDK_CDN_URL + apiPath);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(newGuide = condition.getNewGuide())) && !newGuide.startsWith("<")) {
            if (newGuide.startsWith("group")) {
                condition.setNewGuide(this.developerInfoService.getUploadPicUrl(newGuide, null, Boolean.valueOf(false)));
            } else {
                condition.setNewGuide(Constants.SERVER_SDK_CDN_URL + newGuide);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(devGuide = condition.getDevGuide())) && !devGuide.startsWith("<")) {
            if (devGuide.startsWith("group")) {
                condition.setDevGuide(this.developerInfoService.getUploadPicUrl(devGuide, null, Boolean.valueOf(false)));
            } else {
                condition.setDevGuide(Constants.SERVER_SDK_CDN_URL + devGuide);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(summaryPath = condition.getSummaryPath())) && !summaryPath.startsWith("<")) {
            if (summaryPath.startsWith("group")) {
                condition.setSummaryPath(this.developerInfoService.getUploadPicUrl(summaryPath, null, Boolean.valueOf(false)));
            } else {
                condition.setSummaryPath(Constants.SERVER_SDK_CDN_URL + summaryPath);
            }
        }
        return condition;
    }

    @RequestMapping(value={"/sdk/info/querySdkDetail.do"})
    @ResponseBody
    public ReturnCodeUtil querySdkDetail(String sdkId, Integer status, String version) {
        ReturnCodeUtil returnCodeUtil;
        if (StringUtils.isBlank((CharSequence)sdkId) || null == status) {
            ReturnCodeUtil returnCodeUtil2 = new ReturnCodeUtil(1, "\u53c2\u6570\u9519\u8bef,\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\u9519\u8bef");
            return returnCodeUtil2;
        }
        try {
            SdkInfoCondition sdkInfoCondition = this.tSdkInfoService.querySdkDetail(sdkId, status, version);
            returnCodeUtil = new ReturnCodeUtil((Object)this.getNameByDicCode(sdkInfoCondition));
        }
        catch (Exception e) {
            returnCodeUtil = new ReturnCodeUtil(2, "\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u51fa\u9519");
            e.printStackTrace();
        }
        return returnCodeUtil;
    }

    @RequestMapping(value={"/sdk/info/removeSdk.do"})
    @ResponseBody
    public ReturnCodeUtil removeSdk(String sdkId, String version, Boolean isLatest) {
        String message = "success";
        if (StringUtils.isBlank((CharSequence)sdkId) || StringUtils.isBlank((CharSequence)version) || null == isLatest) {
            message = "\u53c2\u6570\u9519\u8bef";
            return new ReturnCodeUtil(1, message);
        }
        try {
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.tSdkInfoService.unShelveSDK(sdkId, version, isLatest, currUser.getId());
            logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u4e0b\u67b6SDK{},\u4e0b\u67b6\u7248\u672c\u53f7\u4e3a{}", new Object[]{currUser.getUserName(), sdkId, version});
        }
        catch (Exception e) {
            message = "\u4e0b\u67b6SDK\u5931\u8d25";
            e.printStackTrace();
            return new ReturnCodeUtil(2, message);
        }
        return new ReturnCodeUtil();
    }

    @RequestMapping(value={"/sdk/info/deleteSdk.do"})
    @ResponseBody
    public ReturnCodeUtil deleteSdk(String sdkId) {
        String message = "success";
        if (StringUtils.isBlank((CharSequence)sdkId)) {
            message = "\u53c2\u6570\u9519\u8bef,\u5220\u9664SDK\u5931\u8d25";
            return new ReturnCodeUtil(1, message);
        }
        try {
            this.tSdkInfoService.deleteSdk(sdkId);
            File file = new File(Constants.SDK_CDN_URL + sdkId);
            this.deleteDirectory(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u5220\u9664SDK\u5931\u8d25";
            return new ReturnCodeUtil(2, message);
        }
        TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
        logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u5220\u9664\u4e86SDK{}", (Object)currUser.getUserName(), (Object)sdkId);
        return new ReturnCodeUtil();
    }

    private void deleteDirectory(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.deleteDirectory(files[i]);
            }
        }
        logger.info("\u5220\u9664\u6587\u4ef6\uff1a" + file.getAbsolutePath());
        file.delete();
    }

    @RequestMapping(value={"/sdk/info/getHistoryVerNo.do"})
    @ResponseBody
    public ReturnCodeUtil getHistoryVerNo(String sdkId) {
        String message = "success";
        if (StringUtils.isBlank((CharSequence)sdkId)) {
            message = "\u53c2\u6570\u9519\u8bef\uff0c\u67e5\u8be2\u5386\u53f2\u7248\u672c\u53f7\u9519\u8bef";
            return new ReturnCodeUtil(1, message);
        }
        try {
            List verList = this.tSdkInfoService.getHistoryVerNoList(sdkId);
            return new ReturnCodeUtil((Object)verList);
        }
        catch (Exception e) {
            message = "\u83b7\u53d6SDK\u540d\u79f0\u9519\u8bef";
            e.printStackTrace();
            return new ReturnCodeUtil(2, message);
        }
    }

    @RequestMapping(value={"/sdk/info/getPlatformVersion.do"})
    @ResponseBody
    public ReturnCodeUtil getPlatformVersion(Integer platform) {
        String message = "success";
        if (null == platform) {
            message = "\u53c2\u6570\u9519\u8bef,\u83b7\u53d6\u8fd0\u884c\u73af\u5883\u9519\u8bef";
            return new ReturnCodeUtil(1, message);
        }
        try {
            if (null != platform && platform > 0) {
                Map platformMap = this.systemService.getDicName(String.valueOf(platform), "platform");
                List nameList = this.systemService.getDicValues(platformMap.get("name").toString());
                return new ReturnCodeUtil((Object)nameList);
            }
            return new ReturnCodeUtil((Object)"");
        }
        catch (Exception e) {
            message = "\u83b7\u53d6SDK\u540d\u79f0\u9519\u8bef";
            e.printStackTrace();
            return new ReturnCodeUtil(2, message);
        }
    }
}

