/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.security.action;

import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.system.entity.TAccountInfo;
import com.xdja.cssp.open.system.entity.TUser;
import com.xdja.cssp.open.system.service.IFunctionService;
import com.xdja.cssp.open.system.service.IUserService;
import com.xdja.cssp.open.web.security.provider.UsernamePasswordCardidToken;
import com.xdja.cssp.open.web.util.Card;
import com.xdja.cssp.open.web.util.CertUtil;
import com.xdja.cssp.open.web.util.Constants;
import com.xdja.open.service.log.entity.SystemLog;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.bean.Operator;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LoginAction
extends BaseAction {
    private IFunctionService functionService = (IFunctionService)DefaultServiceRefer.getServiceRefer(IFunctionService.class);
    private IUserService userService = (IUserService)DefaultServiceRefer.getServiceRefer(IUserService.class);

    @RequestMapping(value={"/login.do"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object login(HttpServletRequest request, HttpServletResponse response, String cardId) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        HashMap<String, Object> info = new HashMap<String, Object>();
        ReturnCodeUtil returnCodeUtil = new ReturnCodeUtil();
        StringBuilder url = new StringBuilder("https://");
        url.append(request.getServerName()).append(":").append(StringUtils.isBlank((CharSequence)Constants.HTTPS_PORT) ? "9443" : Constants.HTTPS_PORT).append(request.getRequestURI());
        info.put("loginUrl", url.toString());
        info.put("ALLOWEDCARDCERTAINERNOKEY", Constants.ALLOWED_CARD_CERTAINER_NO);
        info.put("cardDownloadURL", Constants.CARD_DOWNLOAD_URL);
        info.put("cardVersion", Constants.CARD_VERSION);
        if (StringUtils.isBlank((CharSequence)cardId)) {
            message.put("errCode", 101);
            message.put("errDesc", "\u8bf7\u63d2\u5165USB Key");
            returnCodeUtil.setResult(false);
            message.put("info", info);
            returnCodeUtil.setMessage(message);
            return returnCodeUtil;
        }
        String userName = null;
        userName = this.userService.getUserNameById(cardId);
        if (StringUtils.isBlank((CharSequence)userName)) {
            returnCodeUtil.setResult(false);
            message.put("errCode", 102);
            message.put("errDesc", "\u8bf7\u63d2\u5165\u6b63\u786e\u7684USBKey");
            message.put("info", info);
            returnCodeUtil.setMessage(message);
            return returnCodeUtil;
        }
        info.put("userName", userName);
        info.put("url", url.toString());
        message.put("info", info);
        returnCodeUtil.setMessage(message);
        return returnCodeUtil;
    }

    @RequestMapping(value={"/login.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object login(String userName, String cert, String cardId, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return new ReturnCodeUtil(101, "\u8bf7\u63d2\u5165USB key");
        }
        boolean isLogined = true;
        try {
            UsernamePasswordCardidToken token = new UsernamePasswordCardidToken(userName, "111111");
            token.setCardId(cardId);
            SecurityUtils.getSubject().login((AuthenticationToken)token);
        }
        catch (LockedAccountException e) {
            isLogined = false;
            return new ReturnCodeUtil(103, "\u7528\u6237\u88ab\u9501\u5b9a");
        }
        catch (UnknownAccountException e) {
            isLogined = false;
            return new ReturnCodeUtil(104, "\u7528\u6237\u540d\u4e0d\u5b58\u5728");
        }
        catch (IncorrectCredentialsException e) {
            isLogined = false;
            return new ReturnCodeUtil(105, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
            isLogined = false;
            return new ReturnCodeUtil(106, "\u7528\u6237\u8ba4\u8bc1\u5931\u8d25\uff0c\u9519\u8bef\u7801");
        }
        if (isLogined) {
            TUser user = this.userService.getUserByUserName(userName);
            Integer status = user.getStatus();
            if (status == TAccountInfo.ENUM_USING_STATUS.stopStatus.value) {
                return new ReturnCodeUtil(107, "\u7528\u6237\u5df2\u88ab\u505c\u7528\uff0c\u9519\u8bef\u7801");
            }
            user.setCardId(cardId);
            OperatorUtil.setOperator((Operator)new Operator(userName, null));
            OperatorUtil.getOperator().setCurrUser((Object)user);
            this.logger.info(SystemLog.ENUM_LOG_TYPE.loginLog.value.intValue(), LoggerExtData.create((String)"logType", (Object)1), "\u7ba1\u7406\u5458{}\u767b\u5f55\u6210\u529f", (Object)user.getUserName());
            this.logger.info(SystemLog.ENUM_LOG_TYPE.loginLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u767b\u5f55\u7cfb\u7edf\u6210\u529f", (Object)userName);
            Serializable sessionId = SecurityUtils.getSubject().getSession().getId();
            user.setSessionId(sessionId);
            return new ReturnCodeUtil((Object)user);
        }
        return new ReturnCodeUtil(108, "\u7528\u6237\u767b\u5f55\u5931\u8d25");
    }

    @RequestMapping(value={"/logout.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object logout(HttpServletResponse response) {
        ReturnCodeUtil returnCodeUtil = new ReturnCodeUtil();
        HashMap<String, Object> message = new HashMap<String, Object>();
        try {
            TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.logger.info(SystemLog.ENUM_LOG_TYPE.loginLog.value.intValue(), LoggerExtData.create((String)"logType", (Object)2), "\u7ba1\u7406\u5458{}\u9000\u51fa\u6210\u529f", (Object)user.getUserName());
            SecurityUtils.getSubject().logout();
        }
        catch (Exception e) {
            this.logger.error("\u9000\u51fa\u7cfb\u7edf\u5931\u8d25", (Object)e.getMessage());
            returnCodeUtil.setResult(false);
            message.put("errCode", 101);
            message.put("errDesc", "\u7ba1\u7406\u5458\u9000\u51fa\u5931\u8d25");
            returnCodeUtil.setMessage(message);
            return returnCodeUtil;
        }
        returnCodeUtil.setMessage((Object)"\u7ba1\u7406\u5458\u9000\u51fa\u767b\u5f55\u6210\u529f");
        return returnCodeUtil;
    }

    private Card getCert(String certB64) {
        try {
            X509Certificate cert = CertUtil.getCertFromStr((String)certB64);
            if (null == cert) {
                return null;
            }
            Card card = CertUtil.getCard((X509Certificate)cert);
            if (card == null || StringUtils.isBlank((CharSequence)card.getCardNo())) {
                return null;
            }
            return card;
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u6d4b\u767b\u5f55\u5361\u53f7\u4e0e\u8bc1\u4e66\u5185\u5361\u53f7\u662f\u5426\u4e00\u81f4\u65f6\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"/getFunctionMenu.do"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ReturnCodeUtil getFunctionMenu() {
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        try {
            Map menuMap = this.functionService.queryAllFunctions(user);
            return new ReturnCodeUtil((Object)menuMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7528\u6237" + user.getUserName() + "\u83b7\u53d6\u7528\u6237\u83dc\u5355\u6743\u9650\u51fa\u9519");
            return new ReturnCodeUtil(202, "\u83b7\u53d6\u7528\u6237\u83dc\u5355\u6743\u9650\u51fa\u9519");
        }
    }
}

