/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.system.action;

import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.system.entity.TRole;
import com.xdja.cssp.open.system.entity.TUser;
import com.xdja.cssp.open.system.service.IRoleService;
import com.xdja.open.service.log.entity.SystemLog;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RoleAction
extends BaseAction {
    private IRoleService roleService = (IRoleService)DefaultServiceRefer.getServiceRefer(IRoleService.class);

    @RequestMapping(value={"/system/role/ajaxList.do"})
    @ResponseBody
    public ReturnCodeUtil roleAjaxList(Long pageNo, Integer pageSize) {
        if (null == pageNo || pageNo < 1L || null == pageSize || pageSize < 1) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            return this.roleService.queryAllRolesList(pageNo, pageSize);
        }
        catch (Exception e) {
            return new ReturnCodeUtil(102, "\u5206\u9875\u83b7\u53d6\u89d2\u8272\u5217\u8868\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"/system/role/delRole.do"})
    @ResponseBody
    public ReturnCodeUtil delRole(Long roleId) {
        if (null == roleId || roleId < 0L) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            this.roleService.deleteRoleById(roleId);
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u5220\u9664\u4e86\u89d2\u8272", (Object)currUser.getUserName());
            return new ReturnCodeUtil((Object)"\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u5220\u9664\u89d2\u8272\u5931\u8d25!");
        }
    }

    @RequestMapping(value={"/system/role/addRole.do"})
    @ResponseBody
    public ReturnCodeUtil addRole(TRole role, String funcIds) {
        if (StringUtils.isBlank((CharSequence)role.getName()) || StringUtils.isBlank((CharSequence)funcIds)) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            this.roleService.saveRole(role, funcIds);
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            if (null == role.getId()) {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u6dfb\u52a0\u89d2\u8272{}\u6210\u529f", (Object)currUser.getUserName(), (Object)role.getName());
            } else {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u7f16\u8f91\u89d2\u8272{}\u6210\u529f", (Object)currUser.getUserName(), (Object)role.getName());
            }
            return new ReturnCodeUtil((Object)"\u4fdd\u5b58\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u4fdd\u5b58\u89d2\u8272\u5931\u8d25!");
        }
    }

    @RequestMapping(value={"/system/role/isExistRoleName.do"})
    @ResponseBody
    public ReturnCodeUtil isExistRoleName(Long roleId, String roleName) {
        if (StringUtils.isBlank((CharSequence)roleName)) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            Boolean flag = this.roleService.isRoleNameExist(roleId, roleName);
            if (flag.booleanValue()) {
                return new ReturnCodeUtil(103, "\u89d2\u8272\u540d\u91cd\u590d");
            }
            return new ReturnCodeUtil();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u67e5\u8be2\u89d2\u8272\u540d\u662f\u5426\u91cd\u590d\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"/system/role/getRoleInfo.do"})
    @ResponseBody
    public ReturnCodeUtil getRoleInfo(Long roleId) {
        try {
            TRole role = this.roleService.getRoleById(roleId);
            return new ReturnCodeUtil((Object)role);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u83b7\u53d6\u89d2\u8272\u4fe1\u606f\u5f02\u5e38");
        }
    }
}

