/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.system.action;

import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.system.entity.TUser;
import com.xdja.cssp.open.system.entity.TUserCert;
import com.xdja.cssp.open.system.service.IUserService;
import com.xdja.open.service.log.entity.SystemLog;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UserAction
extends BaseAction {
    private IUserService userService = (IUserService)DefaultServiceRefer.getServiceRefer(IUserService.class);

    @RequestMapping(value={"/system/user/ajaxList.do"})
    @ResponseBody
    public ReturnCodeUtil roleAjaxList(Long pageNo, Integer pageSize) {
        if (null == pageNo || pageNo < 1L || null == pageSize || pageSize < 1) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            return this.userService.queryAllUsersList(pageNo, pageSize);
        }
        catch (Exception e) {
            return new ReturnCodeUtil(102, "\u5206\u9875\u83b7\u53d6\u7528\u6237\u5217\u8868\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/system/user/getUserInfoById.do"})
    @ResponseBody
    public ReturnCodeUtil getUserInfoById(Long userId) {
        try {
            TUser user = this.userService.getUserInfoById(userId);
            return new ReturnCodeUtil((Object)user);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u83b7\u53d6\u89d2\u8272\u4fe1\u606f\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"/system/user/saveUser.do"})
    @ResponseBody
    public ReturnCodeUtil saveUserInfo(TUser user, Long[] roleId) {
        if (StringUtils.isBlank((CharSequence)user.getName()) || StringUtils.isBlank((CharSequence)user.getUserName()) || StringUtils.isBlank((CharSequence)user.getMobile()) || StringUtils.isBlank((CharSequence)user.getEmail()) || null == roleId || roleId.length == 0) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.userService.saveUser(user, roleId);
            if (null == user.getId()) {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u7f16\u8f91\u7528\u6237{}\u4fe1\u606f\u6210\u529f", (Object)currUser.getUserName(), (Object)user.getName());
                return new ReturnCodeUtil((Object)"\u7528\u6237\u7f16\u8f91\u6210\u529f!");
            }
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u6dfb\u52a0\u7528\u6237{}\u6210\u529f", (Object)currUser.getUserName(), (Object)user.getName());
            return new ReturnCodeUtil((Object)"\u7528\u6237\u4fdd\u5b58\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u7528\u6237\u4fdd\u5b58\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/system/user/delUser.do"})
    @ResponseBody
    public ReturnCodeUtil delUser(Long userId) {
        if (null == userId) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.userService.deleteUser(userId);
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u5220\u9664\u7528\u6237\u6210\u529f,\u7528\u6237Id\u4e3a{}", (Object)currUser.getUserName(), (Object)userId);
            return new ReturnCodeUtil((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u5220\u9664\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/system/user/isExistUserName.do"})
    @ResponseBody
    public ReturnCodeUtil isExistUserName(Long userId, String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            Boolean flag = this.userService.isNameExist(userName, userId);
            if (flag.booleanValue()) {
                return new ReturnCodeUtil(103, "\u7528\u6237\u540d\u91cd\u590d");
            }
            return new ReturnCodeUtil();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u67e5\u8be2\u7528\u6237\u540d\u662f\u5426\u91cd\u590d\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"/system/user/isExistCardId.do"})
    @ResponseBody
    public ReturnCodeUtil isExistCardId(String cardId, String sn) {
        if (StringUtils.isBlank((CharSequence)cardId) || StringUtils.isBlank((CharSequence)sn)) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            Object[] object = this.userService.queryUserCertByCardId(cardId, sn);
            if (((Boolean)object[2]).booleanValue()) {
                return new ReturnCodeUtil(103, "\u5b89\u5168\u5361\u5df2\u88ab\u4f7f\u7528");
            }
            return new ReturnCodeUtil();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u67e5\u8be2\u5b89\u5168\u5361\u662f\u5426\u88ab\u4f7f\u7528\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"/system/user/saveUserCert.do"})
    @ResponseBody
    public ReturnCodeUtil saveUserCert(TUserCert userCert) {
        if (null == userCert.getUserId() || StringUtils.isBlank((CharSequence)userCert.getSn()) || StringUtils.isBlank((CharSequence)userCert.getCardId())) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.userService.saveUserCert(userCert);
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u4e3a\u7528\u6237\u7ed1\u5b9a\u5b89\u5168\u5361{}\u6210\u529f,\u7528\u6237Id\u4e3a:{}", new Object[]{currUser.getUserName(), userCert.getCardId(), userCert.getUserId()});
            return new ReturnCodeUtil((Object)"\u7ed1\u5b9a\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u7ed1\u5b9a\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/system/user/deleteUserCertById.do"})
    @ResponseBody
    public ReturnCodeUtil deleteUserCertById(String cardId) {
        if (null == cardId) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            int n = this.userService.deleteUserCertByCardId(cardId);
            if (n == 1) {
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u89e3\u7ed1\u5b89\u5168\u5361{}\u6210\u529f", (Object)currUser.getUserName(), (Object)cardId);
                return new ReturnCodeUtil((Object)"\u89e3\u7ed1\u6210\u529f");
            }
            this.logger.info("\u89e3\u7ed1cardId\u4e3a" + cardId + "\u5931\u8d25\uff1a\u672a\u7ed1\u5b9a\u5b89\u5168\u5361");
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u89e3\u7ed1\u5b89\u5168\u5361{}\u5931\u8d25:\u7528\u6237\u672a\u7ed1\u5b9a\u5b89\u5168\u5361", (Object)currUser.getUserName(), (Object)cardId);
            return new ReturnCodeUtil(102, "\u89e3\u7ed1\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u89e3\u7ed1\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/system/user/queryUserCertById.do"})
    @ResponseBody
    public ReturnCodeUtil queryUserCertById(Long userId) {
        if (null == userId) {
            return new ReturnCodeUtil(101, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            TUserCert userCert = this.userService.queryUserCertById(userId);
            return new ReturnCodeUtil((Object)userCert);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u67e5\u8be2\u7528\u6237\u7ed1\u5b9a\u5b89\u5168\u5361\u4fe1\u606f\u5f02\u5e38");
        }
    }
}

