/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.util;

import com.xdja.cssp.open.web.util.CertUtil;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CardUtil {
    private static final Logger logger = LoggerFactory.getLogger(CardUtil.class);

    private CardUtil() {
    }

    public static boolean checkCardNo(String cardId, HttpServletRequest request) {
        X509Certificate[] certs = null;
        try {
            certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (null == certs) {
                return false;
            }
            if (null == certs[0]) {
                return false;
            }
            String cardNo = CardUtil.getSubjectProperty((String)certs[0].getSubjectX500Principal().toString(), (String)"cn");
            if (StringUtils.isBlank((CharSequence)cardNo) || !cardId.equalsIgnoreCase(cardNo)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("\u9a8c\u8bc1\u8bc1\u4e66\u5b89\u5168\u5361\u53f7\u5931\u8d25", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getSubjectProperty(String dn, String cn) {
        if (StringUtils.isBlank((CharSequence)dn) || StringUtils.isBlank((CharSequence)cn)) {
            return "";
        }
        String[] items = dn.split(",");
        if (items.length == 0) {
            return "";
        }
        for (int i = 0; i < items.length; ++i) {
            String[] item = items[i].split("=");
            if (item.length != 2) continue;
            for (int j = 0; j < item.length; ++j) {
                item[j] = item[j].trim();
            }
            if (!cn.equalsIgnoreCase(item[0])) continue;
            return item[1];
        }
        return "";
    }

    public static String[] getCardIdAndSn(String cert) {
        String sn;
        String[] cardArray = cert.split("#");
        X509Certificate clientCert = CertUtil.getCertFromStr16((String)cardArray[1]);
        cardArray[1] = sn = clientCert.getSerialNumber().toString(16).toLowerCase();
        return cardArray;
    }
}

