/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.util;

import com.xdja.cssp.open.web.util.FastDfsHttpClientConfig;
import com.xdja.cssp.open.web.util.FileInfo;
import com.xdja.cssp.open.web.util.HttpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class FastDfsHttpClient {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final Pattern ERROR_MSG_PATTERN = Pattern.compile(".+\"errno\":(\\d+).+\"errmsg\":\"(.+)\".+");
    private static final Pattern UPLOAD_PATTERN = Pattern.compile(".+\"fileid\":\"(.+?)\".+");
    private static final Pattern INFO_PATTERN = Pattern.compile(".+\"create_time\":(\\d+).+\"file_size\":(\\d+).+\"source_ip_addr\":\"(.+?)\".+");
    private static final Pattern CRC32_PATTERN = Pattern.compile(".+\"crc32\":(\\d+).+");
    private FastDfsHttpClientConfig config = new FastDfsHttpClientConfig();
    private String auth;

    HttpURLConnection createConnection(String addr) throws IOException {
        URL url = new URL(addr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(this.config.getTimeout());
        conn.setReadTimeout(this.config.getTimeout());
        return conn;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    private HttpException makeHttpException(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return new HttpException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), -1, "Nothing Recved");
        }
        String json = EntityUtils.toString((HttpEntity)response.getEntity()).trim();
        Matcher matcher = ERROR_MSG_PATTERN.matcher(json);
        if (!matcher.matches()) {
            return new HttpException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), -1, "Invalid Error Message Format: " + json);
        }
        int errno = Integer.parseInt(matcher.group(1));
        String errmsg = matcher.group(2);
        return new HttpException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), errno, errmsg);
    }

    private boolean hasError(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode != 200 && statusCode != 206;
    }

    public String upload(byte[] data) throws IOException, HttpException {
        return this.upload(data, null);
    }

    public String upload(byte[] data, String fileName) throws IOException, HttpException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost post = new HttpPost(this.config.getUploadUrl());
        if (fileName == null) {
            fileName = "file";
        }
        Random rand = new Random();
        String boundary = "_" + rand.nextDouble() + "_BOUNDARY_" + rand.nextDouble() + "_";
        post.setHeader("filename", URLEncoder.encode(fileName, "utf-8"));
        post.setHeader(CONTENT_TYPE, "multipart/form-data; boundary=" + boundary);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addBinaryBody("file", data, ContentType.APPLICATION_OCTET_STREAM, fileName);
        builder.setBoundary(boundary);
        HttpEntity entity = builder.build();
        post.setEntity(entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
        if (this.hasError((HttpResponse)response)) {
            throw this.makeHttpException((HttpResponse)response);
        }
        HttpEntity responseEntity = response.getEntity();
        String res = EntityUtils.toString((HttpEntity)responseEntity).replace("\\/", "/").trim();
        Matcher matcher = UPLOAD_PATTERN.matcher(res);
        if (!matcher.matches()) {
            throw new IOException("Invalid Response Format: " + res);
        }
        return matcher.group(1);
    }

    public void append(String fid, byte[] data) throws IOException, HttpException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost post = new HttpPost(this.config.getAppendUrl(fid));
        post.setHeader(CONTENT_TYPE, APPLICATION_OCTET_STREAM);
        ByteArrayEntity entity = new ByteArrayEntity(data);
        post.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
        if (this.hasError((HttpResponse)response)) {
            throw this.makeHttpException((HttpResponse)response);
        }
    }

    public byte[] download(String fid) throws IOException, HttpException {
        return this.download(fid, 0L);
    }

    public byte[] download(String fid, long offset) throws IOException, HttpException {
        return this.download(fid, offset, 0L);
    }

    public byte[] download(String fid, long offset, long length) throws IOException, HttpException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet get = new HttpGet(this.config.getDownloadUrl(fid));
        String range = null;
        range = length == 0L ? String.format("bytes=%d-", offset) : String.format("bytes=%d-%d", offset, offset + length - 1L);
        get.setHeader("Range", range);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        if (this.hasError((HttpResponse)response)) {
            throw this.makeHttpException((HttpResponse)response);
        }
        int total = (int)response.getEntity().getContentLength();
        ByteArrayOutputStream os = new ByteArrayOutputStream(total);
        response.getEntity().writeTo((OutputStream)os);
        return os.toByteArray();
    }

    public void download(String fid, FileOutputStream os) throws IOException, HttpException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet get = new HttpGet(this.config.getDownloadUrl(fid));
        String range = String.format("bytes=%d-", 0);
        get.setHeader("Range", range);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        if (this.hasError((HttpResponse)response)) {
            throw this.makeHttpException((HttpResponse)response);
        }
        int total = (int)response.getEntity().getContentLength();
        ByteArrayOutputStream bao = new ByteArrayOutputStream(total);
        response.getEntity().writeTo((OutputStream)bao);
        this.copyFile((InputStream)new ByteArrayInputStream(bao.toByteArray()), os);
    }

    public void delete(String fid) throws IOException, HttpException {
        HttpGet get;
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = client.execute((HttpUriRequest)(get = new HttpGet(this.config.getDeleteUrl(fid))));
        if (this.hasError((HttpResponse)response)) {
            throw this.makeHttpException((HttpResponse)response);
        }
    }

    public FileInfo getInfo(String fid) throws IOException, HttpException {
        HttpGet get;
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = client.execute((HttpUriRequest)(get = new HttpGet(this.config.getInfoUrl(fid))));
        if (this.hasError((HttpResponse)response)) {
            throw this.makeHttpException((HttpResponse)response);
        }
        if (response.getEntity() == null) {
            throw new IOException("Invalid Response, No Entity");
        }
        String res = EntityUtils.toString((HttpEntity)response.getEntity()).trim();
        Matcher matcher = INFO_PATTERN.matcher(res);
        if (!matcher.matches()) {
            throw new IOException("Invalid Response: " + res);
        }
        long createTime = Long.parseLong(matcher.group(1));
        long fileSize = Long.parseLong(matcher.group(2));
        String srcAddr = matcher.group(3);
        FileInfo ret = new FileInfo(createTime, fileSize, srcAddr);
        return ret;
    }

    public long getCrc32(String fid) throws HttpException, IOException {
        HttpGet get;
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = client.execute((HttpUriRequest)(get = new HttpGet(this.config.getCrc32Url(fid))));
        if (this.hasError((HttpResponse)response)) {
            throw this.makeHttpException((HttpResponse)response);
        }
        String res = EntityUtils.toString((HttpEntity)response.getEntity()).trim();
        Matcher matcher = CRC32_PATTERN.matcher(res);
        if (!matcher.matches()) {
            throw new IOException("Invalid Response: " + res);
        }
        long crc32 = Long.parseLong(matcher.group(1));
        return crc32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(InputStream in, FileOutputStream fs) {
        try {
            byte[] buffer = new byte[1024];
            int byteread = 0;
            while ((byteread = in.read(buffer)) != -1) {
                fs.write(buffer, 0, byteread);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
            try {
                if (fs != null) {
                    fs.flush();
                    fs.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

