/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.util;

import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.core.ApplicationInit;

public class FastDfsHttpClientConfig {
    private String host;
    private String port;
    private String upload_url = "http://{HOST}:{PORT}/upload";
    private String download_url = "http://{HOST}:{PORT}/download/{FID}";
    private String append_url = "http://{HOST}:{PORT}/append/{FID}";
    private String delete_url = "http://{HOST}:{PORT}/delete/{FID}";
    private String info_url = "http://{HOST}:{PORT}/info/{FID}";
    private String crc32_url = "http://{HOST}:{PORT}/crc32/{FID}";
    private String uploadUrl;
    private String appendUrl;
    private String downloadUrl;
    private String deleteUrl;
    private String infoUrl;
    private String crc32Url;
    private int timeout = 3000;

    FastDfsHttpClientConfig() {
        Prop prop = ApplicationInit.sysProp;
        this.host = prop.get("fdfs.server.host");
        this.port = prop.get("fdfs.server.port");
        this.uploadUrl = this.upload_url.replace("{HOST}", this.host).replace("{PORT}", this.port);
        this.appendUrl = this.append_url.replace("{HOST}", this.host).replace("{PORT}", this.port);
        this.downloadUrl = this.download_url.replace("{HOST}", this.host).replace("{PORT}", this.port);
        this.deleteUrl = this.delete_url.replace("{HOST}", this.host).replace("{PORT}", this.port);
        this.infoUrl = this.info_url.replace("{HOST}", this.host).replace("{PORT}", this.port);
        this.crc32Url = this.crc32_url.replace("{HOST}", this.host).replace("{PORT}", this.port);
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public String getAppendUrl(String fid) {
        return this.appendUrl.replace("{FID}", fid);
    }

    public String getDownloadUrl(String fid) {
        return this.downloadUrl.replace("{FID}", fid);
    }

    public String getDeleteUrl(String fid) {
        return this.deleteUrl.replace("{FID}", fid);
    }

    public String getInfoUrl(String fid) {
        return this.infoUrl.replace("{FID}", fid);
    }

    public String getCrc32Url(String fid) {
        return this.crc32Url.replace("{FID}", fid);
    }

    public int getTimeout() {
        return this.timeout;
    }
}

