/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.util;

import com.xdja.cssp.open.web.util.FastDfsHttpClient;
import com.xdja.cssp.open.web.util.HttpException;
import com.xdja.fastdfs.client.sdk.FastDfsClientBuilder;
import com.xdja.fastdfs.client.sdk.FastDfsException;
import com.xdja.fastdfs.client.sdk.IFastDfsClient;
import com.xdja.platform.core.ApplicationInit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class FileUtil {
    private static final Integer auth = ApplicationInit.sysProp.getInt("fdfs.auth");
    private static FastDfsHttpClient client = new FastDfsHttpClient();

    public static String upload(String fileName, File file) throws IOException, FastDfsException, HttpException {
        if (auth == 1) {
            return ApplicationInit.getFastDfsClient().upload(fileName, file);
        }
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int n = 0;
        while ((n = fis.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        String path = client.upload(bos.toByteArray(), fileName);
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception ine) {
            ine.getStackTrace();
        }
        try {
            if (bos != null) {
                bos.close();
            }
        }
        catch (Exception ine) {
            ine.getStackTrace();
        }
        return path;
    }

    public static String uploadLogo(InputStream inputStream, String fileName) throws IOException, FastDfsException, HttpException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        String path = client.upload(bos.toByteArray(), fileName);
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception ine) {
            ine.getStackTrace();
        }
        try {
            if (bos != null) {
                bos.close();
            }
        }
        catch (Exception ine) {
            ine.getStackTrace();
        }
        return path;
    }

    public static void download(String fId, FileOutputStream os) throws IOException, FastDfsException, HttpException {
        if (auth == 1) {
            ApplicationInit.getFastDfsClient().download(fId, (OutputStream)os);
        } else {
            client.download(fId, os);
        }
    }

    public static void delete(String fId) throws IOException, FastDfsException, HttpException {
        if (auth == 1) {
            ApplicationInit.getFastDfsClient().delete(fId);
        } else {
            client.delete(fId);
        }
    }

    public static Object getFileInfo(String fId) throws IOException, FastDfsException, HttpException {
        if (auth == 1) {
            return ApplicationInit.getFastDfsClient().info(fId);
        }
        return client.getInfo(fId);
    }

    public static void main(String[] args) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("fdfs.server.host", "11.12.110.150");
        properties.setProperty("fdfs.server.port", "80");
        properties.setProperty("fdfs.client.appid", "app_fdfs_test_001");
        properties.setProperty("fdfs.client.appkey", "c7d05e987f94865207d58ff746bfdf38");
        IFastDfsClient client = FastDfsClientBuilder.builder((Properties)properties);
        File file = new File("E://fast_client.properties");
        String fId = client.upload("fast_client", file);
        System.out.println(fId);
        System.out.println(client.info(fId));
        client.delete(fId);
    }

    public static boolean isPicture(String fileName) {
        String[] imtype = ApplicationInit.getPictureSuffix().split(",");
        boolean result = false;
        if (fileName != null && !"".equals(fileName)) {
            for (int i = 0; i < imtype.length; ++i) {
                String zt = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()).toLowerCase();
                if (!zt.equals(imtype[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isInstallPackage(String fileName) {
        String[] imtype = ApplicationInit.getPackageSuffix().split(",");
        boolean result = false;
        if (fileName != null && !"".equals(fileName)) {
            for (int i = 0; i < imtype.length; ++i) {
                String zt = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()).toLowerCase();
                if (!zt.equals(imtype[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isAppCenterInstallPackage(String fileName) {
        String[] imtype = ApplicationInit.getPackageSuffix().split(",");
        boolean result = false;
        if (fileName != null && !"".equals(fileName)) {
            for (int i = 0; i < imtype.length; ++i) {
                String zt = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()).toLowerCase();
                if (!zt.equals(imtype[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static String getnowTimeforNewFileName(String filename) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(currentTime);
        dateString = dateString + filename.substring(filename.lastIndexOf("."), filename.length());
        return dateString;
    }

    public static String getnowTimeforNewDirectoryName() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }
}

