/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.core;

import com.xdja.fastdfs.client.sdk.FastDfsClientBuilder;
import com.xdja.fastdfs.client.sdk.IFastDfsClient;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.core.Constants;
import com.xdja.platform.rpc.consumer.IService;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInit {
    public static Prop sysProp;
    private static final Logger logger;
    private static final String SERVICES = "open";
    public static final String SERVERIP = "127.0.0.1";
    public static final int SERVERPORT = 6666;
    public static final int SESSION_TIMEOUT = 10000;
    private static IFastDfsClient fastDfsClient;

    public static void initialize() {
        String[] services;
        sysProp = PropKit.use((String)"system.properties");
        Service rpcService = null;
        for (String service : services = StringUtils.split((String)sysProp.get("rpc.services", SERVICES), (String)"|")) {
            rpcService = new Service();
            rpcService.setAddr(sysProp.get("rpc." + service + ".ip", SERVERIP));
            rpcService.setPort(sysProp.getInt("rpc." + service + ".port", Integer.valueOf(6666)).intValue());
            rpcService.setTimeoutMillis((long)sysProp.getInt("rpc." + service + ".timeoutMillis", Integer.valueOf(10000)).intValue());
            ServicePool.addService((String)service, (IService)rpcService);
            logger.info("\u6ce8\u518crpc service\uff08{}==>{}:{}\uff09\u6210\u529f", new Object[]{service, rpcService.getAddr(), rpcService.getPort()});
        }
        Constants.SDK_PICTURE_SUFFIX = sysProp.get("sdk.picture.suffix");
        Constants.SDK_PACKAGE_SUFFIX = sysProp.get("sdk.package.suffix");
        Constants.SDK_PACKAGE_SIZE = sysProp.get("sdk.package.size");
        Constants.SDK_CDN_URL = sysProp.get("sdk.cdn.url");
        Constants.SERVER_AUTHFILE_CDN_URL = sysProp.get("server.authfile.cdn.url");
        Constants.SERVER_SDK_CDN_URL = sysProp.get("server.sdk.cdn.url");
        Constants.SDK_API_URL = sysProp.get("sdk.api.url");
        Constants.API_SDK_DIRECTORY = sysProp.get("api.sdk.directory");
        Constants.FASTDFS_DOWNLOAD_URL = sysProp.get("fast.server.url");
        Constants.FILE_SWITCH_TIME = sysProp.getLong("file.switch.time");
    }

    public static IFastDfsClient getFastDfsClient() throws IOException {
        if (fastDfsClient == null) {
            Properties properties = new Properties();
            properties.setProperty("fdfs.server.host", sysProp.get("fdfs.server.host"));
            properties.setProperty("fdfs.server.port", sysProp.get("fdfs.server.port"));
            properties.setProperty("fdfs.client.appid", sysProp.get("fdfs.client.appid"));
            properties.setProperty("fdfs.client.appkey", sysProp.get("fdfs.client.appkey"));
            fastDfsClient = FastDfsClientBuilder.builder((Properties)properties);
            return fastDfsClient;
        }
        return fastDfsClient;
    }

    public static String getPictureSuffix() {
        return sysProp.get("sdk.picture.suffix");
    }

    public static String getPackageSuffix() {
        return sysProp.get("sdk.package.suffix");
    }

    static {
        logger = LoggerFactory.getLogger(ApplicationInit.class);
    }
}

