/**
 * 浏览器信息
 * 说明:
 * 1.系统名称和浏览器名称统一用小写并且中间不能有空格
 *
 * 2.pluin-插件类型,可选值为:(npapi, activex, websocket)
 *  type-浏览器内核,可选值为:(chrome, trident, gecko)
 *  .chrome-谷歌浏览器内核
 *  .trident-IE浏览器内核
 *  .gecko-火狐浏览器内核
 *
 * 3.version-浏览器版本表示法:
 *  .某个版本号,如'35' 表示35版本
 *  .多个版本号,如'35|36|37' 表示35、36、37版本
 *  .一个正则表达式,如[36-41] 表示从36到41的所有版本
 *  .一个表达式,如[36-*] 表示从36以後的所有版本
 *  .如果表示的各个版本有交叉则以第一个匹配的为准, 如
 *  opera: [
 {
   version: '35-40',
   core: [
       {
           x64: true,
           type: 'chrome',
           plugin: 'websocket'
       }
   ]
},
 {
     version: '35',
     core: [
         {
             x64: false,
             type: 'chrome',
             plugin: 'npapi'
         }
     ]
 }

 ]
 如果当前浏览器版本号是35则匹配[35-40],使用websocket插件机制
 */
var browsers = {
    windowsxp: {
		x86: {
			maxthon: [
				{
					version: '4.0-4.9',
					core: [
						{
							x64: false,
							type: 'chrome',
							plugin: 'npapi'
						}
					]
				}
			],

			qqbrowser: [
				{
					version: '9.0-*',
					core: [
						{
							x64: false,
							type: 'chrome',
							plugin: 'websocket'
						}
					]
				},
				{
					version: '7.4-*',
					core: [
						{
							x64: false,
							type: 'trident',
							plugin: 'activex'
						}
					]
				}
			],

			chrome: [
				{
					version: '30-41',
					core: [
						{
							x64: false,
							type: 'chrome',
							plugin: 'npapi'
						}
					]
				},
				{
					version: '42-*',
					core: [
						{
							x64: false,
							type: 'chrome',
							plugin: 'websocket'
						}
					]
				}
			],

			'2345explorer': [
				{
					version: '6.0-6.5',
					core: [
						{
							x64: false,
							type: 'chrome',
							plugin: 'npapi'
						}
					]
				}
			],

			liebaobrowser: [
				{
					version: '4.3-5.3',
					core: [
						{
							x64: false,
							type: 'chrome',
							plugin: 'npapi'
						}
					]
				}
			],

			ucbrowser: [
				{
					version: '1.0-5.6',
					core: [
						{
							x64: false,
							type: 'chrome',
							plugin: 'npapi'
						}
					]
				},
				{
					version: '5.4-5.6',
					core: [
						{
							x64: false,
							type: 'trident',
							plugin: 'activex'
						}
					]
				}
			],

			baidubrowser: [
				{
					version: '7.4-8.2',
					core: [
						{
							x64: false,
							type: 'chrome',
							plugin: 'npapi'
						}
					]
				},
				{
					version: '7.0-8.2',
					core: [
						{
							x64: false,
							type: 'trident',
							plugin: 'activex'
						}
					]
				}
			],

			opera: [
				{
					version: '25-36',
					core: [
						{
							x64: false,
							type: 'chrome',
							plugin: 'npapi'
						}
					]
				}
			],

			firefox: [
				{
					version: '28-35',
					core: [
						{
							x64: false,
							type: 'gecko',
							plugin: 'npapi'
						}
					]
				},
				{
					version: '36-*',
					core: [
						{
							x64: false,
							type: 'gecko',
							plugin: 'websocket'
						}
					]
				}
			]
		}
    },
    windows7: {
        x64: {
            maxthon: [
                {
                    version: '4.0-4.9',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            qqbrowser: [
                {
                    version: '9.0-*',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                },
                {
                    version: '7.4-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            chrome: [
                {
                    version: '30-41',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '42-*',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                },
                {
                    version: '37-*',
                    core: [
                        {
                            x64: true,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                }
            ],

            '2345explorer': [
                {
                    version: '6.0-6.5',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            liebaobrowser: [
                {
                    version: '4.3-5.3',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            ucbrowser: [
                {
                    version: '1.0-5.6',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '5.4-5.6',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            baidubrowser: [
                {
                    version: '7.4-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '7.0-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            opera: [
                {
                    version: '25-36',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            firefox: [
                {
                    version: '28-35',
                    core: [
                        {
                            x64: false,
                            type: 'gecko',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '36-*',
                    core: [
                        {
                            x64: false,
                            type: 'gecko',
                            plugin: 'websocket'
                        }

                    ]
                },
                {
                    version: '42-*',
                    core: [
                        {
                            x64: true,
                            type: 'gecko',
                            plugin: 'websocket'
                        }

                    ]
                }
            ]

        },
        x86: {
            maxthon: [
                {
                    version: '4.0-4.9',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            qqbrowser: [
                {
                    version: '9.0-*',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                },
                {
                    version: '7.4-*',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            chrome: [
                {
                    version: '30-41',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '42-*',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                }
            ],

            '2345explorer': [
                {
                    version: '6.0-6.5',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            liebaobrowser: [
                {
                    version: '4.3-5.3',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            ucbrowser: [
                {
                    version: '1.0-5.6',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '5.4-5.6',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            baidubrowser: [
                {
                    version: '7.4-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '7.0-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            opera: [
                {
                    version: '25-36',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            firefox: [
                {
                    version: '28-35',
                    core: [
                        {
                            x64: false,
                            type: 'gecko',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '36-*',
                    core: [
                        {
                            x64: false,
                            type: 'gecko',
                            plugin: 'websocket'
                        }
                    ]
                }
            ]

        }

    },
    windows8: {
        x64: {
            maxthon: [
                {
                    version: '4.0-4.9',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            qqbrowser: [
                {
                    version: '9.0-*',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                },
                {
                    version: '7.4-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            chrome: [
                {
                    version: '30-41',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '42-*',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                },
                {
                    version: '37-*',
                    core: [
                        {
                            x64: true,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                }
            ],

            '2345explorer': [
                {
                    version: '6.0-6.5',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            liebaobrowser: [
                {
                    version: '4.3-5.3',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            ucbrowser: [
                {
                    version: '1.0-5.6',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '5.4-5.6',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            baidubrowser: [
                {
                    version: '7.4-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '7.0-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            opera: [
                {
                    version: '25-36',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            firefox: [
                {
                    version: '28-35',
                    core: [
                        {
                            x64: false,
                            type: 'gecko',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '36-*',
                    core: [
                        {
                            x64: false,
                            type: 'gecko',
                            plugin: 'websocket'
                        }

                    ]
                },
                {
                    version: '42-*',
                    core: [
                        {
                            x64: true,
                            type: 'gecko',
                            plugin: 'websocket'
                        }

                    ]
                }
            ]

      }
    },
    "windows8.1": {
    x64: {
      maxthon: [
        {
          version: '4.0-4.9',
          core: [
            {
              x64: false,
              type: 'chrome',
              plugin: 'npapi'
            }
          ]
        }
      ],

      qqbrowser: [
        {
          version: '9.0-*',
          core: [
            {
              x64: false,
              type: 'chrome',
              plugin: 'websocket'
            }
          ]
        },
        {
          version: '7.4-8.2',
          core: [
            {
              x64: false,
              type: 'trident',
              plugin: 'activex'
            }
          ]
        }
      ],

      chrome: [
        {
          version: '30-41',
          core: [
            {
              x64: false,
              type: 'chrome',
              plugin: 'npapi'
            }
          ]
        },
        {
          version: '42-*',
          core: [
            {
              x64: false,
              type: 'chrome',
              plugin: 'websocket'
            }
          ]
        },
        {
          version: '37-*',
          core: [
            {
              x64: true,
              type: 'chrome',
              plugin: 'websocket'
            }
          ]
        }
      ],

      '2345explorer': [
        {
          version: '6.0-6.5',
          core: [
            {
              x64: false,
              type: 'chrome',
              plugin: 'npapi'
            }
          ]
        }
      ],

      liebaobrowser: [
        {
          version: '4.3-5.3',
          core: [
            {
              x64: false,
              type: 'chrome',
              plugin: 'npapi'
            }
          ]
        }
      ],

      ucbrowser: [
        {
          version: '1.0-5.6',
          core: [
            {
              x64: false,
              type: 'chrome',
              plugin: 'npapi'
            }
          ]
        },
        {
          version: '5.4-5.6',
          core: [
            {
              x64: false,
              type: 'trident',
              plugin: 'activex'
            }
          ]
        }
      ],

      baidubrowser: [
        {
          version: '7.4-8.2',
          core: [
            {
              x64: false,
              type: 'chrome',
              plugin: 'npapi'
            }
          ]
        },
        {
          version: '7.0-8.2',
          core: [
            {
              x64: false,
              type: 'trident',
              plugin: 'activex'
            }
          ]
        }
      ],

      opera: [
        {
          version: '25-36',
          core: [
            {
              x64: false,
              type: 'chrome',
              plugin: 'npapi'
            }
          ]
        }
      ],

      firefox: [
        {
          version: '28-35',
          core: [
            {
              x64: false,
              type: 'gecko',
              plugin: 'npapi'
            }
          ]
        },
        {
          version: '36-*',
          core: [
            {
              x64: false,
              type: 'gecko',
              plugin: 'websocket'
            }

          ]
        },
        {
          version: '42-*',
          core: [
            {
              x64: true,
              type: 'gecko',
              plugin: 'websocket'
            }

          ]
        }
      ]

    }
  },
    windows10: {
        x64: {
            maxthon: [
                {
                    version: '4.0-4.9',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            qqbrowser: [
                {
                    version: '9.0-*',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                },
                {
                    version: '7.4-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            chrome: [
                {
                    version: '30-41',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '42-*',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                },
                {
                    version: '37-*',
                    core: [
                        {
                            x64: true,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                }
            ],

            '2345explorer': [
                {
                    version: '6.0-6.5',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            liebaobrowser: [
                {
                    version: '4.3-5.3',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            ucbrowser: [
                {
                    version: '1.0-5.6',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '5.4-5.6',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            baidubrowser: [
                {
                    version: '7.4-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '7.0-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            opera: [
                {
                    version: '25-36',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            firefox: [
                {
                    version: '28-35',
                    core: [
                        {
                            x64: false,
                            type: 'gecko',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '36-*',
                    core: [
                        {
                            x64: false,
                            type: 'gecko',
                            plugin: 'websocket'
                        }

                    ]
                },
                {
                    version: '42-*',
                    core: [
                        {
                            x64: true,
                            type: 'gecko',
                            plugin: 'websocket'
                        }

                    ]
                }
            ],

            edge: [
                {
                    version: '12-*',
                    core: [
                        {
                            x64: true,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                }
            ]

        },
        x86: {
            maxthon: [
                {
                    version: '4.0-4.9',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            qqbrowser: [
                {
                    version: '9.0-*',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                },
                {
                    version: '7.4-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            chrome: [
                {
                    version: '30-41',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '42-*',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                }
            ],

            '2345explorer': [
                {
                    version: '6.0-6.5',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            liebaobrowser: [
                {
                    version: '4.3-5.3',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            ucbrowser: [
                {
                    version: '1.0-5.6',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '5.4-5.6',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            baidubrowser: [
                {
                    version: '7.4-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '7.0-8.2',
                    core: [
                        {
                            x64: false,
                            type: 'trident',
                            plugin: 'activex'
                        }
                    ]
                }
            ],

            opera: [
                {
                    version: '25-36',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'npapi'
                        }
                    ]
                }
            ],

            firefox: [
                {
                    version: '28-35',
                    core: [
                        {
                            x64: false,
                            type: 'gecko',
                            plugin: 'npapi'
                        }
                    ]
                },
                {
                    version: '36-*',
                    core: [
                        {
                            x64: false,
                            type: 'gecko',
                            plugin: 'websocket'
                        }
                    ]
                }
            ],

            edge: [
                {
                    version: '12-*',
                    core: [
                        {
                            x64: false,
                            type: 'chrome',
                            plugin: 'websocket'
                        }
                    ]
                }
            ]
        }

    }
};
