/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pmc.service.terminalbind.business.implement;

import com.xdja.platform.microservice.db.nutz.Dao;
import com.xdja.platform.microservice.db.nutz.Paging;
import com.xdja.pmc.service.terminalbind.bean.BindStatus;
import com.xdja.pmc.service.terminalbind.bean.TPmcUkAuthcode;
import com.xdja.pmc.service.terminalbind.bean.TerminalBindInfo;
import com.xdja.pmc.service.terminalbind.bean.TerminalBindMessage;
import com.xdja.pmc.service.terminalbind.business.interfaces.TerminalBindInfoBusiness;
import java.util.HashMap;
import java.util.List;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.sql.Sql;
import org.springframework.stereotype.Service;

@Service
public class TerminalBindInfoBusinessImpl
implements TerminalBindInfoBusiness {
    private Dao dao = Dao.use((String)"db::pmc");

    @Override
    public void saveTerminalBindInfo(TerminalBindInfo info) {
        this.dao.insert((Object)info);
    }

    @Override
    public TerminalBindInfo queryTerminalBindInfo(String bindSeq, int timeout) {
        String sql = "SELECT n_id id, c_device_id deviceId, c_message message," + "c_account account, c_device_name deviceName," + " CASE WHEN n_create_time < @now AND n_status=@noDo THEN 4 ELSE n_status END status,n_create_time createTime " + " FROM t_pmc_terminal_bind_info WHERE c_bind_seq=@bindSeq " + " ORDER BY n_create_time desc";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("noDo", BindStatus.unProcess.getValue());
        params.put("bindSeq", bindSeq);
        params.put("now", System.currentTimeMillis() - (long)(timeout * 60 * 1000));
        return (TerminalBindInfo)this.dao.queryForBean(TerminalBindInfo.class, sql, params);
    }

    @Override
    public void updateTerminalBindInfo(TerminalBindInfo info) {
        Chain chain = Chain.make((String)"n_status", (Object)info.getStatus());
        if (info.getBindStatus() == BindStatus.agree) {
            chain.add("c_device_name", (Object)info.getDeviceName());
        }
        this.dao.update("t_pmc_terminal_bind_info", chain, (Condition)Cnd.where((String)"c_bind_seq", (String)"=", (Object)info.getBindSeq()));
    }

    @Override
    public Paging<TerminalBindInfo> queryList(String account, int timeout, Integer pageNo, Integer pageSize) {
        String sql = "SELECT n_id, c_device_id, c_message, " + " c_card_no, c_cert_sn, n_create_time,c_bind_seq, " + " CASE WHEN n_create_time < @now AND n_status=@noDo THEN 4 ELSE n_status END n_status " + " FROM t_pmc_terminal_bind_info WHERE c_account=@account " + " ORDER BY n_create_time desc ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("noDo", BindStatus.unProcess.getValue());
        params.put("account", account);
        params.put("now", System.currentTimeMillis() - (long)(timeout * 60 * 1000));
        return this.dao.queryForPaging(TerminalBindInfo.class, sql, params, pageNo.intValue(), pageSize.intValue());
    }

    @Override
    public List<TerminalBindMessage> queryNotprocess(String account, int timeout) {
        String sql = "SELECT n_create_time createTime, c_bind_seq bindSeq " + "FROM t_pmc_terminal_bind_info " + "WHERE c_account=@account AND n_create_time>@now AND n_status=@unprocess";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account", account);
        params.put("now", System.currentTimeMillis() - (long)(timeout * 60 * 1000));
        params.put("unprocess", BindStatus.unProcess.getValue());
        return this.dao.queryForList(TerminalBindMessage.class, sql, params);
    }

    @Override
    public void delTerminalBindInfos(String[] ids) {
        Sql sql = Sqls.create((String)"DELETE FROM t_pmc_terminal_bind_info $condition");
        sql.setCondition((Condition)Cnd.where((String)"n_id", (String)"in", (Object)ids));
        this.dao.execute(new Sql[]{sql});
    }

    @Override
    public boolean isProcess(String account, String deviceId, int timeout) {
        Cnd cnd = Cnd.where((String)"c_device_id", (String)"=", (Object)deviceId).and("c_account", "=", (Object)account).and("n_create_time", ">", (Object)(System.currentTimeMillis() - (long)(timeout * 60 * 1000))).and("n_status", "=", (Object)BindStatus.unProcess.getValue());
        return this.dao.count("t_pmc_terminal_bind_info", (Condition)cnd) > 0;
    }

    @Override
    public long queryUnreadCount(String account) {
        Cnd cnd = Cnd.where((String)"c_account", (String)"=", (Object)account).and("n_read", "=", (Object)2);
        return this.dao.count("t_pmc_terminal_bind_info", (Condition)cnd);
    }

    @Override
    public void updateReaded(String account) {
        Chain chain = Chain.make((String)"n_read", (Object)1);
        Cnd cnd = Cnd.where((String)"c_account", (String)"=", (Object)account).and("n_read", "=", (Object)2);
        this.dao.update("t_pmc_terminal_bind_info", chain, (Condition)cnd);
    }

    @Override
    public void updateReaded(String account, String bindSeq) {
        Chain chain = Chain.make((String)"n_read", (Object)1);
        Cnd cnd = Cnd.where((String)"c_bind_seq", (String)"=", (Object)bindSeq).and("c_account", "=", (Object)account);
        this.dao.update("t_pmc_terminal_bind_info", chain, (Condition)cnd);
    }

    @Override
    public TPmcUkAuthcode getPmcUkAuthcode(String checkCode) {
        Cnd cnd = Cnd.where((String)"message", (String)"=", (Object)checkCode);
        cnd.getOrderBy().desc("createTime");
        List list = this.dao.query(TPmcUkAuthcode.class, (Condition)cnd);
        if (list != null && list.size() > 0) {
            return (TPmcUkAuthcode)list.get(0);
        }
        return null;
    }
}

