/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pmc.service.terminalbind.implement;

import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.pmc.service.terminalbind.bean.TPmcUkAuthcode;
import com.xdja.pmc.service.terminalbind.bean.TerminalBindInfo;
import com.xdja.pmc.service.terminalbind.bean.TerminalBindMessage;
import com.xdja.pmc.service.terminalbind.business.interfaces.TerminalBindInfoBusiness;
import com.xdja.pmc.service.terminalbind.interfaces.TerminalBindInfoService;
import com.xdja.pmc.unlock.UidGenerate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TerminalBindInfoServiceImpl
implements TerminalBindInfoService {
    @Autowired
    private TerminalBindInfoBusiness business;

    public void saveTerminalBindInfo(TerminalBindInfo info) {
        this.business.saveTerminalBindInfo(info);
    }

    public TerminalBindInfo queryTerminalBindInfo(String bindSeq, int timeout) {
        return this.business.queryTerminalBindInfo(bindSeq, timeout);
    }

    public void updateTerminalBindInfo(TerminalBindInfo info) {
        this.business.updateTerminalBindInfo(info);
    }

    public LitePaging<TerminalBindInfo> queryList(String account, int timeout, Integer pageNo, Integer pageSize) {
        return PagingConverter.convert(this.business.queryList(account, timeout, pageNo, pageSize));
    }

    public List<TerminalBindMessage> queryNotprocess(String account, int timeout) {
        return this.business.queryNotprocess(account, timeout);
    }

    public void delTerminalBindInfos(String[] ids) {
        this.business.delTerminalBindInfos(ids);
    }

    public boolean isProcess(String account, String deviceId, int timeout) {
        return this.business.isProcess(account, deviceId, timeout);
    }

    public long queryUnreadCount(String account) {
        return this.business.queryUnreadCount(account);
    }

    public void updateReaded(String account) {
        this.business.updateReaded(account);
    }

    public void updateReaded(String account, String bindSeq) {
        this.business.updateReaded(account, bindSeq);
    }

    public Map<String, Object> checkCode(String checkCode, String time) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TPmcUkAuthcode ukAuthcode = this.business.getPmcUkAuthcode(checkCode);
        if (ukAuthcode == null) {
            result.put("success", false);
            result.put("message", "\u9a8c\u8bc1\u7801\u9519\u8bef");
            return result;
        }
        long valid = System.currentTimeMillis() - ukAuthcode.getCreateTime();
        if (valid > Long.valueOf(time) * 1000L) {
            result.put("success", false);
            result.put("message", "\u9a8c\u8bc1\u7801\u8d85\u65f6");
            return result;
        }
        result.put("success", true);
        result.put("ukAuthcode", ukAuthcode);
        result.put("deviceUUID", UidGenerate.getDeviceUUID((String)ukAuthcode.getCardno(), (String)ukAuthcode.getCertSn()));
        return result;
    }
}

