/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pmc.service.business.implement;

import com.xdja.platform.microservice.db.nutz.Dao;
import com.xdja.platform.util.DateTimeUtil;
import com.xdja.pmc.service.business.interfaces.TerminalInfoBusiness;
import com.xdja.pmc.service.instruction.entity.TerminalOnline;
import com.xdja.pmc.service.terminalmanager.bean.TerminalKeyInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.springframework.stereotype.Service;

@Service
public class TerminalInfoBusinessImpl
implements TerminalInfoBusiness {
    private Dao dao = Dao.use((String)"db::pmc");
    public static final int LOGTYPE_LOGIN = 1;

    @Override
    public Map<String, String> getUSBKeyLastLoginTime(String account, List<String> cardNos) {
        String sb = "SELECT c_card_id cardId, MAX(n_log_time) logTime FROM t_pmc_system_log " + "$condition AND n_log_type=@logType " + "GROUP BY c_card_id ORDER BY n_log_time DESC";
        Sql sql = Sqls.create((String)sb);
        sql.setCondition((Condition)Cnd.where((String)"c_account", (String)"=", (Object)account).and("c_card_id", "IN", cardNos));
        sql.params().set("logType", (Object)1).set("account", (Object)account).set("cardNos", cardNos);
        final HashMap<String, String> result = new HashMap<String, String>();
        sql.setCallback(new SqlCallback(){

            public Object invoke(Connection conn, ResultSet rs, Sql sql) throws SQLException {
                while (rs.next()) {
                    result.put(rs.getString("cardId"), DateTimeUtil.longToDateStr((long)rs.getLong("logTime")));
                }
                return null;
            }
        });
        this.dao.execute(new Sql[]{sql});
        return result;
    }

    @Override
    public Map<String, String> queryTermnalOnlineStatusList(List<String> imeis) {
        List list = this.dao.query(TerminalOnline.class, (Condition)Cnd.where((String)"imei", (String)"in", imeis));
        HashMap<String, String> onlines = new HashMap<String, String>();
        if (list != null && list.size() > 0) {
            for (TerminalOnline online : list) {
                onlines.put(online.getImei(), online.getOnline().toString());
            }
        }
        return onlines;
    }

    @Override
    public Map<String, String> queryTermnalOnlineAndIsableStatusList(List<String> imeis) {
        List list = this.dao.query(TerminalOnline.class, (Condition)Cnd.where((String)"imei", (String)"in", imeis));
        HashMap<String, String> onlines = new HashMap<String, String>();
        if (list != null && list.size() > 0) {
            for (TerminalOnline online : list) {
                onlines.put(online.getImei(), online.getOnline().toString() + "@" + online.getStatus());
            }
        }
        return onlines;
    }

    @Override
    public void saveTerminalKey(TerminalKeyInfo terminalKeyInfo) {
        this.dao.insert((Object)terminalKeyInfo);
    }

    @Override
    public TerminalKeyInfo getTerminalKeyByCardno(String cardno, Integer opt) {
        return (TerminalKeyInfo)this.dao.fetch(TerminalKeyInfo.class, (Condition)Cnd.where((String)"cardno", (String)"=", (Object)cardno).and("opt", "=", (Object)opt));
    }

    @Override
    public void updateDeviceKey(TerminalKeyInfo keyInfo) {
        this.dao.updateIgnoreNull((Object)keyInfo);
    }

    @Override
    public List<TerminalKeyInfo> queryTerminalKeysForAddOrDel(Integer status, Integer opt) {
        return this.dao.query(TerminalKeyInfo.class, (Condition)Cnd.where((String)"status", (String)"=", (Object)status).and("opt", "=", (Object)opt));
    }
}

