/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pmc.service.implement;

import com.xdja.cssp.pmc.redis.init.RedisClient;
import com.xdja.mdm.mdms.push.service.api.PushService;
import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.pmc.service.business.interfaces.TerminalInfoBusiness;
import com.xdja.pmc.service.core.ServiceConstants;
import com.xdja.pmc.service.terminalmanager.bean.TerminalKeyInfo;
import com.xdja.pmc.service.terminalmanager.interfaces.TerminalInfoService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TerminalInfoServiceImpl
implements TerminalInfoService {
    @Autowired
    private TerminalInfoBusiness business;
    @Resource
    private RedisClient redisClient;
    private PushService pushService = (PushService)DefaultServiceRefer.getServiceRefer(PushService.class);
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public Map<String, String> getUSBKeyLastLoginTime(String account, List<String> cardNos) {
        return this.business.getUSBKeyLastLoginTime(account, cardNos);
    }

    public Map<String, String> queryTermnalOnlineStatusList(List<String> imeis) {
        if (imeis != null && imeis.size() > 0) {
            return this.business.queryTermnalOnlineStatusList(imeis);
        }
        return null;
    }

    public Map<String, String> queryTermnalOnlineAndIsableStatusList(List<String> imeis) {
        if (imeis != null && imeis.size() > 0) {
            HashMap<String, String> map = new HashMap();
            map = this.business.queryTermnalOnlineAndIsableStatusList(imeis);
            return map;
        }
        return null;
    }

    public void saveBindTerminalKuep(TerminalKeyInfo terminalKeyInfo, String redisKey, String redisValue) {
        TerminalKeyInfo keyInfo = this.business.getTerminalKeyByCardno(terminalKeyInfo.getCardno(), terminalKeyInfo.getOpt());
        if (keyInfo != null) {
            this.business.updateDeviceKey(terminalKeyInfo);
        } else {
            this.business.saveTerminalKey(terminalKeyInfo);
        }
        try {
            this.redisClient.lpush(redisKey, new String[]{redisValue});
        }
        catch (Exception e1) {
            this.logger.error("\u88c5\u8f7d\u8bbe\u5907\u5bc6\u94a5\u4fe1\u606f\u5230redis\u7f13\u5b58\u51fa\u73b0\u5f02\u5e38\uff0c\u8bbe\u5907\u4e32\u53f7:{}", (Object)terminalKeyInfo.getCardno(), (Object)e1);
        }
    }

    public boolean updateDeviceKeyAddStatus(String cardno, Integer addStatus) {
        TerminalKeyInfo keyInfo = this.business.getTerminalKeyByCardno(cardno, ServiceConstants.OPT_ADD);
        if (keyInfo != null) {
            keyInfo.setStatus(addStatus);
            this.business.updateDeviceKey(keyInfo);
        }
        return true;
    }

    public boolean updateDeviceKeyDelStatus(String cardno, Integer delStatus) {
        TerminalKeyInfo keyInfo = this.business.getTerminalKeyByCardno(cardno, ServiceConstants.OPT_DEL);
        if (keyInfo != null) {
            keyInfo.setStatus(delStatus);
            this.business.updateDeviceKey(keyInfo);
        }
        return true;
    }

    public List<TerminalKeyInfo> queryTerminalKeysForAdd() {
        return this.business.queryTerminalKeysForAddOrDel(ServiceConstants.IS_NOT_EXECUTE, ServiceConstants.OPT_ADD);
    }

    public List<TerminalKeyInfo> queryTerminalKeysForDel() {
        return this.business.queryTerminalKeysForAddOrDel(ServiceConstants.IS_NOT_EXECUTE, ServiceConstants.OPT_DEL);
    }
}

