package com.xdja.sboxClient.main;

import com.xdja.sboxClient.common.DefaultValues;
import com.xdja.sboxClient.common.ReturnValues;
import com.xdja.sboxClient.common.Utils;
import com.xdja.sboxClient.rpcstubpool.RpcClientInfo;
import com.xdja.sboxClient.rpcstubpool.RpcStubPool;
import com.xdja.sboxClient.rpcstubpool.RpcStubPoolConfig;
import com.xdja.sboxClient.rpcstubpool.RpcStubPoolFactory;
import com.xdja.sboxClient.thriftstub.ThirdServiceStub;
import com.xdja.thrift.datatype.ResListStr;
import com.xdja.thrift.datatype.ResStr;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * Created by xdjaxa on 2017/10/19.
 */
public class SboxThirdClient {
    private static Logger logger = LoggerFactory.getLogger(SboxThirdClient.class);
    private RpcStubPoolFactory rpcfactory = null;
    private RpcStubPool rpcstubpool = null;
    private RpcStubPoolConfig config = new RpcStubPoolConfig();
    private int timeout ;
    private int serverMode = 3;
    private String sHost = "";
    private int sPort = -1;

    public SboxThirdClient(String serverHost, int serverPort)
    {
        this.sHost = serverHost;
        this.sPort = serverPort;
        config.setMaxActive(100);
        config.setMaxIdle(100);
        config.setMaxWait(3000);
        config.setTestWhileIdle(false);
        config.setMinEvictableIdleTimeMillis(3600000);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(false);
    }
    public SboxThirdClient(String serverHost, int serverPort, int timeout)
    {
        this.sHost = serverHost;
        this.sPort = serverPort;
        this.timeout = timeout;
        config.setMaxActive(100);
        config.setMaxIdle(100);
        config.setMaxWait(3000);
        config.setTestWhileIdle(false);
        config.setMinEvictableIdleTimeMillis(3600000);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(false);
    }

    public SboxThirdClient(String serverHost, int serverPort, int serverMode, RpcStubPoolConfig config, int timeout)
    {
        this.timeout = timeout;
        this.config = config;
        this.serverMode = serverMode;
        this.sHost = serverHost;
        this.sPort = serverPort;
    }

    /**
     * ContactRpcClient初始化
     *
     * @param reqId 请求索引
     * @return 初始化成功返回true，失败返回false
     */
    public boolean init(long reqId)
    {
        String logFlag = "ContactRpcClient.init";
        logger.info("[lid:{}][{}] serverHost:{} serverPort:{} serverMode:{}", reqId, logFlag, this.sHost, this.sPort, this.serverMode);
        rpcfactory = new RpcStubPoolFactory(this.sHost, this.sPort, this.serverMode, this.timeout);
        rpcstubpool = new RpcStubPool();
        if (!rpcstubpool.init(reqId, this.config, rpcfactory))
        {
            logger.error("[lid:{}]  rpcpool init failed!", reqId);
            return false;
        }
        return true;
    }

    @SuppressWarnings("unchecked")
    private <T> RpcClientInfo<T> getServiceClient(long reqId, String key)
    {
        String logFlag = "ContactRpcClient.getServiceClient";
        Object rpcconnect = null;
        try
        {
            rpcconnect =  rpcstubpool.getResource(reqId, key);
            return (RpcClientInfo<T>) rpcconnect;
        }
        catch (Exception e)
        {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", reqId, logFlag, Utils.getStackTrace(e));
            rpcstubpool.returnBrokenResource(reqId, key, rpcconnect);
            return null;
        }
    }
    /**
     * 文件分块上传
     *
     * @param logIndex            请求索引
     * @param caller           调用模块的标识
     * @param userId           用户ID
     * @param taskId         任务id
     * @param filesMetaData  上传的文件信息
     * @return ,
     * @author
     */
    public Result<String> updateFilesMetadataByBlock(long logIndex, String caller, long userId, String taskId, String filesMetaData, String ext){
        String logFlag = "SboxThirdClient.updateFilesMetadataByBlock";
        RpcClientInfo<ThirdServiceStub.Client> ci = null;
        ResStr res = new ResStr();
        try
        {
            ci = getServiceClient(logIndex, DefaultValues.SBOX_THIRD_SERVICE);
            if (ci == null)
            {
                logger.warn("[lid:{}][{}] cann't get contact rpc Client", logIndex, logFlag);
                return new Result<String>(ReturnValues.INNER_ERROR,null);
            }
            res = ci.getClient().updateFilesMetadataByBlock(logIndex, caller, userId, taskId, filesMetaData,null);
            if (res.res == ReturnValues.SUCCESS)
            {
                logger.info("[lid:{}][{}] result:{}, value:{}", logIndex, logFlag, res.res, res.value);
            }
            else
            {
                logger.warn("[lid:{}][{}] failed! errcode:{}", logIndex, logFlag, res.res);
            }
            rpcstubpool.returnResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            return new Result<String>(res.res,res.value);
        }
        catch (TException e)
        {
            rpcstubpool.returnBrokenResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", logIndex, logFlag, Utils.getStackTrace(e));
            return new Result<String>(ReturnValues.INNER_ERROR,null);
        }
    }

    /**
     * 查询已经被删除的文件
     *
     * @param logIndex            请求索引
     * @param caller           调用模块的标识
     * @param userId           用户ID
     * @param currentPage         分页请求当前页
     * @param pageSize           页大小
     * @return ,
     * @author
     */
    public Result<String>searchDeleteFiles(long logIndex, String caller, long userId, int currentPage, int pageSize, String ext){
        String logFlag = "SboxThirdClient.searchDeleteFiles";
        RpcClientInfo<ThirdServiceStub.Client> ci = null;
        ResStr res = new ResStr();
        try
        {
            ci = getServiceClient(logIndex, DefaultValues.SBOX_THIRD_SERVICE);
            if (ci == null)
            {
                logger.warn("[lid:{}][{}] cann't get contact rpc Client", logIndex, logFlag);
                return new Result<String>(ReturnValues.INNER_ERROR,null);
            }
            res = ci.getClient().searchDeleteFiles(logIndex, caller, userId, currentPage, pageSize,null);
            if (res.res == ReturnValues.SUCCESS)
            {
                logger.info("[lid:{}][{}] result:{}, value:{}", logIndex, logFlag, res.res, res.value);
            }
            else
            {
                logger.warn("[lid:{}][{}] failed! errcode:{}", logIndex, logFlag, res.res);
            }
            rpcstubpool.returnResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            return new Result<String>(res.res,res.value);
        }
        catch (TException e)
        {
            rpcstubpool.returnBrokenResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", logIndex, logFlag, Utils.getStackTrace(e));
            return new Result<String>(ReturnValues.INNER_ERROR,null);
        }
    }
    /**
     * 根据文件id批量删除文件
     *
     * @param logIndex            请求索引
     * @param caller           调用模块的标识
     * @param userId           用户ID
     * @param fileIds         批量删除的fileId
     * @return ,
     * @author
     */
    public Result<String> deleteFilesMetaData(long logIndex, String caller, long userId, java.util.List<Long> fileIds, String ext){
        String logFlag = "SboxThirdClient.deleteFilesMetaData";
        RpcClientInfo<ThirdServiceStub.Client> ci = null;
        ResStr res = new ResStr();
        try
        {
            ci = getServiceClient(logIndex, DefaultValues.SBOX_THIRD_SERVICE);
            if (ci == null)
            {
                logger.warn("[lid:{}][{}] cann't get contact rpc Client", logIndex, logFlag);
                return new Result<String>(ReturnValues.INNER_ERROR,null);
            }
            res = ci.getClient().deleteFilesMetaData(logIndex, caller, userId, fileIds, null);
            if (res.res == ReturnValues.SUCCESS)
            {
                logger.info("[lid:{}][{}] result:{}, value:{}", logIndex, logFlag, res.res, res.value);
            }
            else
            {
                logger.warn("[lid:{}][{}] failed! errcode:{}", logIndex, logFlag, res.res);
            }
            rpcstubpool.returnResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            return new Result<String>(res.res,res.value);
        }
        catch (TException e)
        {
            rpcstubpool.returnBrokenResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", logIndex, logFlag, Utils.getStackTrace(e));
            return new Result<String>(ReturnValues.INNER_ERROR,null);
        }
    }

    /**
     * 校验上传任务id
     *
     * @param logIndex            请求索引
     * @param caller           调用模块的标识
     * @param taskId         任务Id
     * @return ,
     * @author
     */
   public Result<String> checkUploadTaskId(long logIndex, String caller, String taskId, String ext){
       String logFlag = "SboxThirdClient.checkUploadTaskId";
       RpcClientInfo<ThirdServiceStub.Client> ci = null;
       ResStr res = new ResStr();
       try
       {
           ci = getServiceClient(logIndex, DefaultValues.SBOX_THIRD_SERVICE);
           if (ci == null)
           {
               logger.warn("[lid:{}][{}] cann't get contact rpc Client", logIndex, logFlag);
               return new Result<String>(ReturnValues.INNER_ERROR,null);
           }
           res = ci.getClient().checkUploadTaskId(logIndex, caller, taskId,null);
           if (res.res == ReturnValues.SUCCESS)
           {
               logger.info("[lid:{}][{}] result:{}, value:{}", logIndex, logFlag, res.res, res.value);
           }
           else
           {
               logger.warn("[lid:{}][{}] failed! errcode:{}", logIndex, logFlag, res.res);
           }
           rpcstubpool.returnResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
           return new Result<String>(res.res,res.value);
       }
       catch (TException e)
       {
           rpcstubpool.returnBrokenResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
           logger.warn("[lid:{}][{}] exception happened! detail:\n{}", logIndex, logFlag, Utils.getStackTrace(e));
           return new Result<String>(ReturnValues.INNER_ERROR,null);
       }
    }

    /**
     * 校验下载任务id
     *
     * @param logIndex            请求索引
     * @param caller           调用模块的标识
     * @param taskId         任务Id
     * @return ,
     * @author
     */

    public Result<String>checkDownloadTaskId(long logIndex, String caller, String taskId, String ext){
        String logFlag = "SboxThirdClient.checkDownloadTaskId";
        RpcClientInfo<ThirdServiceStub.Client> ci = null;
        ResStr res = new ResStr();
        try
        {
            ci = getServiceClient(logIndex, DefaultValues.SBOX_THIRD_SERVICE);
            if (ci == null)
            {
                logger.warn("[lid:{}][{}] cann't get contact rpc Client", logIndex, logFlag);
                return new Result<String>(ReturnValues.INNER_ERROR,null);
            }
            res = ci.getClient().checkDownloadTaskId(logIndex, caller, taskId,null);
            if (res.res == ReturnValues.SUCCESS)
            {
                logger.info("[lid:{}][{}] result:{}, value:{}", logIndex, logFlag, res.res, res.value);
            }
            else
            {
                logger.warn("[lid:{}][{}] failed! errcode:{}", logIndex, logFlag, res.res);
            }
            rpcstubpool.returnResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            return new Result<String>(res.res,res.value);
        }
        catch (TException e)
        {
            rpcstubpool.returnBrokenResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", logIndex, logFlag, Utils.getStackTrace(e));
            return new Result<String>(ReturnValues.INNER_ERROR,null);
        }
    }

    /**
     * 校验下载任务id
     *
     * @param logIndex            请求索引
     * @param caller           调用模块的标识
     * @param account           账号
     *
     * @author
     */
   public Result<String> getUserByAccount(long logIndex, String caller, String account, String ext){
       String logFlag = "SboxThirdClient.getUserByAccount";
       RpcClientInfo<ThirdServiceStub.Client> ci = null;
       ResStr res = new ResStr();
       try
       {
           ci = getServiceClient(logIndex, DefaultValues.SBOX_THIRD_SERVICE);
           if (ci == null)
           {
               logger.warn("[lid:{}][{}] cann't get contact rpc Client", logIndex, logFlag);
               return new Result<String>(ReturnValues.INNER_ERROR,null);
           }
           res = ci.getClient().getUserByAccount(logIndex, caller, account,null);
           if (res.res == ReturnValues.SUCCESS)
           {
               logger.info("[lid:{}][{}] result:{}, value:{}", logIndex, logFlag, res.res, res.value);
           }
           else
           {
               logger.warn("[lid:{}][{}] failed! errcode:{}", logIndex, logFlag, res.res);
           }
           rpcstubpool.returnResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
           return new Result<String>(res.res,res.value);
       }
       catch (TException e)
       {
           rpcstubpool.returnBrokenResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
           logger.warn("[lid:{}][{}] exception happened! detail:\n{}", logIndex, logFlag, Utils.getStackTrace(e));
           return new Result<String>(ReturnValues.INNER_ERROR,null);
       }

    }

    /**
     *   文件的批量存储
     *
     * @param logIndex            请求索引
     * @param caller           调用模块的标识
     * @param useId           用户id
     * @param taskId         任务id
     * @param filesMetaData    文件
     * @author
     */

    public Result<String>updateFilesMetadata(long logIndex, String caller, long useId, String taskId, java.util.List<String> filesMetaData, String ext){
        String logFlag = "SboxThirdClient.updateFilesMetadata";
        RpcClientInfo<ThirdServiceStub.Client> ci = null;
        ResStr res = new ResStr();
        try
        {
            ci = getServiceClient(logIndex, DefaultValues.SBOX_THIRD_SERVICE);
            if (ci == null)
            {
                logger.warn("[lid:{}][{}] cann't get contact rpc Client", logIndex, logFlag);
                return new Result<String>(ReturnValues.INNER_ERROR,null);
            }
            res = ci.getClient().updateFilesMetadata(logIndex, caller, useId,taskId,filesMetaData,null);
            if (res.res == ReturnValues.SUCCESS)
            {
                logger.info("[lid:{}][{}] result:{}, value:{}", logIndex, logFlag, res.res, res.value);
            }
            else
            {
                logger.warn("[lid:{}][{}] failed! errcode:{}", logIndex, logFlag, res.res);
            }
            rpcstubpool.returnResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            return new Result<String>(res.res,res.value);
        }
        catch (TException e)
        {
            rpcstubpool.returnBrokenResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", logIndex, logFlag, Utils.getStackTrace(e));
            return new Result<String>(ReturnValues.INNER_ERROR,null);
        }
    }
    public Result<String>searchExpireTimeFilesByUncompleted(long logIndex, String caller, int currentPage, int pageSize, String ext){
        String logFlag = "SboxThirdClient.searchExpireTimeFilesByUncompleted";
        RpcClientInfo<ThirdServiceStub.Client> ci = null;
        ResStr res = new ResStr();
        try
        {
            ci = getServiceClient(logIndex, DefaultValues.SBOX_THIRD_SERVICE);
            if (ci == null)
            {
                logger.warn("[lid:{}][{}] cann't get contact rpc Client", logIndex, logFlag);
                return new Result<String>(ReturnValues.INNER_ERROR,null);
            }
            res = ci.getClient().searchExpireTimeFilesByUncompleted(logIndex, caller, currentPage,pageSize,ext);
            if (res.res == ReturnValues.SUCCESS)
            {
                logger.info("[lid:{}][{}] result:{}, value:{}", logIndex, logFlag, res.res, res.value);
            }
            else
            {
                logger.warn("[lid:{}][{}] failed! errcode:{}", logIndex, logFlag, res.res);
            }
            rpcstubpool.returnResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            return new Result<String>(res.res,res.value);
        }
        catch (TException e)
        {
            rpcstubpool.returnBrokenResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", logIndex, logFlag, Utils.getStackTrace(e));
            return new Result<String>(ReturnValues.INNER_ERROR,null);
        }
    }

    public Result<String>updateThumbnailOfFile(long logIndex, String caller, String filesThumbnailMetaData, String ext){
        String logFlag = "SboxThirdClient.updateThumbnailOfFile";
        RpcClientInfo<ThirdServiceStub.Client> ci = null;
        ResStr res = new ResStr();
        try
        {
            ci = getServiceClient(logIndex, DefaultValues.SBOX_THIRD_SERVICE);
            if (ci == null)
            {
                logger.warn("[lid:{}][{}] cann't get contact rpc Client", logIndex, logFlag);
                return new Result<String>(ReturnValues.INNER_ERROR,null);
            }
            res = ci.getClient().updateThumbnailOfFile(logIndex, caller, filesThumbnailMetaData,ext);
            if (res.res == ReturnValues.SUCCESS)
            {
                logger.info("[lid:{}][{}] result:{}, value:{}", logIndex, logFlag, res.res, res.value);
            }
            else
            {
                logger.warn("[lid:{}][{}] failed! errcode:{}", logIndex, logFlag, res.res);
            }
            rpcstubpool.returnResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            return new Result<String>(res.res,res.value);
        }
        catch (TException e)
        {
            rpcstubpool.returnBrokenResource(logIndex, DefaultValues.SBOX_THIRD_SERVICE, ci);
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", logIndex, logFlag, Utils.getStackTrace(e));
            return new Result<String>(ReturnValues.INNER_ERROR,null);
        }

    }
    public void shutDown(long reqId)
    {
        String logFlag = "SboxThirdClient.shutDown";
        if (rpcstubpool == null)
            return;
        try
        {
            rpcstubpool.destroy(reqId);
            rpcstubpool = null;
        }
        catch (Exception ex)
        {
            logger.error("[lid:{}][{}]exception happened while shutting down rpcstubpool...", reqId, logFlag);
        }
    }



}
