package com.xdja.sboxClient.rpcstubpool;

import com.xdja.sboxClient.common.DefaultValues;
import com.xdja.sboxClient.common.ReturnValues;
import com.xdja.sboxClient.thriftstub.ThirdServiceStub;
import com.xdja.thrift.datatype.ResStr;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;

public class RpcStubPoolFactory extends BaseKeyedPoolableObjectFactory<String, Object>
{
	private final String host;
	private final int port;
	private final int serverMode;
	private final int timeout;
	public AtomicInteger logId = new AtomicInteger(-1);
	private static Logger logger = LoggerFactory.getLogger(RpcStubPoolFactory.class);

	private String getClassName()
	{// 仅用于内部获取类的最短名字
		return "RpcStubPoolFactory";
	}

	public RpcStubPoolFactory(final String host, final int port, final int mode, final int timeout)
	{
		super();
		this.host = host;
		this.port = port;
		this.serverMode = mode;
		this.timeout = timeout;
	}

	public boolean checkSocket(Socket socket)
	{
		return socket != null && socket.isBound() && !socket.isClosed() && socket.isConnected() && !socket.isInputShutdown() && !socket.isOutputShutdown();
	}

	@SuppressWarnings("unchecked") @Override public Object makeObject(String key) throws Exception
	{
		String logFlag = getClassName() + ".makeObject";
		TTransport transport = null;
		TProtocol protocol = null;
		TSocket tsocket = null;
		if (serverMode == DefaultValues.SERVER_MODE_THREAD_POOL)
		{
			tsocket = new TSocket(this.host, this.port, this.timeout);
			transport = tsocket;
			protocol = new TBinaryProtocol(transport);
		}
		else if (serverMode == DefaultValues.SERVER_MODE_NONBLOCK || serverMode == DefaultValues.SERVER_MODE_THREADEDSELECTOR)
		{
			tsocket = new TSocket(this.host, this.port, this.timeout);
			transport = new TFramedTransport(tsocket);
			// 协议要和服务端一致
			protocol = new TBinaryProtocol(transport);
		}
		TMultiplexedProtocol multiPro = new TMultiplexedProtocol(protocol, key);
		try
		{
			Object rpctype = null;
			switch (key)
			{
			case DefaultValues.SBOX_THIRD_SERVICE:
				rpctype = new RpcClientInfo<ThirdServiceStub.Client>(new ThirdServiceStub.Client(multiPro), transport, tsocket);
				((RpcClientInfo<ThirdServiceStub.Client>) rpctype).getTTransport().open();
				break;
			default:
				break;
			}
			return rpctype;
		}
		catch (TTransportException e)
		{
			logger.warn("[lid:{}][{}]getTTransport failed! TTransportException detail: {}", logId.getAndDecrement(), logFlag, e);
			return null;
		}
	}

	@Override public boolean validateObject(String key, Object obj)
	{
		String logFlag = getClassName() + ".validateObject";
		logId.getAndIncrement();
		if (obj == null)
		{
			logger.warn("[lid:{}][{}]Object is empty!", logId.get(), logFlag);
			return false;
		}
		ResStr resStr = null;
		try
		{
			switch (key)
			{
			case DefaultValues.SBOX_THIRD_SERVICE:
				RpcClientInfo<ThirdServiceStub.Client> rpcec = (RpcClientInfo<ThirdServiceStub.Client>) obj;
				if (!checkSocket(rpcec.getTSocket().getSocket()))
				{
					logger.warn("[lid:{}][{}] checkSocket fail!", logId.get(), logFlag);
					return false;
				}
				logId.getAndIncrement();
				resStr = rpcec.getClient().echo(logId.longValue(), logFlag, "ok");
				if (resStr.res != ReturnValues.SUCCESS)
				{
					logger.warn("[lid:{}][{}] err result!", logId.get(), logFlag);
					return false;
				}
				return resStr.value.equals("ok");
			default:
				break;
			}
			return super.validateObject(key, obj);
		}
		catch (Exception e)
		{
			logger.warn("[lid:{}][{}]validateObject fail! Exception detail:{}", logId.get(), logFlag, e);
			return false;
		}

	}

	@Override public void destroyObject(String key, Object obj) throws Exception
	{
		String logFlag = getClassName() + ".destroyObject";
		if (obj == null)
		{
			logger.warn("[lid:{}][{}]Object is empty!", logId.getAndDecrement(), logFlag);
			return;
		}
		switch (key)
		{
		case DefaultValues.SBOX_THIRD_SERVICE:
			RpcClientInfo<ThirdServiceStub.Client> rpcec = (RpcClientInfo<ThirdServiceStub.Client>) obj;
			rpcec.getTTransport().close();
			break;
		default:
			break;
		}
		RpcStubPool.iNum.decrementAndGet();
	}

}
