/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ums.service.impl;

import com.xdja.cssp.acs.IAssetService;
import com.xdja.cssp.acs.ICertService;
import com.xdja.cssp.acs.bean.asset.Asset;
import com.xdja.cssp.acs.bean.asset.Type;
import com.xdja.cssp.acs.bean.cert.Cert;
import com.xdja.cssp.acs.bean.cert.CertStatus;
import com.xdja.cssp.ums.model.AccountCert;
import com.xdja.cssp.ums.model.AccountPublicKey;
import com.xdja.cssp.ums.model.CardInfo;
import com.xdja.cssp.ums.model.Device;
import com.xdja.cssp.ums.model.DeviceInfo;
import com.xdja.cssp.ums.model.ModifyUser;
import com.xdja.cssp.ums.model.PublicKey;
import com.xdja.cssp.ums.model.QueryCertReq;
import com.xdja.cssp.ums.model.QueryPublicKeyReq;
import com.xdja.cssp.ums.model.Result;
import com.xdja.cssp.ums.model.ResultBean;
import com.xdja.cssp.ums.model.UnDeviceBind;
import com.xdja.cssp.ums.model.User;
import com.xdja.cssp.ums.model.UserDetail;
import com.xdja.cssp.ums.model.UserInfo;
import com.xdja.cssp.ums.model.UserMsg;
import com.xdja.cssp.ums.service.Constants;
import com.xdja.cssp.ums.service.IAccountService;
import com.xdja.cssp.ums.service.impl.handler.ModifyDeviceHandler;
import com.xdja.cssp.ums.service.impl.handler.QueryAccountPublicKeyHandler;
import com.xdja.cssp.ums.service.impl.handler.QueryAllUserHandler;
import com.xdja.cssp.ums.service.impl.handler.QueryDeviceHandler;
import com.xdja.cssp.ums.service.impl.handler.QueryUserBatchHandler;
import com.xdja.cssp.ums.service.util.AvatarUtil;
import com.xdja.cssp.ums.service.util.GenerateIdentify;
import com.xdja.cssp.ums.service.util.RedisUtil;
import com.xdja.cssp.ums.service.util.SCNoticeUtil;
import com.xdja.cssp.ums.service.util.SpellUtil;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.db.Dao;
import com.xdja.platform.microservice.db.SqlHelper;
import com.xdja.platform.microservice.db.tx.IAtom;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccountServiceImpl
implements IAccountService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Dao umsDao = Dao.use((String)"db::ums");
    private IAssetService assetService = (IAssetService)DefaultServiceRefer.getServiceRefer(IAssetService.class);
    private ICertService certService = (ICertService)DefaultServiceRefer.getServiceRefer(ICertService.class);
    private com.xdja.cssp.ams.assetmanager.service.IAccountService accountService = (com.xdja.cssp.ams.assetmanager.service.IAccountService)DefaultServiceRefer.getServiceRefer(com.xdja.cssp.ams.assetmanager.service.IAccountService.class);

    public String queryAccountByCardNo(String cardNo) {
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5,\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        String sql = "SELECT c_account FROM t_account_asset WHERE c_card_no=?";
        try {
            return this.umsDao.queryForStr(sql, new Object[]{cardNo});
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636e\u5b89\u5168\u5361\u53f7%s\u67e5\u8be2\u8d26\u6237\u65f6\u51fa\u9519", cardNo), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636e\u5b89\u5168\u5361\u53f7%s\u67e5\u8be2\u8d26\u6237\u65f6\u51fa\u9519", cardNo), (Exception)e);
        }
    }

    public String getAccountByCardNo(String cardNo) {
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5,\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        String sql = "SELECT c_account FROM t_account_asset WHERE c_card_no=?";
        try {
            return this.umsDao.queryForStr(sql, new Object[]{cardNo});
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636e\u5b89\u5168\u5361\u53f7%s\u83b7\u53d6\u8d26\u6237\u65f6\u51fa\u9519", cardNo), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636e\u5b89\u5168\u5361\u53f7%s\u67e5\u8be2\u8d26\u6237\u65f6\u51fa\u9519", cardNo), (Exception)e);
        }
    }

    public String queryOpenLockByUId(String uId) {
        if (StringUtils.isBlank((CharSequence)uId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5,\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            return this.assetService.queryUnlockByUId(uId);
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636eUID\u67e5\u8be2\u52a0\u5bc6\u89e3\u9501\u7801\u65f6\u51fa\u9519\uff0cUID\u4e3a\uff1a%s", uId), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636eUID\u67e5\u8be2\u52a0\u5bc6\u89e3\u9501\u7801\u65f6\u51fa\u9519\uff0cUID\u4e3a\uff1a%s", uId), (Exception)e);
        }
    }

    public String queryOpenLockByCardNo(String cardNo) {
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5,\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            return this.assetService.queryUnlockByCardNo(cardNo);
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636eCardNo\u67e5\u8be2\u52a0\u5bc6\u89e3\u9501\u7801\u65f6\u51fa\u9519\uff0ccardNo\u4e3a\uff1a%s", cardNo), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636eCardNo\u67e5\u8be2\u52a0\u5bc6\u89e3\u9501\u7801\u65f6\u51fa\u9519\uff0ccardNo\u4e3a\uff1a%s", cardNo), (Exception)e);
        }
    }

    public boolean checkAccountCardRelation(String account, String uId) {
        if (StringUtils.isBlank((CharSequence)account) || StringUtils.isBlank((CharSequence)uId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5,\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            String cardNo = this.assetService.queryCardNoByUId(uId);
            if (StringUtils.isBlank((CharSequence)cardNo)) {
                return false;
            }
            String sql = "SELECT COUNT(0) FROM t_account_asset WHERE c_account = ? AND c_card_no = ?";
            return this.umsDao.queryForLong(sql, new Object[]{account, cardNo}) > 0L;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u9a8c\u8bc1\u8d26\u6237\u4e0e\u5361\u5173\u7cfb\u65f6\u51fa\u9519\uff0caccount\u4e3a\uff1a%s uId\u4e3a\uff1a%s", account, uId), (Throwable)e);
            throw ServiceException.create((String)String.format("\u9a8c\u8bc1\u8d26\u6237\u4e0e\u5361\u5173\u7cfb\u65f6\u51fa\u9519\uff0caccount\u4e3a\uff1a%s uId\u4e3a\uff1a%s", account, uId), (Exception)e);
        }
    }

    public boolean modifyPwd(String account, String pwd) {
        if (StringUtils.isBlank((CharSequence)account) || StringUtils.isBlank((CharSequence)pwd)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5,\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            String sql = "UPDATE t_account_info SET c_password = ? WHERE c_account = ?";
            int result = this.umsDao.update(sql, new Object[]{pwd, account});
            return result == 1;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u4fee\u6539\u5bc6\u7801\u65f6\u51fa\u9519\uff0caccount\u4e3a\uff1a%s", account), (Throwable)e);
            throw ServiceException.create((String)String.format("\u4fee\u6539\u5bc6\u7801\u65f6\u51fa\u9519\uff0caccount\u4e3a\uff1a%s", account), (Exception)e);
        }
    }

    public ResultBean queryUserInfo(String assetIdentify) {
        if (StringUtils.isBlank((CharSequence)assetIdentify)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT info.c_account, extention.c_nick_name, extention.c_mobile, extention.c_mail,");
        sql.append(" extention.c_avatar_name, asset.c_device_name FROM t_account_info info");
        sql.append(" LEFT JOIN t_account_extention extention ON info.c_account = extention.c_account");
        sql.append(" JOIN t_account_asset asset ON info.c_account = asset.c_account");
        sql.append(" WHERE asset.c_asset_identify = ?");
        try {
            ResultBean resultBean = new ResultBean();
            Map result = this.umsDao.queryForMap(sql.toString(), new Object[]{assetIdentify});
            if (null == result || result.isEmpty() || StringUtils.isBlank((CharSequence)((String)result.get("c_account")))) {
                resultBean.setResultStatus(2);
                resultBean.setInfo((Object)"\u8bbe\u5907\u672a\u6ce8\u518c");
            } else {
                String avatar;
                UserInfo userInfo = new UserInfo();
                userInfo.setAccount((String)result.get("c_account"));
                userInfo.setDeviceName((String)result.get("c_device_name"));
                userInfo.setNickName((String)result.get("c_nick_name"));
                userInfo.setMobile((String)result.get("c_mobile"));
                userInfo.setMail((String)result.get("c_mail"));
                String avatarName = (String)result.get("c_avatar_name");
                if (StringUtils.isNotBlank((CharSequence)avatarName) && StringUtils.isNotBlank((CharSequence)(avatar = AvatarUtil.getAvatar(avatarName)))) {
                    userInfo.setAvatar(avatar);
                    userInfo.setSuffix(avatarName.substring(avatarName.lastIndexOf(".") + 1));
                }
                resultBean.setResultStatus(1);
                resultBean.setInfo((Object)userInfo);
            }
            return resultBean;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636e\u8d44\u4ea7\u6807\u8bc6%s\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u65f6\u51fa\u9519", assetIdentify), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636e\u8d44\u4ea7\u6807\u8bc6%s\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u65f6\u51fa\u9519", assetIdentify), (Exception)e);
        }
    }

    public int modifyDeviceInfo(Device deviceInfo) {
        if (null == deviceInfo || StringUtils.isBlank((CharSequence)deviceInfo.getAccount()) || StringUtils.isBlank((CharSequence)deviceInfo.getAssetIdentify()) || StringUtils.isBlank((CharSequence)deviceInfo.getDeviceName())) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            String sql = "SELECT c_asset_identify FROM t_account_asset WHERE c_account = ?";
            List result = this.umsDao.queryForList(sql, (ResultSetHandler)new ModifyDeviceHandler(), new Object[]{deviceInfo.getAccount()});
            if (null == result || result.isEmpty()) {
                return 2;
            }
            if (!result.contains(deviceInfo.getAssetIdentify())) {
                return 3;
            }
            sql = "UPDATE t_account_asset SET c_device_name = ? WHERE c_asset_identify = ?";
            this.umsDao.update(sql, new Object[]{deviceInfo.getDeviceName(), deviceInfo.getAssetIdentify()});
            SCNoticeUtil.sendUserModifyNotice(2, deviceInfo.getAccount());
            return 1;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u4fee\u6539\u8bbe\u5907\u4fe1\u606f\u65f6\u51fa\u9519\uff0c\u5e10\u53f7\u4e3a\uff1a%s\uff0c\u8d44\u4ea7\u6807\u8bc6\u4e3a\uff1a%s", deviceInfo.getAccount(), deviceInfo.getAssetIdentify()), (Throwable)e);
            throw ServiceException.create((String)String.format("\u4fee\u6539\u8bbe\u5907\u4fe1\u606f\u65f6\u51fa\u9519\uff0c\u5e10\u53f7\u4e3a\uff1a%s\uff0c\u8d44\u4ea7\u6807\u8bc6\u4e3a\uff1a%s", deviceInfo.getAccount(), deviceInfo.getAssetIdentify()), (Exception)e);
        }
    }

    public int checkCardStatus(CardInfo cardInfo) {
        this.checkParameter(cardInfo);
        try {
            String sql = "SELECT COUNT(0) FROM t_account_info WHERE c_account = ?";
            if (this.umsDao.queryForLong(sql, new Object[]{cardInfo.getAccount()}) <= 0L) {
                return 2;
            }
            sql = "SELECT c_account FROM t_account_asset WHERE c_card_no = ?";
            String account = this.umsDao.queryForStr(sql, new Object[]{cardInfo.getCardNo()});
            if (StringUtils.isBlank((CharSequence)account)) {
                return 3;
            }
            if (!account.equalsIgnoreCase(cardInfo.getAccount())) {
                return 4;
            }
            CertStatus certStatus = this.certService.checkCertStatus(cardInfo.getCardNo(), cardInfo.getSn(), cardInfo.getCaAlg());
            return this.checkCardResolve(certStatus);
        }
        catch (Exception e) {
            this.logger.error(String.format("\u8bbe\u5907\u89e3\u9501\u5b89\u5168\u5361\u72b6\u6001\u68c0\u6d4b\u65f6\u51fa\u9519\uff0c\u8d26\u53f7\uff1a%s \uff0c\u5361\u53f7\uff1a%s \uff0cSN\uff1a%s ", cardInfo.getAccount(), cardInfo.getCardNo(), cardInfo.getSn()), (Throwable)e);
            throw ServiceException.create((String)String.format("\u8bbe\u5907\u89e3\u9501\u5b89\u5168\u5361\u72b6\u6001\u68c0\u6d4b\u65f6\u51fa\u9519\uff0c\u8d26\u53f7\uff1a%s \uff0c\u5361\u53f7\uff1a%s \uff0cSN\uff1a%s ", cardInfo.getAccount(), cardInfo.getCardNo(), cardInfo.getSn()), (Exception)e);
        }
    }

    public int bindDevice(final CardInfo cardInfo) {
        this.checkParameter(cardInfo);
        try {
            String sql = "SELECT COUNT(0) FROM t_account_info WHERE c_account = ?";
            long accountCount = this.umsDao.queryForLong(sql, new Object[]{cardInfo.getAccount()});
            if (accountCount <= 0L) {
                return 2;
            }
            if (!this.assetService.exists(cardInfo.getCardNo())) {
                return 4;
            }
            CertStatus certStatus = this.certService.checkCertStatus(cardInfo.getCardNo(), cardInfo.getSn(), cardInfo.getCaAlg());
            int result = this.resolveResult(certStatus);
            if (result != 1) {
                return result;
            }
            final StringBuffer insertSql = new StringBuffer();
            insertSql.append("INSERT INTO t_account_asset(c_account, c_asset_identify, c_device_name,");
            insertSql.append(" n_asset_type, c_card_no, n_time)");
            insertSql.append(" VALUES(?,?,?,?,?,?)");
            final long nowTime = System.currentTimeMillis();
            String queryOldAccount = "SELECT c_account FROM t_account_asset WHERE c_asset_identify=?";
            String oldAccount = this.umsDao.queryForStr(queryOldAccount, new Object[]{cardInfo.getCardNo()});
            this.umsDao.tx(new IAtom(){

                public boolean run() throws SQLException {
                    Asset asset = (Asset)AccountServiceImpl.this.assetService.queryAssets(new String[]{cardInfo.getCardNo()}).get(0);
                    AccountServiceImpl.this.umsDao.update("DELETE FROM t_account_asset WHERE c_asset_identify=?", new Object[]{asset.getIdentity()});
                    String deviceName = null;
                    Asset mobileInfo = null;
                    if (asset.getType().value != com.xdja.cssp.ums.model.Type.USBKey.value && asset.getType().value != com.xdja.cssp.ums.model.Type.TF.value) {
                        deviceName = AccountServiceImpl.this.getDeviceName(cardInfo.getAccount(), asset.getType());
                        mobileInfo = asset;
                    }
                    AccountServiceImpl.this.umsDao.update(insertSql.toString(), new Object[]{cardInfo.getAccount(), asset.getIdentity(), deviceName, asset.getType().value, asset.getCardNo(), nowTime});
                    AccountServiceImpl.this.addAssetOrCardOrCertCache(mobileInfo);
                    return true;
                }
            });
            if (StringUtils.isNotBlank((CharSequence)oldAccount)) {
                SCNoticeUtil.sendUserModifyNotice(2, oldAccount);
            }
            SCNoticeUtil.sendUserModifyNotice(2, cardInfo.getAccount());
            return 1;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u8bbe\u5907\u7ed1\u5b9a\u65f6\u51fa\u9519\uff0c\u8d26\u53f7\uff1a%s \uff0c\u5361\u53f7\uff1a%s \uff0cSN\uff1a%s\uff0ccaAlg\uff1a%s", cardInfo.getAccount(), cardInfo.getCardNo(), cardInfo.getSn(), cardInfo.getCaAlg()), (Throwable)e);
            throw ServiceException.create((String)String.format("\u8bbe\u5907\u7ed1\u5b9a\u65f6\u51fa\u9519\uff0c\u8d26\u53f7\uff1a%s \uff0c\u5361\u53f7\uff1a%s \uff0cSN\uff1a%s\uff0ccaAlg\uff1a%s", cardInfo.getAccount(), cardInfo.getCardNo(), cardInfo.getSn(), cardInfo.getCaAlg()), (Exception)e);
        }
    }

    public List<DeviceInfo> queryDevices(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<DeviceInfo> result = new ArrayList<DeviceInfo>();
        HashMap<String, DeviceInfo> devices = new HashMap<String, DeviceInfo>();
        HashMap<String, String> relations = new HashMap<String, String>();
        DeviceInfo device = null;
        String identify = null;
        try {
            String sql = "SELECT c_asset_identify, c_device_name, n_time FROM t_account_asset WHERE c_account = ?";
            Map identifys = this.umsDao.queryForMap(sql, (ResultSetHandler)new QueryDeviceHandler(), new Object[]{account});
            if (identifys.isEmpty()) {
                return result;
            }
            String[] identifyArr = new String[identifys.keySet().size()];
            List assets = this.assetService.queryAssets(identifys.keySet().toArray(identifyArr));
            for (Asset asset : assets) {
                device = new DeviceInfo();
                device.setIdentity(asset.getIdentity());
                device.setDeviceName(((DeviceInfo)identifys.get(asset.getIdentity())).getDeviceName());
                device.setType(com.xdja.cssp.ums.model.Type.valueOf((int)asset.getType().value));
                device.setCardNo(asset.getCardNo());
                device.setSerialCode(asset.getSerialCode());
                device.setTime(asset.getTime().longValue());
                device.setInfo(asset.getInfo());
                device.setBindTime(((DeviceInfo)identifys.get(asset.getIdentity())).getBindTime());
                devices.put(asset.getIdentity(), device);
                relations.put(asset.getIdentity(), asset.getRelatedAsset());
                result.add(device);
            }
            for (DeviceInfo item : result) {
                identify = (String)relations.get(item.getIdentity());
                if (!StringUtils.isNotBlank((CharSequence)identify)) continue;
                item.setDevice((DeviceInfo)devices.get(identify));
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u67e5\u8be2\u8bbe\u5907\u5217\u8868\u65f6\u51fa\u9519\uff0c\u8d26\u53f7\uff1a%s ", account), (Throwable)e);
            throw ServiceException.create((String)String.format("\u67e5\u8be2\u8bbe\u5907\u5217\u8868\u65f6\u51fa\u9519\uff0c\u8d26\u53f7\uff1a%s ", account), (Exception)e);
        }
    }

    public List<AccountPublicKey> queryPublicKey(QueryPublicKeyReq req) {
        if (null == req || null == req.getAccounts() || req.getAccounts().isEmpty() || !Constants.CA_ALG_LIST.contains(req.getCaAlg()) || !Constants.CERT_TYPE_LIST.contains(req.getCertType())) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a\u6216\u53c2\u6570\u679a\u4e3e\u503c\u4e0d\u5b58\u5728");
        }
        try {
            HashMap<String, AccountPublicKey> result = new HashMap<String, AccountPublicKey>();
            Map publicKeyList = null;
            ArrayList cardNos = null;
            String sql = "SELECT c_account, c_card_no FROM t_account_asset WHERE c_account IN (#accountList)";
            sql = SqlHelper.prepare((String)sql, (String)"#accountList", (int)req.getAccounts().size());
            Map accountCardNos = this.umsDao.queryForMap(sql, (ResultSetHandler)new QueryAccountPublicKeyHandler(), req.getAccounts().toArray());
            cardNos = new ArrayList();
            for (Collection item : accountCardNos.values()) {
                cardNos.addAll(item);
            }
            if (!cardNos.isEmpty() && null != (publicKeyList = this.certService.queryPublicKeyByCardNos(cardNos, req.getCaAlg(), req.getCertType())) && !publicKeyList.isEmpty()) {
                AccountPublicKey accountPublicKey = null;
                ArrayList<PublicKey> publicKeys = null;
                PublicKey publicKey = null;
                for (String account : accountCardNos.keySet()) {
                    for (String cardNo : (List)accountCardNos.get(account)) {
                        if (!publicKeyList.containsKey(cardNo)) continue;
                        accountPublicKey = (AccountPublicKey)result.get(account);
                        if (null == accountPublicKey) {
                            accountPublicKey = new AccountPublicKey();
                            accountPublicKey.setAccount(account);
                            result.put(account, accountPublicKey);
                        }
                        if (null == (publicKeys = accountPublicKey.getPublicKeys())) {
                            publicKeys = new ArrayList<PublicKey>();
                            accountPublicKey.setPublicKeys(publicKeys);
                        }
                        for (com.xdja.cssp.acs.bean.cert.PublicKey pk : (List)publicKeyList.get(cardNo)) {
                            publicKey = new PublicKey();
                            publicKey.setCardNo(pk.getCardNo());
                            publicKey.setSn(pk.getSn());
                            publicKey.setCaAlg(pk.getCaAlg().value);
                            publicKey.setCertType(pk.getCertType().value);
                            publicKey.setPublicKey(pk.getPublicKey());
                            publicKeys.add(publicKey);
                        }
                    }
                }
            }
            return new ArrayList<AccountPublicKey>(result.values());
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u8d26\u53f7\u67e5\u8be2\u516c\u94a5\u65f6\u51fa\u9519", (Throwable)e);
            throw ServiceException.create((String)"\u6839\u636e\u8d26\u53f7\u67e5\u8be2\u516c\u94a5\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    public List<PublicKey> queryPublicKeyBySnList(List<String> snList, int caAlg) {
        this.checkParamter(snList, caAlg);
        try {
            ArrayList<PublicKey> result = new ArrayList<PublicKey>();
            PublicKey publicKey = null;
            List publicKeyList = this.certService.queryPublicKeyBySnList(snList, caAlg);
            for (com.xdja.cssp.acs.bean.cert.PublicKey item : publicKeyList) {
                publicKey = new PublicKey();
                publicKey.setCardNo(item.getCardNo());
                publicKey.setSn(item.getSn());
                publicKey.setCaAlg(item.getCaAlg().value);
                publicKey.setCertType(item.getCertType().value);
                publicKey.setPublicKey(item.getPublicKey());
                result.add(publicKey);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636eSN\u67e5\u8be2\u516c\u94a5\u4fe1\u606f\u65f6\u51fa\u9519", (Throwable)e);
            throw ServiceException.create((String)"\u6839\u636eSN\u67e5\u8be2\u516c\u94a5\u4fe1\u606f\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    public Map<String, List<PublicKey>> queryPublicKeyByCardNos(List<String> cardNoList, int caAlg, int certType) {
        this.checkParamter(cardNoList, caAlg, certType);
        try {
            HashMap<String, List<PublicKey>> result = new HashMap<String, List<PublicKey>>();
            ArrayList<PublicKey> publicKeyList = null;
            PublicKey publicKey = null;
            Map publicKeys = this.certService.queryPublicKeyByCardNos(cardNoList, caAlg, certType);
            for (String cardNo : publicKeys.keySet()) {
                publicKeyList = (ArrayList<PublicKey>)result.get(cardNo);
                if (null == publicKeyList) {
                    publicKeyList = new ArrayList<PublicKey>();
                    result.put(cardNo, publicKeyList);
                }
                for (com.xdja.cssp.acs.bean.cert.PublicKey item : (List)publicKeys.get(cardNo)) {
                    publicKey = new PublicKey();
                    publicKey.setCardNo(item.getCardNo());
                    publicKey.setSn(item.getSn());
                    publicKey.setCaAlg(item.getCaAlg().value);
                    publicKey.setCertType(item.getCertType().value);
                    publicKey.setPublicKey(item.getPublicKey());
                    publicKeyList.add(publicKey);
                }
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u5361\u53f7\u67e5\u8be2\u516c\u94a5\u4fe1\u606f\u65f6\u51fa\u9519", (Throwable)e);
            throw ServiceException.create((String)"\u6839\u636e\u5361\u53f7\u67e5\u8be2\u516c\u94a5\u4fe1\u606f\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    public List<com.xdja.cssp.ums.model.Cert> queryCertBySnList(List<String> snList, int caAlg) {
        this.checkParamter(snList, caAlg);
        try {
            ArrayList<com.xdja.cssp.ums.model.Cert> result = new ArrayList<com.xdja.cssp.ums.model.Cert>();
            com.xdja.cssp.ums.model.Cert cert = null;
            List certList = this.certService.queryCertBySnList(snList, caAlg);
            for (Cert item : certList) {
                cert = new com.xdja.cssp.ums.model.Cert();
                cert.setCardNo(item.getCardNo());
                cert.setSn(item.getSn());
                cert.setCaAlg(item.getCaAlg().value);
                cert.setCertType(item.getCertType().value);
                cert.setCert(item.getCert());
                result.add(cert);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636eSN\u67e5\u8be2\u8bc1\u4e66\u4fe1\u606f\u65f6\u51fa\u9519", (Throwable)e);
            throw ServiceException.create((String)"\u6839\u636eSN\u67e5\u8be2\u8bc1\u4e66\u4fe1\u606f\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    public Map<String, List<com.xdja.cssp.ums.model.Cert>> queryCertByCardNos(List<String> cardNoList, int caAlg, int certType) {
        this.checkParamter(cardNoList, caAlg, certType);
        try {
            HashMap<String, List<com.xdja.cssp.ums.model.Cert>> result = new HashMap<String, List<com.xdja.cssp.ums.model.Cert>>();
            ArrayList<com.xdja.cssp.ums.model.Cert> certs = null;
            com.xdja.cssp.ums.model.Cert cert = null;
            Map certList = this.certService.queryCertByCardNos(cardNoList, caAlg, certType);
            for (String cardNo : certList.keySet()) {
                certs = (ArrayList<com.xdja.cssp.ums.model.Cert>)result.get(cardNo);
                if (null == certs) {
                    certs = new ArrayList<com.xdja.cssp.ums.model.Cert>();
                    result.put(cardNo, certs);
                }
                for (Cert item : (List)certList.get(cardNo)) {
                    cert = new com.xdja.cssp.ums.model.Cert();
                    cert.setCardNo(item.getCardNo());
                    cert.setSn(item.getSn());
                    cert.setCaAlg(item.getCaAlg().value);
                    cert.setCertType(item.getCertType().value);
                    cert.setCert(item.getCert());
                    certs.add(cert);
                }
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u5361\u53f7\u67e5\u8be2\u8bc1\u4e66\u4fe1\u606f\u65f6\u51fa\u9519", (Throwable)e);
            throw ServiceException.create((String)"\u6839\u636e\u5361\u53f7\u67e5\u8be2\u8bc1\u4e66\u4fe1\u606f\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    public int updateUser(User user) {
        if (null == user || StringUtils.isBlank((CharSequence)user.getAccount()) || StringUtils.isNotBlank((CharSequence)user.getAvatar()) && StringUtils.isBlank((CharSequence)user.getSuffix())) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        String fileName = null;
        String oldAvatarName = null;
        try {
            CharSequence sql;
            String checkSql = "SELECT COUNT(0) FROM t_account_info WHERE c_account = ?";
            if (this.umsDao.queryForLong(checkSql, new Object[]{user.getAccount()}) <= 0L) {
                return 2;
            }
            StringBuffer tmp = new StringBuffer();
            tmp.append("UPDATE t_account_extention SET");
            Map<String, Object> userInfo = RedisUtil.getUserInfo(user.getAccount());
            ArrayList<String> params = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)user.getNickName())) {
                tmp.append(" c_nick_name = ?,");
                params.add(user.getNickName());
                userInfo.put("nickname", user.getNickName());
            }
            if (StringUtils.isNotBlank((CharSequence)user.getMobile())) {
                tmp.append(" c_mobile = ?,");
                params.add(user.getMobile());
                userInfo.put("phone", user.getMobile());
            }
            if (StringUtils.isNotBlank((CharSequence)user.getMail())) {
                tmp.append(" c_mail = ?,");
                params.add(user.getMail());
                userInfo.put("mail", user.getMail());
            }
            if (StringUtils.isNotBlank((CharSequence)user.getAvatar())) {
                try {
                    sql = "SELECT c_avatar_name FROM t_account_extention WHERE c_account = ?";
                    oldAvatarName = this.umsDao.queryForStr((String)sql, new Object[]{user.getAccount()});
                    fileName = AvatarUtil.saveAvatar(user.getAvatar(), user.getSuffix());
                    tmp.append(" c_avatar_name = ?");
                    params.add(fileName);
                    userInfo.put("avatar", fileName);
                }
                catch (Exception e) {
                    this.logger.error("\u4fdd\u5b58\u5934\u50cf\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            }
            if (params.isEmpty()) {
                throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u6ca1\u6709\u8981\u4fee\u6539\u7684\u9879");
            }
            sql = new StringBuffer();
            if (tmp.toString().endsWith(",")) {
                ((StringBuffer)sql).append(tmp.subSequence(0, tmp.lastIndexOf(",")));
            } else {
                ((StringBuffer)sql).append(tmp.toString());
            }
            ((StringBuffer)sql).append(" WHERE c_account = ?");
            params.add(user.getAccount());
            this.umsDao.tx(new IAtom((StringBuffer)sql, params, user, userInfo){
                final /* synthetic */ StringBuffer val$sql;
                final /* synthetic */ List val$params;
                final /* synthetic */ User val$user;
                final /* synthetic */ Map val$userInfo;
                {
                    this.val$sql = stringBuffer;
                    this.val$params = list;
                    this.val$user = user;
                    this.val$userInfo = map;
                }

                public boolean run() throws SQLException {
                    AccountServiceImpl.this.umsDao.update(this.val$sql.toString(), this.val$params.toArray());
                    AccountServiceImpl.this.updateUserIdentify(this.val$user.getAccount(), GenerateIdentify.getIdentify());
                    try {
                        RedisUtil.addUserInfo(this.val$user.getAccount(), JSONUtil.toJSONString((Object)this.val$userInfo));
                    }
                    catch (JSONException e) {
                        AccountServiceImpl.this.logger.error("\u4fee\u6539\u7528\u4fe1\u606f\u5931\u8d25, \u539f\u56e0\uff1a\u66f4\u65b0\u7528\u6237\u7f13\u5b58\u65f6\uff0c\u7528\u6237\u4fe1\u606f\u8f6c\u6362JSON\u5931\u8d25", (Throwable)e);
                        return false;
                    }
                    return true;
                }
            });
            SCNoticeUtil.sendUserModifyNotice(2, user.getAccount());
            if (StringUtils.isNotBlank((CharSequence)oldAvatarName)) {
                try {
                    AvatarUtil.removeAvatar(oldAvatarName);
                }
                catch (Exception e) {
                    this.logger.error("\u7528\u6237\u66f4\u6362\u65b0\u5934\u50cf\u6210\u529f\uff0c\u5220\u9664\u65e7\u5934\u50cf\u5931\u8d25", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            if (StringUtils.isNotBlank(fileName)) {
                AvatarUtil.removeAvatar(fileName);
            }
            throw ServiceException.create((String)String.format("\u4fee\u6539\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u9519\uff0c\u8d26\u53f7\uff1a%s ", user.getAccount()), (Exception)e);
        }
        return 1;
    }

    public List<UserMsg> queryAllUsers() {
        try {
            return this.umsDao.queryForList(this.getQuerySql(false, 0), (ResultSetHandler)new QueryAllUserHandler(), new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6240\u6709\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw ServiceException.create((String)"\u67e5\u8be2\u6240\u6709\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Exception)e);
        }
    }

    public List<UserMsg> getUserByAccount(List<String> accounts) {
        try {
            if (null == accounts || accounts.isEmpty()) {
                throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
            }
            String sql = this.getQuerySql(true, accounts.size());
            return this.umsDao.queryForList(sql, (ResultSetHandler)new QueryAllUserHandler(), accounts.toArray());
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u8d26\u6237\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            try {
                throw ServiceException.create((String)String.format("\u6839\u636e\u8d26\u6237\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8d26\u53f7\uff1a%s ", JSONUtil.toJSONString(accounts)), (Exception)e);
            }
            catch (JSONException e1) {
                this.logger.error("\u8f6c\u6362\u5e10\u53f7\u5217\u8868\u5f02\u5e38", (Throwable)e1);
                throw ServiceException.create((String)"\u6839\u636e\u8d26\u6237\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Exception)e);
            }
        }
    }

    public List<AccountCert> queryCert(QueryCertReq req) {
        this.checkParams(req);
        try {
            HashMap<String, AccountCert> result = new HashMap<String, AccountCert>();
            Map certList = null;
            ArrayList cardNos = null;
            String sql = "SELECT c_account, c_card_no FROM t_account_asset WHERE c_account IN (#accountList)";
            sql = SqlHelper.prepare((String)sql, (String)"#accountList", (int)req.getAccounts().size());
            Map accountCardNos = this.umsDao.queryForMap(sql, (ResultSetHandler)new QueryAccountPublicKeyHandler(), req.getAccounts().toArray());
            cardNos = new ArrayList();
            for (Collection item : accountCardNos.values()) {
                cardNos.addAll(item);
            }
            if (!cardNos.isEmpty() && null != (certList = this.certService.queryCertByCardNos(cardNos, req.getCaAlg(), req.getCertType())) && !certList.isEmpty()) {
                AccountCert accountCert = null;
                ArrayList<com.xdja.cssp.ums.model.Cert> certs = null;
                com.xdja.cssp.ums.model.Cert cert = null;
                for (String account : accountCardNos.keySet()) {
                    for (String cardNo : (List)accountCardNos.get(account)) {
                        if (!certList.containsKey(cardNo)) continue;
                        accountCert = (AccountCert)result.get(account);
                        if (null == accountCert) {
                            accountCert = new AccountCert();
                            accountCert.setAccount(account);
                            result.put(account, accountCert);
                        }
                        if (null == (certs = accountCert.getCerts())) {
                            certs = new ArrayList<com.xdja.cssp.ums.model.Cert>();
                            accountCert.setCerts(certs);
                        }
                        for (Cert pk : (List)certList.get(cardNo)) {
                            cert = new com.xdja.cssp.ums.model.Cert();
                            cert.setCardNo(pk.getCardNo());
                            cert.setSn(pk.getSn());
                            cert.setCaAlg(pk.getCaAlg().value);
                            cert.setCertType(pk.getCertType().value);
                            cert.setCert(pk.getCert());
                            certs.add(cert);
                        }
                    }
                }
            }
            return new ArrayList<AccountCert>(result.values());
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u8d26\u53f7\u67e5\u8be2\u8bc1\u4e66\u65f6\u51fa\u9519", (Throwable)e);
            throw ServiceException.create((String)"\u6839\u636e\u8d26\u53f7\u67e5\u8be2\u8bc1\u4e66\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    public boolean checkAccountExist(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5,\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            String sql = "SELECT COUNT(0) FROM t_account_info WHERE c_account = ?";
            return this.umsDao.queryForLong(sql, new Object[]{account}) > 0L;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u9a8c\u8bc1\u8d26\u53f7%s\u662f\u5426\u5b58\u5728\u65f6\u51fa\u9519", account), (Throwable)e);
            throw ServiceException.create((String)String.format("\u9a8c\u8bc1\u8d26\u53f7%s\u662f\u5426\u5b58\u5728\u65f6\u51fa\u9519", account), (Exception)e);
        }
    }

    public String queryAccountByMobile(String mobile) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5,\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            String sql = "SELECT c_account FROM t_account_extention WHERE c_mobile = ?";
            return this.umsDao.queryForStr(sql, new Object[]{mobile});
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636e\u624b\u673a\u53f7%s\u67e5\u8be2\u8d26\u53f7\u65f6\u51fa\u9519", mobile), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636e\u624b\u673a\u53f7%s\u67e5\u8be2\u8d26\u53f7\u65f6\u51fa\u9519", mobile), (Exception)e);
        }
    }

    public String queryCardNoByUId(String uId) {
        if (StringUtils.isBlank((CharSequence)uId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5,\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            return this.assetService.queryCardNoByUId(uId);
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636eUId\u67e5\u8be2\u5b89\u5168\u5361\u53f7\u65f6\u51fa\u9519\uff0cUId\uff1a", uId), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636eUId\u67e5\u8be2\u5b89\u5168\u5361\u53f7\u65f6\u51fa\u9519\uff0cUId\uff1a", uId), (Exception)e);
        }
    }

    public DeviceInfo queryDeviceByCardNo(String cardNo) {
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            String sql = "SELECT c_asset_identify, c_device_name, n_time FROM t_account_asset WHERE c_card_no = ?";
            Map identifys = this.umsDao.queryForMap(sql, (ResultSetHandler)new QueryDeviceHandler(), new Object[]{cardNo});
            if (identifys.isEmpty()) {
                return null;
            }
            String[] identifyArr = new String[identifys.keySet().size()];
            Asset asset = (Asset)this.assetService.queryAssets(identifys.keySet().toArray(identifyArr)).get(0);
            DeviceInfo device = new DeviceInfo();
            device.setIdentity(asset.getIdentity());
            device.setDeviceName(((DeviceInfo)identifys.get(asset.getIdentity())).getDeviceName());
            device.setType(com.xdja.cssp.ums.model.Type.valueOf((int)asset.getType().value));
            device.setCardNo(asset.getCardNo());
            device.setSerialCode(asset.getSerialCode());
            device.setTime(asset.getTime().longValue());
            device.setInfo(asset.getInfo());
            device.setBindTime(((DeviceInfo)identifys.get(asset.getIdentity())).getBindTime());
            return device;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636e\u5361\u53f7\u67e5\u8be2\u8bbe\u5907\u4fe1\u606f\u65f6\u51fa\u9519\uff0c\u5361\u53f7\uff1a%s ", cardNo), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636e\u5361\u53f7\u67e5\u8be2\u8bbe\u5907\u4fe1\u606f\u65f6\u51fa\u9519\uff0c\u5361\u53f7\uff1a%s ", cardNo), (Exception)e);
        }
    }

    public String querySerialCodeByCardNo(String cardNo) {
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            List assets = this.assetService.queryAssets(new String[]{cardNo});
            if (null == assets || assets.isEmpty()) {
                return null;
            }
            return ((Asset)assets.get(0)).getSerialCode();
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636eUSBKey\u5361\u53f7\u67e5\u8be2USBKey\u5e8f\u5217\u53f7\u65f6\u51fa\u9519\uff0c\u5361\u53f7\uff1a%s ", cardNo), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636eUSBKey\u5361\u53f7\u67e5\u8be2USBKey\u5e8f\u5217\u53f7\u65f6\u51fa\u9519\uff0c\u5361\u53f7\uff1a%s ", cardNo), (Exception)e);
        }
    }

    private String getQuerySql(boolean isWhere, int size) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT info.c_account, info.c_register_time, extention.c_nick_name, extention.c_mobile,");
        sql.append(" extention.c_mail, extention.c_avatar_name, asset.c_asset_identify, asset.c_device_name,");
        sql.append(" asset.n_asset_type, asset.c_card_no FROM t_account_info info");
        sql.append(" LEFT JOIN t_account_extention extention ON info.c_account = extention.c_account");
        sql.append(" JOIN t_account_asset asset ON info.c_account = asset.c_account");
        if (isWhere) {
            sql.append(" WHERE info.c_account IN (#accountList)");
            return SqlHelper.prepare((String)sql.toString(), (String)"#accountList", (int)size);
        }
        return sql.toString();
    }

    private void checkParams(QueryCertReq req) {
        if (null == req || null == req.getAccounts() || req.getAccounts().isEmpty() || !Constants.CA_ALG_LIST.contains(req.getCaAlg()) || !Constants.CERT_TYPE_LIST.contains(req.getCertType())) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a\u6216\u53c2\u6570\u679a\u4e3e\u503c\u4e0d\u5b58\u5728");
        }
    }

    private void checkParamter(List<String> snList, int caAlg) {
        if (null == snList || snList.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        if (caAlg == 0 || !Constants.CA_ALG_LIST.contains(caAlg)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1acaAlg\u4e0d\u518d\u679a\u4e3e\u8303\u56f4\u5185");
        }
    }

    private void checkParamter(List<String> cardNoList, int caAlg, int certType) {
        if (null == cardNoList || cardNoList.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        if (!Constants.CA_ALG_LIST.contains(caAlg)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1acaAlg\u4e0d\u518d\u679a\u4e3e\u8303\u56f4\u5185");
        }
    }

    private void checkParameter(CardInfo cardInfo) {
        if (null == cardInfo || StringUtils.isBlank((CharSequence)cardInfo.getAccount()) || StringUtils.isBlank((CharSequence)cardInfo.getCardNo()) || StringUtils.isBlank((CharSequence)cardInfo.getSn())) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        if (cardInfo.getCaAlg() == 0 || !Constants.CA_ALG_LIST.contains(cardInfo.getCaAlg())) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1acaAlg\u4e0d\u5728\u679a\u4e3e\u8303\u56f4\u5185");
        }
    }

    private int resolveResult(CertStatus certStatus) {
        switch (certStatus.value) {
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 7;
            }
        }
        return 1;
    }

    private int checkCardResolve(CertStatus certStatus) {
        switch (certStatus.value) {
            case 2: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 7;
            }
        }
        return 1;
    }

    private void addAssetOrCardOrCertCache(Asset mobileInfo) {
        if (null != mobileInfo) {
            ArrayList<String> cardNos = new ArrayList<String>();
            cardNos.add(mobileInfo.getCardNo());
            Map certs = this.certService.queryCertByCardNos(cardNos, 1, 2);
            if (null != certs && !certs.isEmpty() && null != certs.get(mobileInfo.getCardNo()) && !((List)certs.get(mobileInfo.getCardNo())).isEmpty()) {
                String value = RedisUtil.mdmHGet(mobileInfo.getIdentity());
                StringBuffer tmpValue = new StringBuffer();
                if (StringUtils.isBlank((CharSequence)value)) {
                    tmpValue.append(mobileInfo.getCardNo());
                    tmpValue.append("-");
                    tmpValue.append(((Cert)((List)certs.get(mobileInfo.getCardNo())).get(0)).getSn());
                } else {
                    tmpValue.append(value);
                    tmpValue.append(",");
                    tmpValue.append(mobileInfo.getCardNo());
                    tmpValue.append("-");
                    tmpValue.append(((Cert)((List)certs.get(mobileInfo.getCardNo())).get(0)).getSn());
                }
                RedisUtil.mdmHSet(mobileInfo.getIdentity(), tmpValue.toString());
            }
        }
    }

    private String getDeviceName(String account, Type type) throws SQLException {
        String sql = "SELECT COUNT(0) FROM t_account_asset WHERE c_account = ? AND n_asset_type = ?";
        long serial = this.umsDao.queryForLong(sql, new Object[]{account, type.value});
        return String.format("%s-%s", StrKit.firstCharToUpperCase((String)type.toString().toLowerCase()), serial < 9L ? "0" + String.valueOf(serial + 1L) : String.valueOf(serial + 1L));
    }

    public void updateLoginTime(String account, long firstLoginTime) {
        if (StringUtils.isBlank((CharSequence)account)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            Object[] params = null;
            long nowTime = System.currentTimeMillis();
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE t_account_info SET c_update_time = ?");
            if (firstLoginTime <= 0L) {
                sql.append(", n_first_login_time = ?");
                params = new Object[]{nowTime, nowTime, account};
            } else {
                params = new Object[]{nowTime, account};
            }
            sql.append(" WHERE c_account = ?");
            this.umsDao.update(sql.toString(), params);
        }
        catch (Exception e) {
            this.logger.error(String.format("\u66f4\u65b0\u8d26\u6237\u767b\u5f55\u65f6\u95f4\u65f6\u51fa\u9519\uff0caccount=%s , firstLoginTime=%s", account, firstLoginTime), (Throwable)e);
            throw ServiceException.create((String)String.format("\u66f4\u65b0\u8d26\u6237\u767b\u5f55\u65f6\u95f4\u65f6\u51fa\u9519\uff0caccount=%s , firstLoginTime=%s", account, firstLoginTime), (Exception)e);
        }
    }

    public Result checkAccountBySn(String cardNo, String sn, int caAlg) {
        if (StringUtils.isBlank((CharSequence)cardNo) || StringUtils.isBlank((CharSequence)sn)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        if (caAlg != 1 && caAlg != 2) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1acaAlg\u4e0d\u5728\u679a\u4e3e\u8303\u56f4\u5185");
        }
        Result result = new Result();
        result.setResultStatus(1);
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT account.c_account account, account.c_login_name loginName,");
            sql.append(" account.n_first_login_time firstLoginTime, account.n_activate_status activateStatus");
            sql.append(" FROM t_account_info account");
            sql.append(" JOIN t_account_asset asset ON account.c_account = asset.c_account");
            sql.append(" WHERE asset.c_card_no = ?");
            Map userInfo = this.umsDao.queryForMap(sql.toString(), new Object[]{cardNo});
            int activateStatus = Integer.parseInt(String.valueOf(userInfo.get("activateStatus")));
            if (activateStatus != 2) {
                result.setResultStatus(7);
                return result;
            }
            if (!this.assetService.exists(cardNo)) {
                result.setResultStatus(2);
                return result;
            }
            CertStatus certStatus = this.certService.checkCertStatus(cardNo, sn, caAlg);
            switch (certStatus.value) {
                case 2: {
                    result.setResultStatus(3);
                    return result;
                }
                case 3: {
                    result.setResultStatus(4);
                    return result;
                }
                case 4: {
                    result.setResultStatus(5);
                    return result;
                }
                case 5: {
                    result.setResultStatus(6);
                    return result;
                }
            }
            userInfo.remove("activateStatus");
            result.setInfo((Object)userInfo);
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636eSN\u68c0\u6d4b\u8d26\u6237\u65f6\u51fa\u9519\uff0ccardNo=%s \uff0cSN=%s, caAlg=%s", cardNo, sn, caAlg), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636eSN\u68c0\u6d4b\u8d26\u6237\u65f6\u51fa\u9519\uff0ccardNo=%s \uff0cSN=%s, caAlg=%s", cardNo, sn, caAlg), (Exception)e);
        }
        return result;
    }

    public UserDetail getUserByAccountOrMobile(String accountOrMobile) {
        try {
            if (StringUtils.isBlank((CharSequence)accountOrMobile)) {
                throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
            }
            UserDetail userDetail = null;
            StringBuffer sql = new StringBuffer(this.createQueryUserSql());
            sql.append(" WHERE info.c_account = ? OR extention.c_mobile = ?");
            sql.append(" AND info.n_activate_status = ?");
            List users = this.umsDao.queryForList(sql.toString(), (ResultSetHandler)new QueryUserBatchHandler(), new Object[]{accountOrMobile, accountOrMobile, 2});
            if (!users.isEmpty()) {
                userDetail = (UserDetail)users.get(0);
            }
            return userDetail;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636e\u8d26\u6237\u3001\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u9519\uff0caccountOrMobile=%s", accountOrMobile), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636e\u8d26\u6237\u3001\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u9519\uff0caccountOrMobile=%s", accountOrMobile), (Exception)e);
        }
    }

    public List<UserDetail> queryUsers(List<String> accounts) {
        try {
            if (null == accounts || accounts.isEmpty()) {
                throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
            }
            StringBuffer sql = new StringBuffer(this.createQueryUserSql());
            sql.append(" WHERE info.c_account IN (#accountList)");
            String tempSql = SqlHelper.prepare((String)sql.toString(), (String)"#accountList", (int)accounts.size());
            return this.umsDao.queryForList(tempSql, (ResultSetHandler)new QueryUserBatchHandler(), accounts.toArray());
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u8d26\u6237\u6279\u91cf\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u9519", (Throwable)e);
            throw ServiceException.create((String)"\u6839\u636e\u8d26\u6237\u6279\u91cf\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u9519", (Exception)e);
        }
    }

    private String createQueryUserSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT info.c_account, info.c_register_time, info.n_first_login_time, info.n_activate_status,");
        sql.append(" extention.c_nick_name, extention.c_mobile,");
        sql.append(" extention.c_mail, extention.c_avatar_name, extention.c_thumbnail_name, extention.c_spell,");
        sql.append(" extention.c_simple_spell, extention.c_avatar_path, extention.c_thumbnail_path,");
        sql.append(" asset.c_asset_identify, asset.c_device_name, asset.n_asset_type, asset.c_card_no");
        sql.append(" FROM t_account_info info");
        sql.append(" LEFT JOIN t_account_extention extention ON info.c_account = extention.c_account");
        sql.append(" JOIN t_account_asset asset ON info.c_account = asset.c_account");
        return sql.toString();
    }

    public Result getUserInfo(String assetIdentify) {
        if (StringUtils.isBlank((CharSequence)assetIdentify)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT info.c_account, extention.c_nick_name, extention.c_simple_spell, extention.c_spell,");
        sql.append(" extention.c_mobile, extention.c_mail, extention.c_avatar_name, extention.c_thumbnail_name,");
        sql.append(" extention.c_avatar_path, extention.c_thumbnail_path, asset.c_device_name");
        sql.append(" FROM t_account_info info");
        sql.append(" LEFT JOIN t_account_extention extention ON info.c_account = extention.c_account");
        sql.append(" JOIN t_account_asset asset ON info.c_account = asset.c_account");
        sql.append(" WHERE asset.c_asset_identify = ?");
        try {
            Result resultBean = new Result();
            resultBean.setResultStatus(1);
            Map result = this.umsDao.queryForMap(sql.toString(), new Object[]{assetIdentify});
            if (null == result || result.isEmpty() || StringUtils.isBlank((CharSequence)((String)result.get("c_account")))) {
                resultBean.setResultStatus(2);
                resultBean.setInfo((Object)"\u8bbe\u5907\u672a\u6ce8\u518c");
            } else {
                HashMap<String, String> userInfo = new HashMap<String, String>();
                userInfo.put("account", (String)result.get("c_account"));
                userInfo.put("deviceName", (String)result.get("c_device_name"));
                userInfo.put("nickName", (String)result.get("c_nick_name"));
                userInfo.put("simpleSpell", (String)result.get("c_simple_spell"));
                userInfo.put("spell", (String)result.get("c_spell"));
                userInfo.put("mobile", (String)result.get("c_mobile"));
                userInfo.put("mail", (String)result.get("c_mail"));
                userInfo.put("avatarFileName", (String)result.get("c_avatar_name"));
                userInfo.put("thumbnailName", (String)result.get("c_thumbnail_name"));
                userInfo.put("avatarFilePath", (String)result.get("c_avatar_path"));
                userInfo.put("thumbnailPath", (String)result.get("c_thumbnail_path"));
                resultBean.setInfo(userInfo);
            }
            return resultBean;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636e\u8d44\u4ea7\u6807\u8bc6%s\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u65f6\u51fa\u9519", assetIdentify), (Throwable)e);
            throw ServiceException.create((String)String.format("\u6839\u636e\u8d44\u4ea7\u6807\u8bc6%s\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u65f6\u51fa\u9519", assetIdentify), (Exception)e);
        }
    }

    public int modifyUser(final ModifyUser user) {
        if (null == user || StringUtils.isBlank((CharSequence)user.getAccount()) || StringUtils.isNotBlank((CharSequence)user.getAvatarFileName()) && StringUtils.isBlank((CharSequence)user.getThumbnailName()) || StringUtils.isBlank((CharSequence)user.getAvatarFileName()) && StringUtils.isNotBlank((CharSequence)user.getThumbnailName()) || StringUtils.isNotBlank((CharSequence)user.getAvatarFileName()) && StringUtils.isBlank((CharSequence)user.getAvatarFilePath()) || StringUtils.isBlank((CharSequence)user.getAvatarFileName()) && StringUtils.isNotBlank((CharSequence)user.getAvatarFilePath()) || StringUtils.isNotBlank((CharSequence)user.getThumbnailName()) && StringUtils.isBlank((CharSequence)user.getThumbnailPath()) || StringUtils.isBlank((CharSequence)user.getThumbnailName()) && StringUtils.isNotBlank((CharSequence)user.getThumbnailPath())) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            String checkSql = "SELECT COUNT(0) FROM t_account_info WHERE c_account = ?";
            if (this.umsDao.queryForLong(checkSql, new Object[]{user.getAccount()}) <= 0L) {
                return 2;
            }
            StringBuffer tmp = new StringBuffer();
            tmp.append("UPDATE t_account_extention SET");
            final Map<String, Object> userInfo = RedisUtil.getUserInfo(user.getAccount());
            final ArrayList<String> params = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)user.getNickName())) {
                tmp.append(" c_nick_name = ?, c_simple_spell = ?, c_spell = ?,");
                String simpleSpell = SpellUtil.converterToFirstSpell(user.getNickName());
                String spell = SpellUtil.converterToSpell(user.getNickName());
                params.add(user.getNickName());
                params.add(simpleSpell);
                params.add(spell);
                userInfo.put("nickname", user.getNickName());
                userInfo.put("nicknamePy", simpleSpell);
                userInfo.put("nicknamePinyin", spell);
            }
            if (StringUtils.isNotBlank((CharSequence)user.getMobile())) {
                tmp.append(" c_mobile = ?,");
                params.add(user.getMobile());
                userInfo.put("phone", user.getMobile());
            }
            if (StringUtils.isNotBlank((CharSequence)user.getMail())) {
                tmp.append(" c_mail = ?,");
                params.add(user.getMail());
                userInfo.put("mail", user.getMail());
            }
            if (StringUtils.isNotBlank((CharSequence)user.getAvatarFileName()) && StringUtils.isNotBlank((CharSequence)user.getThumbnailName()) && StringUtils.isNotBlank((CharSequence)user.getAvatarFilePath()) && StringUtils.isNotBlank((CharSequence)user.getThumbnailPath())) {
                tmp.append(" c_avatar_name = ?, c_thumbnail_name = ?, c_avatar_path = ?, c_thumbnail_path = ?");
                params.add(user.getAvatarFileName());
                params.add(user.getThumbnailName());
                params.add(user.getAvatarFilePath());
                params.add(user.getThumbnailPath());
                userInfo.put("avatar", user.getAvatarFileName());
                userInfo.put("thumbnail", user.getThumbnailName());
                userInfo.put("avatarDownloadUrl", user.getAvatarFilePath());
                userInfo.put("thumbnailDownloadUrl", user.getThumbnailPath());
            }
            if (params.isEmpty()) {
                throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u6ca1\u6709\u8981\u4fee\u6539\u7684\u9879");
            }
            final StringBuffer sql = new StringBuffer();
            if (tmp.toString().endsWith(",")) {
                sql.append(tmp.subSequence(0, tmp.lastIndexOf(",")));
            } else {
                sql.append(tmp.toString());
            }
            sql.append(" WHERE c_account = ?");
            params.add(user.getAccount());
            this.umsDao.tx(new IAtom(){

                public boolean run() throws SQLException {
                    AccountServiceImpl.this.umsDao.update(sql.toString(), params.toArray());
                    AccountServiceImpl.this.updateUserIdentify(user.getAccount(), GenerateIdentify.getIdentify());
                    try {
                        RedisUtil.addUserInfo(user.getAccount(), JSONUtil.toJSONString((Object)userInfo));
                    }
                    catch (JSONException e) {
                        AccountServiceImpl.this.logger.error("\u4fee\u6539\u7528\u4fe1\u606f\u5931\u8d25, \u539f\u56e0\uff1a\u66f4\u65b0\u7528\u6237\u7f13\u5b58\u65f6\uff0c\u7528\u6237\u4fe1\u606f\u8f6c\u6362JSON\u5931\u8d25", (Throwable)e);
                        return false;
                    }
                    return true;
                }
            });
            SCNoticeUtil.sendUserModifyNotice(2, user.getAccount());
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw ServiceException.create((String)String.format("\u4fee\u6539\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u9519\uff0c\u8d26\u53f7\uff1a%s ", user.getAccount()), (Exception)e);
        }
        return 1;
    }

    public Result deviceUnBind(final UnDeviceBind unDeviceBind) {
        if (null == unDeviceBind || StringUtils.isBlank((CharSequence)unDeviceBind.getAccount()) || StringUtils.isBlank((CharSequence)unDeviceBind.getCardNo())) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            final StringBuffer insertSql = new StringBuffer();
            insertSql.append("INSERT INTO t_account_asset(c_account, c_asset_identify, c_device_name,");
            insertSql.append(" n_asset_type, c_card_no, n_time)");
            insertSql.append(" VALUES(?,?,?,?,?,?)");
            String insertAccountSql = "INSERT INTO t_account_info(c_account, c_register_time) VALUES(?, ?)";
            String insertAccountExtentionsSql = "INSERT INTO t_account_extention(c_account) VALUES(?)";
            final String newAccount = this.accountService.generateAccount();
            final long nowTime = System.currentTimeMillis();
            this.umsDao.tx(new IAtom(){

                public boolean run() throws SQLException {
                    Asset asset = (Asset)AccountServiceImpl.this.assetService.queryAssets(new String[]{unDeviceBind.getCardNo()}).get(0);
                    AccountServiceImpl.this.umsDao.update("DELETE FROM t_account_asset WHERE c_asset_identify=?", new Object[]{asset.getIdentity()});
                    String deviceName = null;
                    Asset mobileInfo = null;
                    if (asset.getType().value != com.xdja.cssp.ums.model.Type.USBKey.value && asset.getType().value != com.xdja.cssp.ums.model.Type.TF.value) {
                        deviceName = AccountServiceImpl.this.getDeviceName(newAccount, asset.getType());
                        mobileInfo = asset;
                    }
                    AccountServiceImpl.this.umsDao.update(insertSql.toString(), new Object[]{newAccount, asset.getIdentity(), deviceName, asset.getType().value, asset.getCardNo(), nowTime});
                    AccountServiceImpl.this.umsDao.update("INSERT INTO t_account_info(c_account, c_register_time) VALUES(?, ?)", new Object[]{newAccount, nowTime});
                    AccountServiceImpl.this.umsDao.update("INSERT INTO t_account_extention(c_account) VALUES(?)", new Object[]{newAccount});
                    AccountServiceImpl.this.addAssetOrCardOrCertCache(mobileInfo);
                    return AccountServiceImpl.this.addUserInfoCache(newAccount);
                }
            });
            SCNoticeUtil.sendUserModifyNotice(3, unDeviceBind.getAccount());
            SCNoticeUtil.sendUserModifyNotice(1, newAccount);
            Result result = new Result();
            result.setResultStatus(1);
            result.setInfo((Object)newAccount);
            return result;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u8bbe\u5907\u89e3\u7ed1\u65f6\u51fa\u9519\uff0c\u8d26\u53f7\uff1a%s \uff0c\u5361\u53f7\uff1a%s", unDeviceBind.getAccount(), unDeviceBind.getCardNo()), (Throwable)e);
            throw ServiceException.create((String)String.format("\u8bbe\u5907\u89e3\u7ed1\u65f6\u51fa\u9519\uff0c\u8d26\u53f7\uff1a%s \uff0c\u5361\u53f7\uff1a%s", unDeviceBind.getAccount(), unDeviceBind.getCardNo()), (Exception)e);
        }
    }

    private boolean addUserInfoCache(String account) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("account", account);
            map.put("firstLoginTime", 0);
            map.put("activateStatus", 2);
            map.put("nickname", null);
            map.put("nicknamePy", null);
            map.put("nicknamePinyin", null);
            map.put("phone", null);
            map.put("mail", null);
            map.put("avatar", null);
            map.put("thumbnail", null);
            map.put("avatarDownloadUrl", null);
            map.put("thumbnailDownloadUrl", null);
            RedisUtil.addUserInfo(account, JSONUtil.toJSONString(map));
        }
        catch (JSONException e) {
            this.logger.error("\u89e3\u7ed1\u8bbe\u5907\u5931\u8d25, \u539f\u56e0\uff1a\u4fdd\u5b58\u7528\u6237\u57fa\u672c\u4fe1\u606f\u7f13\u5b58\u65f6\uff0c\u7528\u6237\u4fe1\u606f\u8f6c\u6362JSON\u5931\u8d25", (Throwable)e);
            return false;
        }
        return true;
    }

    public Map<String, Boolean> checkAccountExistBatch(List<String> accounts) {
        if (null == accounts || accounts.isEmpty()) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            for (String account : accounts) {
                result.put(account, RedisUtil.checkAccountExist(account));
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6279\u91cf\u9a8c\u8bc1\u8d26\u6237\u662f\u5426\u5b58\u5728\u65f6\u5931\u8d25", (Throwable)e);
            throw ServiceException.create((String)"\u6279\u91cf\u9a8c\u8bc1\u8d26\u6237\u662f\u5426\u5b58\u5728\u65f6\u5931\u8d25", (Exception)e);
        }
    }

    public int checkAccountSnRelation(String account, String sn, int caAlg) {
        if (StringUtils.isBlank((CharSequence)account) || StringUtils.isBlank((CharSequence)sn)) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u53c2\u6570\u4e3a\u7a7a");
        }
        if (caAlg != 1 && caAlg != 2) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1acaAlg\u4e0d\u5728\u679a\u4e3e\u8303\u56f4\u5185");
        }
        try {
            List publicKeys = null;
            ArrayList<String> snList = new ArrayList<String>();
            snList.add(sn);
            publicKeys = this.certService.queryPublicKeyBySnList(snList, caAlg);
            if (null == publicKeys || publicKeys.isEmpty()) {
                return 2;
            }
            if (!RedisUtil.checkAccountExist(account)) {
                return 3;
            }
            String sql = "SELECT COUNT(0) FROM t_account_asset WHERE c_account = ? AND c_asset_identify = ?";
            long count = this.umsDao.queryForLong(sql, new Object[]{account, ((com.xdja.cssp.acs.bean.cert.PublicKey)publicKeys.get(0)).getCardNo()});
            if (count <= 0L) {
                return 4;
            }
            return 1;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u9a8c\u8bc1\u8d26\u53f7\u3001SN\u5173\u7cfb\u65f6\u5931\u8d25, account=%s ,SN=% ,caAlg=%s", account, sn, caAlg), (Throwable)e);
            throw ServiceException.create((String)String.format("\u9a8c\u8bc1\u8d26\u53f7\u3001SN\u5173\u7cfb\u65f6\u5931\u8d25, account=%s ,SN=% ,caAlg=%s", account, sn, caAlg), (Exception)e);
        }
    }

    private void updateUserIdentify(String account, long identify) throws SQLException {
        String sql = "UPDATE t_account_info SET n_identify = ? WHERE c_account = ?";
        this.umsDao.update(sql, new Object[]{identify, account});
        RedisUtil.addUserIdentify(account, identify);
    }
}

