/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ums.service.impl;

import com.xdja.cssp.ums.model.AccountAsset;
import com.xdja.cssp.ums.service.IUserAssetService;
import com.xdja.cssp.ums.service.util.GenerateIdentify;
import com.xdja.cssp.ums.service.util.RedisUtil;
import com.xdja.cssp.ums.service.util.SCNoticeUtil;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.db.Dao;
import com.xdja.platform.microservice.db.SqlHelper;
import com.xdja.platform.microservice.db.tx.IAtom;
import com.xdja.platform.util.json.JSONUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserAssetServiceImpl
implements IUserAssetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Dao umsDao = Dao.use((String)"db::ums");

    public void add(List<AccountAsset> accountAsset) {
        this.logger.info("\u5f00\u59cb\u6279\u91cf\u6dfb\u52a0\u8d26\u6237");
        if (null != accountAsset && !accountAsset.isEmpty()) {
            final Object[][] accountParams = new Object[accountAsset.size()][4];
            final Object[][] extentionParams = new Object[accountAsset.size()][1];
            final Object[][] assetParams = new Object[accountAsset.size()][6];
            final Object[][] delAccount = new Object[accountAsset.size()][1];
            final Object[][] delAsset = new Object[accountAsset.size()][1];
            final ArrayList<String> accountList = new ArrayList<String>();
            final ArrayList<String> assetList = new ArrayList<String>();
            final HashMap<String, String> assetMap = new HashMap<String, String>();
            long nowTime = System.currentTimeMillis();
            AccountAsset asset = null;
            for (int i = 0; i < accountAsset.size(); ++i) {
                asset = accountAsset.get(i);
                if (null == asset) continue;
                accountParams[i][0] = asset.getAccount();
                accountParams[i][1] = nowTime;
                accountParams[i][2] = 2;
                accountParams[i][3] = GenerateIdentify.getIdentify();
                extentionParams[i][0] = asset.getAccount();
                assetParams[i][0] = asset.getAccount();
                assetParams[i][1] = asset.getCardNo();
                assetParams[i][2] = "Phone-01";
                assetParams[i][3] = asset.getType();
                assetParams[i][4] = asset.getCardNo();
                assetParams[i][5] = nowTime;
                delAsset[i][0] = asset.getCardNo();
                delAccount[i][0] = asset.getAccount();
                accountList.add(asset.getAccount());
                assetList.add(asset.getCardNo());
                assetMap.put(asset.getCardNo(), asset.getSignSn());
            }
            try {
                this.umsDao.tx(new IAtom(){

                    public boolean run() throws SQLException {
                        UserAssetServiceImpl.this.del(delAccount, delAsset, accountList, assetList);
                        try {
                            UserAssetServiceImpl.this.addAccounts(accountParams, extentionParams, assetParams, assetMap);
                        }
                        catch (Exception e) {
                            UserAssetServiceImpl.this.logger.error("\u4fdd\u5b58\u65b0\u540c\u6b65\u8d26\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                            throw new SQLException(e);
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                this.logger.error("\u6279\u91cf\u6dfb\u52a0\u8d26\u6237\u5931\u8d25", (Throwable)e);
                throw ServiceException.create((String)"\u6279\u91cf\u6dfb\u52a0\u8d26\u6237\u5931\u8d25", (Exception)e);
            }
        } else {
            this.logger.warn("\u6279\u91cf\u6dfb\u52a0\u8d26\u6237\u65f6\uff0c\u63a5\u6536\u5230\u7684\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.logger.info("\u6279\u91cf\u6dfb\u52a0\u8d26\u6237\u7ed3\u675f");
    }

    private void del(Object[][] delAccount, Object[][] delAsset, List<String> accountList, List<String> assetList) throws SQLException {
        this.umsDao.batch("DELETE FROM t_account_info WHERE c_account = ?", delAccount);
        this.umsDao.batch("DELETE FROM t_account_extention WHERE c_account = ?", delAccount);
        this.umsDao.batch("DELETE FROM t_account_asset WHERE c_asset_identify = ?", delAsset);
        String[] assets = assetList.toArray(new String[assetList.size()]);
        RedisUtil.mdmHDel(assets);
        String[] accounts = accountList.toArray(new String[accountList.size()]);
        RedisUtil.delUserInfo(accounts);
        RedisUtil.delUserIdentify(accounts);
        SCNoticeUtil.sendUserModifyNotice(3, accounts);
    }

    private void addAccounts(Object[][] accountParams, Object[][] extentionParams, Object[][] assetParams, Map<String, String> assetMap) throws Exception {
        String accountInfoSql = "INSERT INTO t_account_info(c_account, c_register_time, n_activate_status, n_identify) VALUES(?, ?, ?, ?)";
        this.umsDao.batch(accountInfoSql, accountParams);
        String extentionSql = "INSERT INTO t_account_extention(c_account) VALUES(?)";
        this.umsDao.batch(extentionSql, extentionParams);
        String assetSql = "INSERT INTO t_account_asset(c_account, c_asset_identify, c_device_name, n_asset_type, c_card_no, n_time) VALUES(?,?,?,?,?,?)";
        this.umsDao.batch(assetSql, assetParams);
        String[] accounts = new String[accountParams.length];
        Object[] accountInfo = null;
        HashMap<String, Object> map = null;
        for (int i = 0; i < accountParams.length; ++i) {
            accountInfo = accountParams[i];
            RedisUtil.addUserIdentify(String.valueOf(accountInfo[0]), Long.parseLong(String.valueOf(accountInfo[3])));
            map = new HashMap<String, Object>();
            map.put("account", String.valueOf(accountInfo[0]));
            map.put("firstLoginTime", 0);
            map.put("activateStatus", Integer.parseInt(String.valueOf(accountInfo[2])));
            map.put("nickname", null);
            map.put("nicknamePy", null);
            map.put("nicknamePinyin", null);
            map.put("phone", null);
            map.put("mail", null);
            map.put("avatar", null);
            map.put("thumbnail", null);
            map.put("avatarDownloadUrl", null);
            map.put("thumbnailDownloadUrl", null);
            RedisUtil.addUserInfo(String.valueOf(accountInfo[0]), JSONUtil.toJSONString(map));
            accounts[i] = String.valueOf(accountInfo[0]);
        }
        this.addMdmCache(assetMap);
        SCNoticeUtil.sendUserModifyNotice(1, accounts);
    }

    private void addMdmCache(Map<String, String> assetMap) {
        StringBuffer value = null;
        for (String cardNo : assetMap.keySet()) {
            value = new StringBuffer();
            value.append(cardNo);
            value.append("-");
            value.append(assetMap.get(cardNo));
            RedisUtil.mdmHSet(cardNo, value.toString());
        }
    }

    public void modify(List<AccountAsset> accountAsset) {
        this.logger.info("\u5f00\u59cb\u6279\u91cf\u66f4\u6539\u8d26\u53f7\u8d44\u4ea7\u5173\u7cfb\u3001\u8d44\u4ea7\u7c7b\u578b");
        if (null != accountAsset && !accountAsset.isEmpty()) {
            try {
                Object[][] params = new Object[accountAsset.size()][3];
                ArrayList<String> cardNos = new ArrayList<String>();
                AccountAsset item = null;
                for (int i = 0; i < accountAsset.size(); ++i) {
                    item = accountAsset.get(i);
                    params[i][0] = item.getAccount();
                    params[i][1] = item.getType();
                    params[i][2] = item.getCardNo();
                    cardNos.add(item.getCardNo());
                }
                String querySql = "SELECT COUNT(0) FROM t_account_asset WHERE c_asset_identify IN (#cardNos)";
                long count = this.umsDao.queryForLong(querySql = SqlHelper.prepare((String)querySql, (String)"#cardNos", (int)cardNos.size()), cardNos.toArray());
                if (count <= 0L || count != (long)cardNos.size()) {
                    throw new Exception("\u8d26\u53f7\u8d44\u4ea7\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u66f4\u6539\u8d26\u53f7\u8d44\u4ea7\u5173\u7cfb");
                }
                String sql = "UPDATE t_account_asset SET c_account = ?, n_asset_type = ? WHERE c_asset_identify = ?";
                this.umsDao.batch(sql, params);
            }
            catch (Exception e) {
                this.logger.error("\u6279\u91cf\u66f4\u6539\u8d26\u53f7\u8d44\u4ea7\u5173\u7cfb\u3001\u8d44\u4ea7\u7c7b\u578b\u5931\u8d25", (Throwable)e);
                throw ServiceException.create((String)"\u6279\u91cf\u66f4\u6539\u8d26\u53f7\u8d44\u4ea7\u5173\u7cfb\u3001\u8d44\u4ea7\u7c7b\u578b\u5931\u8d25", (Exception)e);
            }
        } else {
            this.logger.warn("\u6279\u91cf\u66f4\u6539\u8d26\u53f7\u8d44\u4ea7\u5173\u7cfb\u3001\u8d44\u4ea7\u7c7b\u578b\u65f6\uff0c\u8d26\u53f7\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.logger.info("\u6279\u91cf\u66f4\u6539\u8d26\u53f7\u8d44\u4ea7\u5173\u7cfb\u3001\u8d44\u4ea7\u7c7b\u578b\u7ed3\u675f");
    }

    public void revoke(List<String> cardNos) {
        this.logger.info("\u5f00\u59cb\u6279\u91cf\u64a4\u9500\u8d26\u6237\u4fe1\u606f");
        if (null != cardNos && !cardNos.isEmpty()) {
            try {
                String sql = "DELETE FROM t_account_asset WHERE c_asset_identify = ?";
                Object[][] params = new Object[cardNos.size()][1];
                String[] cardNoArr = new String[cardNos.size()];
                for (int i = 0; i < cardNos.size(); ++i) {
                    params[i][0] = cardNos.get(i);
                    cardNoArr[i] = cardNos.get(i);
                }
                this.umsDao.batch(sql, params);
                RedisUtil.mdmHDel(cardNoArr);
            }
            catch (SQLException e) {
                this.logger.error("\u6279\u91cf\u64a4\u9500\u8d26\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                throw ServiceException.create((String)"\u6279\u91cf\u64a4\u9500\u8d26\u6237\u4fe1\u606f\u5931\u8d25", (Exception)e);
            }
        } else {
            this.logger.warn("\u6279\u91cf\u64a4\u9500\u8d26\u6237\u4fe1\u606f\u65f6\uff0c\u5361\u53f7\u5217\u8868\u4e3a\u7a7a");
        }
        this.logger.info("\u6279\u91cf\u64a4\u9500\u8d26\u6237\u4fe1\u606f\u7ed3\u675f");
    }
}

