/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ums.service.impl.handler;

import com.xdja.cssp.ums.model.DeviceMsg;
import com.xdja.cssp.ums.model.UserMsg;
import com.xdja.cssp.ums.service.util.AvatarUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryAllUserHandler
implements ResultSetHandler<List<UserMsg>> {
    private Logger logger = LoggerFactory.getLogger(QueryAllUserHandler.class);

    public List<UserMsg> handle(ResultSet rs) throws SQLException {
        HashMap<String, UserMsg> result = new HashMap<String, UserMsg>();
        UserMsg userMsg = null;
        ArrayList<DeviceMsg> devices = null;
        DeviceMsg device = null;
        while (rs.next()) {
            String account = rs.getString("c_account");
            String avatarName = rs.getString("c_avatar_name");
            userMsg = (UserMsg)result.get(account);
            if (null == userMsg) {
                userMsg = new UserMsg();
                result.put(account, userMsg);
            }
            if (StringUtils.isBlank((CharSequence)userMsg.getAccount())) {
                userMsg.setAccount(account);
                userMsg.setNickName(rs.getString("c_nick_name"));
                userMsg.setMobile(rs.getString("c_mobile"));
                userMsg.setMail(rs.getString("c_mail"));
                userMsg.setRegisterTime(rs.getLong("c_register_time"));
                if (StringUtils.isNotBlank((CharSequence)avatarName) && StringUtils.isBlank((CharSequence)userMsg.getAvatar())) {
                    try {
                        userMsg.setAvatar(AvatarUtil.getAvatar(avatarName));
                        userMsg.setSuffix(avatarName.substring(avatarName.lastIndexOf(".") + 1));
                    }
                    catch (Exception e) {
                        this.logger.error("\u67e5\u8be2\u7528\u6237\u6240\u6709\u4fe1\u606f\u65f6\u83b7\u53d6\u7528\u6237\u5934\u50cf\u5931\u8d25\uff0c\u8d26\u6237\uff1a{}\uff0c\u5934\u50cf\u540d\u79f0\uff1a{}", (Object)account, (Object)avatarName);
                    }
                }
            }
            if (null == (devices = userMsg.getDevices())) {
                devices = new ArrayList<DeviceMsg>();
                userMsg.setDevices(devices);
            }
            device = new DeviceMsg();
            device.setIdentity(rs.getString("c_asset_identify"));
            device.setType(rs.getInt("n_asset_type"));
            device.setName(rs.getString("c_device_name"));
            device.setCardNo(rs.getString("c_card_no"));
            devices.add(device);
        }
        return new ArrayList<UserMsg>(result.values());
    }
}

