/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ums.service.init;

import com.xdja.cssp.acs.ICertService;
import com.xdja.cssp.acs.bean.cert.Cert;
import com.xdja.cssp.ums.service.impl.handler.LoadMdmCacheHandler;
import com.xdja.cssp.ums.service.util.RedisUtil;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.db.Dao;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitMdmCache {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Dao umsDao = Dao.use((String)"db::ums");
    private ICertService certService = (ICertService)DefaultServiceRefer.getServiceRefer(ICertService.class);
    private final int batchLength = 150;

    private InitMdmCache() {
    }

    private void init() {
        this.logger.info("\u5f00\u59cb\u52a0\u8f7dMDM\u7f13\u5b58\u6570\u636e");
        try {
            String sql = "SELECT c_card_no FROM t_account_asset";
            List allCardNos = this.umsDao.queryForList(sql, (ResultSetHandler)new LoadMdmCacheHandler(), new Object[0]);
            if (allCardNos.isEmpty()) {
                return;
            }
            int count = allCardNos.size() / 150 + (allCardNos.size() % 150 != 0 ? 1 : 0);
            HashMap allCerts = new HashMap();
            Map certs = null;
            StringBuffer value = null;
            List tmp = null;
            for (int i = 0; i < count; ++i) {
                tmp = i + 1 != count ? allCardNos.subList(i * 150, (i + 1) * 150) : allCardNos.subList(i * 150, allCardNos.size());
                certs = this.certService.queryCertByCardNos(tmp, 1, 2);
                if (null == certs || certs.isEmpty()) continue;
                allCerts.putAll(certs);
            }
            if (!allCerts.isEmpty()) {
                for (List certList : allCerts.values()) {
                    if (null == certList || certList.isEmpty() || null == certList.get(0)) continue;
                    value = new StringBuffer();
                    value.append(((Cert)certList.get(0)).getCardNo());
                    value.append("-");
                    value.append(((Cert)certList.get(0)).getSn());
                    RedisUtil.mdmHSet(((Cert)certList.get(0)).getCardNo(), value.toString());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u52a0\u8f7dMDM\u7f13\u5b58\u6570\u636e\u65f6\u51fa\u9519", (Throwable)e);
            throw ServiceException.create((String)"\u52a0\u8f7dMDM\u7f13\u5b58\u6570\u636e\u65f6\u51fa\u9519", (Exception)e);
        }
        this.logger.info("\u52a0\u8f7dMDM\u7f13\u5b58\u6570\u636e\u5b8c\u6210");
    }

    public static void loadCache() {
        new InitMdmCache().init();
    }
}

