/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ums.service.util;

import com.xdja.cssp.ums.service.Constants;
import com.xdja.cssp.ums.service.util.Base64Util;
import com.xdja.cssp.ums.service.util.SHA1;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarUtil {
    private static Logger logger = LoggerFactory.getLogger(AvatarUtil.class);

    public static final String getAvatar(String avatarName) throws Exception {
        String avatar = "";
        if (StringUtils.isBlank((CharSequence)avatarName)) {
            return avatar;
        }
        StringBuffer avatarPath = new StringBuffer();
        avatarPath.append(Constants.getAvatarPath()).append(File.separator).append(avatarName);
        File file = new File(avatarPath.toString());
        if (!file.exists()) {
            return avatar;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            avatar = Base64Util.getBase64(AvatarUtil.readFile(in, (int)file.length()));
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u5934\u50cf\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw e;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8bfb\u53d6\u5934\u50cfIO\u6d41\u5931\u8d25", (Throwable)e);
                }
                in = null;
            }
        }
        return avatar;
    }

    public static final String saveAvatar(String avatar, String suffix) throws Exception {
        if (StringUtils.isBlank((CharSequence)avatar) || StringUtils.isBlank((CharSequence)suffix)) {
            return "";
        }
        FilterOutputStream out = null;
        try {
            File path = new File(Constants.getAvatarPath());
            if (!path.exists()) {
                path.mkdirs();
            }
            StringBuffer fileName = new StringBuffer();
            fileName.append(SHA1.getSHA1ofStr(avatar)).append(".").append(suffix.replace(".", ""));
            File file = new File(Constants.getAvatarPath() + File.separator + fileName.toString());
            if (file.exists()) {
                file.delete();
            }
            out = new BufferedOutputStream(new FileOutputStream(file));
            out.write(Base64Util.getByteByBase64(avatar));
            ((BufferedOutputStream)out).flush();
            String string = fileName.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5934\u50cf\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw e;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u4fdd\u5b58\u5934\u50cfIO\u6d41\u5931\u8d25", (Throwable)e);
                }
                out = null;
            }
        }
    }

    public static final void removeAvatar(String avatarName) {
        if (StringUtils.isBlank((CharSequence)avatarName)) {
            return;
        }
        File file = new File(Constants.getAvatarPath() + File.separator + avatarName);
        if (file.exists()) {
            file.delete();
        }
    }

    private static byte[] readFile(InputStream in, int length) throws Exception {
        byte[] data = new byte[length];
        byte[] buffer = new byte[1024];
        int sum = 0;
        int num = 0;
        while (sum < length && (num = in.read(buffer)) != -1) {
            if (sum + num > length) {
                int validLen = length - sum;
                System.arraycopy(buffer, 0, data, sum, validLen);
                sum += validLen;
                continue;
            }
            System.arraycopy(buffer, 0, data, sum, num);
            sum += num;
        }
        if (sum < length) {
            throw new Exception("\u8bfb\u53d6\u6587\u4ef6\u957f\u5ea6\u5c0f\u4e8e\u6587\u4ef6\u957f\u5ea6");
        }
        return data;
    }

    public static void main(String[] args) throws Exception {
        Constants.AVATAR_PATH = "d:/";
        System.out.println(AvatarUtil.getAvatar("aa.cer"));
    }
}

