/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ums.service.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.redis.core.RedisClientConfig;
import com.xdja.platform.redis.core.RedisClientFactory;
import com.xdja.platform.redis.core.action.JedisActionNoResult;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import redis.clients.jedis.Jedis;

public final class RedisUtil
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(RedisUtil.class);
    private static RedisClient redisClient;
    private static final String REDIS_MDM_PATH = "system.properties";
    private static final String REDIS_MDM_MAP_KEY = "mdmp_terminalCertMap";

    public static RedisClient getRedisClient() {
        return redisClient;
    }

    public void afterPropertiesSet() throws Exception {
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316Redis\u7f13\u5b58\u5ba2\u6237\u7aef");
        Prop redisProp = PropKit.use((String)REDIS_MDM_PATH);
        RedisClientConfig config = new RedisClientConfig();
        config.setHost(redisProp.get("redis.host"));
        config.setPort(Integer.parseInt(redisProp.get("redis.port")));
        config.setTimeout(Integer.parseInt(redisProp.get("redis.timeout")));
        config.setMaxTotal(redisProp.get("redis.maxTotal"));
        config.setMaxIdle(redisProp.get("redis.maxIdle"));
        redisClient = RedisClientFactory.getClient((RedisClientConfig)config);
        logger.info("\u521d\u59cb\u5316Redis\u7f13\u5b58\u5ba2\u6237\u7aef\u6210\u529f");
    }

    public static void reload(RedisClientConfig config) {
        logger.info("\u91cd\u65b0\u521d\u59cb\u5316Redis\u7f13\u5b58\u5ba2\u6237\u7aef");
        redisClient = RedisClientFactory.getClient((RedisClientConfig)config);
        logger.info("\u91cd\u65b0\u521d\u59cb\u5316Redis\u7f13\u5b58\u5ba2\u6237\u7aef\u6210\u529f");
    }

    public static void mdmHSet(String field, String value) {
        redisClient.hset(REDIS_MDM_MAP_KEY, field, value);
        logger.debug(String.format("write key field value is key[%s],field[%s],value[%s]", REDIS_MDM_MAP_KEY, field, value));
    }

    public static String mdmHGet(String field) {
        return redisClient.hget(REDIS_MDM_MAP_KEY, field);
    }

    public static void mdmHDel(String ... field) {
        redisClient.hdel(REDIS_MDM_MAP_KEY, field);
    }

    public static void addUserInfo(String account, String value) {
        String key = String.format("acc_%s", account);
        redisClient.hset(key, "v", value);
        logger.debug(String.format("write key field value is key[%s],field[%s],value[%s]", key, "v", value));
    }

    public static void delUserInfo(String ... accounts) {
        if (null != accounts && accounts.length > 0) {
            for (int i = 0; i < accounts.length; ++i) {
                String key = String.format("acc_%s", accounts[i]);
                redisClient.hdel(key, new String[]{"v"});
            }
        }
    }

    public static void addUserIdentify(String account, long score) {
        String member = String.format("acc_%s", account);
        redisClient.zaddOrUpdate("acc_score", member, new BigDecimal(score).doubleValue());
        logger.debug(String.format("write key field value is key[%s],member[%s],score[%s]", "acc_score", member, score));
    }

    public static void delUserIdentify(String ... accounts) {
        if (null != accounts && accounts.length > 0) {
            final String[] members = new String[accounts.length];
            for (int i = 0; i < accounts.length; ++i) {
                members[i] = String.format("acc_%s", accounts[i]);
            }
            redisClient.execute(new JedisActionNoResult(){

                public void action(Jedis jedis) {
                    jedis.zrem("acc_score", members);
                }
            });
        }
    }

    public static Map<String, Object> getUserInfo(String account) throws JSONException {
        String key = String.format("acc_%s", account);
        return (Map)JSONUtil.toSimpleJavaBean((String)redisClient.hget(key, "v"), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static boolean checkAccountExist(String account) {
        return redisClient.exists(String.format("acc_%s", account));
    }
}

