/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.dataferry.thrift.rpcstubpool;

import com.xdja.dataferry.thrift.common.DefaultValues;
import com.xdja.dataferry.thrift.rpcstubpool.RpcClientInfo;
import com.xdja.dataferry.thrift.rpcstubpool.TmultiplexedFactory;
import com.xdja.dataferry.thrift.stub.TaskManagerStub;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcStubTaskManagerAsyncFactory
implements PooledObjectFactory<RpcClientInfo<TaskManagerStub.AsyncClient>> {
    private static Logger logger = LoggerFactory.getLogger(RpcStubTaskManagerAsyncFactory.class);
    private final String host;
    private final int port;
    private final int serverMode;
    public AtomicLong logId = new AtomicLong(-1L);

    private String getClassName() {
        return "RpcStubTaskManagerAsyncFactory";
    }

    public RpcStubTaskManagerAsyncFactory(String host, int port, int mode) {
        this.host = host;
        this.port = port;
        this.serverMode = mode;
    }

    public PooledObject<RpcClientInfo<TaskManagerStub.AsyncClient>> makeObject() throws Exception {
        String logFlag = this.getClassName() + ".makeObject";
        this.logId.getAndDecrement();
        TmultiplexedFactory factory = null;
        TAsyncClientManager clientManager = null;
        TNonblockingSocket transport = null;
        if (this.serverMode == DefaultValues.SERVER_MODE_THREADEDSELECTOR) {
            clientManager = new TAsyncClientManager();
            transport = new TNonblockingSocket(this.host, this.port);
            factory = new TmultiplexedFactory("syncTaskOperate");
        }
        RpcClientInfo<TaskManagerStub.AsyncClient> rpctype = new RpcClientInfo<TaskManagerStub.AsyncClient>(new TaskManagerStub.AsyncClient(factory, clientManager, (TNonblockingTransport)transport), (TTransport)transport, null);
        try {
            return new DefaultPooledObject(rpctype);
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}]getTTransport failed! TTransportException detail:{}", new Object[]{this.logId.get(), logFlag, e});
            throw e;
        }
    }

    public void destroyObject(PooledObject<RpcClientInfo<TaskManagerStub.AsyncClient>> pooledObject) throws Exception {
        String logFlag = this.getClassName() + ".destroyObject";
        if (pooledObject == null) {
            logger.warn("[lid:{}][{}]Object is empty!", (Object)this.logId.getAndDecrement(), (Object)logFlag);
            return;
        }
        RpcClientInfo rpctype = (RpcClientInfo)pooledObject.getObject();
        rpctype.getTTransport().close();
    }

    public boolean validateObject(PooledObject<RpcClientInfo<TaskManagerStub.AsyncClient>> pooledObject) {
        return true;
    }

    public void activateObject(PooledObject<RpcClientInfo<TaskManagerStub.AsyncClient>> p) throws Exception {
    }

    public void passivateObject(PooledObject<RpcClientInfo<TaskManagerStub.AsyncClient>> p) throws Exception {
    }

    public static abstract class AbstractAsyncCallback<T>
    implements AsyncMethodCallback<T> {
        private boolean isComplete = false;

        public boolean isCompleted() {
            return this.isComplete;
        }

        public abstract void onCompleted(T var1);

        public void onComplete(T response) {
            this.onCompleted(response);
            this.isComplete = true;
        }

        public void onError(Exception e) {
            logger.warn("async callback happened exception, detail:{}", (Throwable)e);
        }
    }
}

