/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.dataferry.thrift.rpcstubpool;

import com.xdja.dataferry.thrift.common.DefaultValues;
import com.xdja.dataferry.thrift.datatype.ResStr;
import com.xdja.dataferry.thrift.rpcstubpool.RpcClientInfo;
import com.xdja.dataferry.thrift.stub.TaskMonitorStub;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcStubTaskMonitorFactory
implements PooledObjectFactory<RpcClientInfo<TaskMonitorStub.Client>> {
    private final String host;
    private final int port;
    private final int serverMode;
    private final int timeout;
    public AtomicLong logId = new AtomicLong(-1L);
    private static Logger logger = LoggerFactory.getLogger(RpcStubTaskMonitorFactory.class);

    private String getClassName() {
        return "RpcStubTaskMonitorFactory";
    }

    public RpcStubTaskMonitorFactory(String host, int port, int mode, int timeout) {
        this.host = host;
        this.port = port;
        this.serverMode = mode;
        this.timeout = timeout;
    }

    public PooledObject<RpcClientInfo<TaskMonitorStub.Client>> makeObject() throws Exception {
        String logFlag = this.getClassName() + ".makeObject";
        this.logId.getAndDecrement();
        TSocket transport = null;
        TMultiplexedProtocol protocol = null;
        TSocket tsocket = null;
        if (this.serverMode == DefaultValues.SERVER_MODE_THREAD_POOL) {
            transport = tsocket = new TSocket(TConfiguration.DEFAULT, this.host, this.port, this.timeout, this.timeout);
            protocol = new TMultiplexedProtocol((TProtocol)new TBinaryProtocol((TTransport)transport), "taskMonitorOperate");
        } else if (this.serverMode == DefaultValues.SERVER_MODE_NONBLOCK || this.serverMode == DefaultValues.SERVER_MODE_THREADEDSELECTOR) {
            tsocket = new TSocket(TConfiguration.DEFAULT, this.host, this.port, this.timeout, this.timeout);
            transport = new TFramedTransport((TTransport)tsocket);
            protocol = new TMultiplexedProtocol((TProtocol)new TBinaryProtocol((TTransport)transport), "taskMonitorOperate");
        }
        RpcClientInfo<TaskMonitorStub.Client> rpctype = new RpcClientInfo<TaskMonitorStub.Client>(new TaskMonitorStub.Client((TProtocol)protocol), (TTransport)transport, tsocket);
        try {
            rpctype.getTTransport().open();
            return new DefaultPooledObject(rpctype);
        }
        catch (TTransportException e) {
            logger.warn("[lid:{}][{}]getTTransport failed! TTransportException detail:{}", new Object[]{this.logId.get(), logFlag, e});
            throw e;
        }
    }

    public void destroyObject(PooledObject<RpcClientInfo<TaskMonitorStub.Client>> pooledObject) throws Exception {
        String logFlag = this.getClassName() + ".destroyObject";
        if (pooledObject == null) {
            logger.warn("[lid:{}][{}]Object is empty!", (Object)this.logId.getAndDecrement(), (Object)logFlag);
            return;
        }
        RpcClientInfo rpctype = (RpcClientInfo)pooledObject.getObject();
        rpctype.getTTransport().close();
    }

    public boolean validateObject(PooledObject<RpcClientInfo<TaskMonitorStub.Client>> pooledObject) {
        String logFlag = this.getClassName() + ".validateObject";
        this.logId.getAndDecrement();
        if (pooledObject == null) {
            logger.warn("[lid:{}][{}]Object is empty!", (Object)this.logId.get(), (Object)logFlag);
            return false;
        }
        try {
            RpcClientInfo rpctype = (RpcClientInfo)pooledObject.getObject();
            if (!this.checkSocket(rpctype.getTSocket().getSocket())) {
                logger.warn("[lid:{}][{}] checkSocket fail!", (Object)this.logId.get(), (Object)logFlag);
                return false;
            }
            ResStr resStr = ((TaskMonitorStub.Client)rpctype.getClient()).echo(this.logId.get(), logFlag, "OK", null);
            if (resStr.res != 200) {
                logger.warn("[lid:{}][{}] err result!", (Object)this.logId.get(), (Object)logFlag);
                return false;
            }
            return resStr.value.equals(DefaultValues.resOk);
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}]validateObject fail! Exception detail:{}", new Object[]{this.logId.get(), logFlag, e});
            return false;
        }
    }

    public void activateObject(PooledObject<RpcClientInfo<TaskMonitorStub.Client>> pooledObject) throws Exception {
    }

    public void passivateObject(PooledObject<RpcClientInfo<TaskMonitorStub.Client>> pooledObject) throws Exception {
    }

    public boolean checkSocket(Socket socket) {
        return socket != null && socket.isBound() && !socket.isClosed() && socket.isConnected() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }
}

