/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.dataferry.thrift.start;

import com.xdja.dataferry.thrift.datatype.ResStr;
import com.xdja.dataferry.thrift.rpcstubpool.RpcClientInfo;
import com.xdja.dataferry.thrift.rpcstubpool.RpcStubPool;
import com.xdja.dataferry.thrift.rpcstubpool.RpcStubPoolConfig;
import com.xdja.dataferry.thrift.rpcstubpool.RpcStubSyncObjectFactory;
import com.xdja.dataferry.thrift.rpcstubpool.RpcStubSyncStrategyFactory;
import com.xdja.dataferry.thrift.rpcstubpool.RpcStubTaskManagerAsyncFactory;
import com.xdja.dataferry.thrift.rpcstubpool.RpcStubTaskManagerFactory;
import com.xdja.dataferry.thrift.rpcstubpool.RpcStubTaskMonitorFactory;
import com.xdja.dataferry.thrift.stub.SyncObjectStub;
import com.xdja.dataferry.thrift.stub.SyncStrategyStub;
import com.xdja.dataferry.thrift.stub.TaskManagerStub;
import com.xdja.dataferry.thrift.stub.TaskMonitorStub;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFerryClient {
    private static Logger logger = LoggerFactory.getLogger(DataFerryClient.class);
    private RpcStubSyncObjectFactory rpcSyncObjectFactory = null;
    private RpcStubSyncStrategyFactory rpcSyncStrategyFactory = null;
    private RpcStubTaskManagerFactory rpcTaskManagerFactory = null;
    private RpcStubTaskManagerAsyncFactory rpcTaskManagerAsyncFactory = null;
    private RpcStubTaskMonitorFactory rpcTaskMonitorFactory = null;
    private RpcStubPool<RpcClientInfo<SyncObjectStub.Client>> rpcSyncObjectStubPool = null;
    private RpcStubPool<RpcClientInfo<SyncStrategyStub.Client>> rpcSyncStrategyStubPool = null;
    private RpcStubPool<RpcClientInfo<TaskManagerStub.Client>> rpcTaskManagerStubPool = null;
    private RpcStubPool<RpcClientInfo<TaskManagerStub.AsyncClient>> rpcTaskManagerStubAsyncPool = null;
    private RpcStubPool<RpcClientInfo<TaskMonitorStub.Client>> rpcTaskMonitorStubPool = null;
    private RpcStubPoolConfig config = new RpcStubPoolConfig();
    private int timeout = 30000;
    private int serverMode = 3;
    private String sHost = "";
    private int sPort = -1;
    public static AtomicLong logIndex = new AtomicLong(0L);

    public DataFerryClient(String serverHost, int serverPort) {
        this.sHost = serverHost;
        this.sPort = serverPort;
        this.config.setMaxTotal(500);
        this.config.setMaxIdle(500);
        this.config.setMaxWaitMillis(3000L);
        this.config.setTestWhileIdle(false);
        this.config.setMinEvictableIdleTimeMillis(3600000L);
        this.config.setTestOnBorrow(true);
        this.config.setTestOnReturn(false);
    }

    public DataFerryClient(String serverHost, int serverPort, int timeout) {
        this.sHost = serverHost;
        this.sPort = serverPort;
        this.timeout = timeout;
        this.config.setMaxTotal(500);
        this.config.setMaxIdle(500);
        this.config.setMaxWaitMillis(3000L);
        this.config.setTestWhileIdle(false);
        this.config.setMinEvictableIdleTimeMillis(3600000L);
        this.config.setTestOnBorrow(true);
        this.config.setTestOnReturn(false);
    }

    private String getClassName() {
        return "DataFerryClient";
    }

    public boolean init() {
        String logFlag = this.getClassName() + ".init";
        logger.info("[lid:{}][{}] serverHost:{} serverPort:{} serverMode:{}", new Object[]{logIndex.getAndDecrement(), logFlag, this.sHost, this.sPort, this.serverMode});
        this.rpcSyncObjectFactory = new RpcStubSyncObjectFactory(this.sHost, this.sPort, this.serverMode, this.timeout);
        this.rpcSyncStrategyFactory = new RpcStubSyncStrategyFactory(this.sHost, this.sPort, this.serverMode, this.timeout);
        this.rpcTaskManagerFactory = new RpcStubTaskManagerFactory(this.sHost, this.sPort, this.serverMode, this.timeout);
        this.rpcTaskManagerAsyncFactory = new RpcStubTaskManagerAsyncFactory(this.sHost, this.sPort, this.serverMode);
        this.rpcTaskMonitorFactory = new RpcStubTaskMonitorFactory(this.sHost, this.sPort, this.serverMode, this.timeout);
        this.rpcSyncObjectStubPool = new RpcStubPool();
        this.rpcSyncStrategyStubPool = new RpcStubPool();
        this.rpcTaskManagerStubPool = new RpcStubPool();
        this.rpcTaskManagerStubAsyncPool = new RpcStubPool();
        this.rpcTaskMonitorStubPool = new RpcStubPool();
        if (!this.rpcSyncObjectStubPool.init(logIndex.get(), this.config, this.rpcSyncObjectFactory)) {
            logger.warn("[lid:{}][{}] sync object rpcpool init failed!", (Object)logIndex, (Object)logFlag);
            return false;
        }
        if (!this.rpcSyncStrategyStubPool.init(logIndex.get(), this.config, this.rpcSyncStrategyFactory)) {
            logger.warn("[lid:{}][{}] sync strategy rpcpool init failed!", (Object)logIndex, (Object)logFlag);
            return false;
        }
        if (!this.rpcTaskManagerStubPool.init(logIndex.get(), this.config, this.rpcTaskManagerFactory)) {
            logger.warn("[lid:{}][{}] task manager rpcpool init failed!", (Object)logIndex, (Object)logFlag);
            return false;
        }
        if (!this.rpcTaskManagerStubAsyncPool.init(logIndex.get(), this.config, this.rpcTaskManagerAsyncFactory)) {
            logger.warn("[lid:{}][{}] task manager async rpc pool init failed!", (Object)logIndex, (Object)logFlag);
            return false;
        }
        if (!this.rpcTaskMonitorStubPool.init(logIndex.get(), this.config, this.rpcTaskMonitorFactory)) {
            logger.warn("[lid:{}][{}] task monitor async rpc pool init failed!", (Object)logIndex, (Object)logFlag);
            return false;
        }
        return true;
    }

    public RpcClientInfo<SyncObjectStub.Client> getSyncObjectServiceClient(long logIndex) {
        String logFlag = this.getClassName() + ".getSyncObjectServiceClient";
        RpcClientInfo<SyncObjectStub.Client> rpcconnect = null;
        try {
            rpcconnect = this.rpcSyncObjectStubPool.getResource(logIndex);
            return rpcconnect;
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, rpcconnect);
            throw e;
        }
    }

    public RpcClientInfo<SyncStrategyStub.Client> getSyncStrategyServiceClient(long logIndex) {
        String logFlag = this.getClassName() + ".getSyncStrategyServiceClient";
        RpcClientInfo<SyncStrategyStub.Client> rpcconnect = null;
        try {
            rpcconnect = this.rpcSyncStrategyStubPool.getResource(logIndex);
            return rpcconnect;
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, rpcconnect);
            throw e;
        }
    }

    public RpcClientInfo<TaskManagerStub.Client> getTaskManagerServiceClient(long logIndex) {
        String logFlag = this.getClassName() + ".getTaskManagerServiceClient";
        RpcClientInfo<TaskManagerStub.Client> rpcconnect = null;
        try {
            rpcconnect = this.rpcTaskManagerStubPool.getResource(logIndex);
            return rpcconnect;
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, rpcconnect);
            throw e;
        }
    }

    public RpcClientInfo<TaskManagerStub.AsyncClient> getTaskManagerServiceAsyncClient(long logIndex) {
        String logFlag = this.getClassName() + ".getTaskManagerServiceAsyncClient";
        RpcClientInfo<TaskManagerStub.AsyncClient> rpcconnect = null;
        try {
            rpcconnect = this.rpcTaskManagerStubAsyncPool.getResource(logIndex);
            return rpcconnect;
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubAsyncPool.returnBrokenResource(logIndex, rpcconnect);
            throw e;
        }
    }

    public RpcClientInfo<TaskMonitorStub.Client> getTaskMonitorServiceClient(long logIndex) {
        String logFlag = this.getClassName() + ".getTaskMonitorServiceClient";
        RpcClientInfo<TaskMonitorStub.Client> rpcconnect = null;
        try {
            rpcconnect = this.rpcTaskMonitorStubPool.getResource(logIndex);
            return rpcconnect;
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskMonitorStubPool.returnBrokenResource(logIndex, rpcconnect);
            throw e;
        }
    }

    public void shutDown() {
        String logFlag = this.getClassName() + ".shutDown";
        if (this.rpcSyncObjectStubPool == null) {
            return;
        }
        if (this.rpcSyncStrategyStubPool == null) {
            return;
        }
        if (this.rpcTaskManagerStubPool == null) {
            return;
        }
        if (this.rpcTaskManagerStubAsyncPool == null) {
            return;
        }
        if (this.rpcTaskMonitorStubPool == null) {
            return;
        }
        try {
            this.rpcSyncObjectStubPool.destroy(logIndex.getAndDecrement());
            this.rpcSyncObjectStubPool = null;
            this.rpcSyncStrategyStubPool.destroy(logIndex.getAndDecrement());
            this.rpcSyncStrategyStubPool = null;
            this.rpcTaskManagerStubPool.destroy(logIndex.getAndDecrement());
            this.rpcTaskManagerStubPool = null;
            this.rpcTaskManagerStubAsyncPool.destroy(logIndex.getAndDecrement());
            this.rpcTaskManagerStubAsyncPool = null;
            this.rpcTaskMonitorStubPool.destroy(logIndex.getAndDecrement());
            this.rpcTaskMonitorStubPool = null;
        }
        catch (Exception ex) {
            logger.error("[lid:{}][{}] exception happened while shutting down rpcstubpool...", (Object)logIndex.get(), (Object)logFlag);
        }
    }

    public ResStr echo(long logIndex, String caller, String srcStr) {
        String logFlag = this.getClassName() + ".echo";
        logger.debug("[lid:{}][{}] srcStr:{}", new Object[]{logIndex, logFlag, srcStr});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().echo(logIndex, caller, srcStr, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr addDbSyncObj(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".addDbSyncObj";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().addDbSyncObj(logIndex, caller, strJson, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getDictData(long logIndex, String caller, String code) {
        String logFlag = this.getClassName() + ".getDictData";
        logger.debug("[lid:{}][{}] code:{}", new Object[]{logIndex, logFlag, code});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getDictData(logIndex, caller, code, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr checkDbConn(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".checkDbConn";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().checkDbConn(logIndex, caller, strJson, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr updateDbSyncObj(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".updateDbSyncObj";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().updateDbSyncObj(logIndex, caller, strJson, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getSyncObjList(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".getSyncObjList";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getSyncObjList(logIndex, caller, strJson, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getDbSyncObj(long logIndex, String caller, long id) {
        String logFlag = this.getClassName() + ".getDbSyncObj";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getDbSyncObj(logIndex, caller, id, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr delDbSyncObj(long logIndex, String caller, long id) {
        String logFlag = this.getClassName() + ".delDbSyncObj";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().delDbSyncObj(logIndex, caller, id, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr checkFileConn(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".checkFileConn";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().checkFileConn(logIndex, caller, strJson, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr addFileSyncObj(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".addFileSyncObj";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().addFileSyncObj(logIndex, caller, strJson, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr batchDelSyncObj(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".batchDelSyncObj";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().batchDelSyncObj(logIndex, caller, strJson, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr delFileSyncObj(long logIndex, String caller, long id) {
        String logFlag = this.getClassName() + ".delFileSyncObj";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().delFileSyncObj(logIndex, caller, id, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr updateFileSyncObj(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".updateFileSyncObj";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().updateFileSyncObj(logIndex, caller, strJson, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getFileSyncObj(long logIndex, String caller, long id) {
        String logFlag = this.getClassName() + ".getFileSyncObj";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getFileSyncObj(logIndex, caller, id, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getSyncObjName(long logIndex, String caller, int type) {
        String logFlag = this.getClassName() + ".getSyncObjName";
        logger.debug("[lid:{}][{}] type:{}", new Object[]{logIndex, logFlag, type});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getSyncObjName(logIndex, caller, type, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getSyncObjStatus(long logIndex, String caller, long id) {
        String logFlag = this.getClassName() + ".getSyncObjStatus";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getSyncObjStatus(logIndex, caller, id, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr checkSyncObjName(long logIndex, String caller, long id, String name) {
        String logFlag = this.getClassName() + ".checkSyncObjName";
        logger.debug("[lid:{}][{}] id:{}, name:{}", new Object[]{logIndex, logFlag, id, name});
        RpcClientInfo<SyncObjectStub.Client> ci = null;
        try {
            ci = this.getSyncObjectServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().checkSyncObjName(logIndex, caller, id, name, null);
            this.rpcSyncObjectStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncObjectStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr echoTest(long logIndex, String caller, String srcStr) {
        String logFlag = this.getClassName() + ".echoTest";
        logger.debug("[lid:{}][{}] srcStr:{}", new Object[]{logIndex, logFlag, srcStr});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().echoTest(logIndex, caller, srcStr, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getSyncPolicyList(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".getSyncPolicyList";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getSyncPolicyList(logIndex, caller, strJson, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getDbSyncPolicy(long logIndex, String caller, long id) {
        String logFlag = this.getClassName() + ".getDbSyncPolicy";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getDbSyncPolicy(logIndex, caller, id, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr addDbSyncPolicy(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".addDbSyncPolicy";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().addDbSyncPolicy(logIndex, caller, strJson, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr delDbSyncPolicy(long logIndex, String caller, long id) {
        String logFlag = this.getClassName() + ".delDbSyncPolicy";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().delDbSyncPolicy(logIndex, caller, id, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr updateDbSyncPolicy(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".updateDbSyncPolicy";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().updateDbSyncPolicy(logIndex, caller, strJson, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr ddlAction(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".ddlAction";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().ddlAction(logIndex, caller, strJson, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr addFileSyncPolicy(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".addFileSyncPolicy";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().addFileSyncPolicy(logIndex, caller, strJson, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr batchDelPolicy(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".batchDelPolicy";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().batchDelPolicy(logIndex, caller, strJson, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr delFileSyncPolicy(long logIndex, String caller, long id) {
        String logFlag = this.getClassName() + ".delFileSyncPolicy";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().delFileSyncPolicy(logIndex, caller, id, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr updateFileSyncPolicy(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".updateFileSyncPolicy";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().updateFileSyncPolicy(logIndex, caller, strJson, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getFileSyncPolicy(long logIndex, String caller, long id) {
        String logFlag = this.getClassName() + ".getFileSyncPolicy";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getFileSyncPolicy(logIndex, caller, id, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getDbTree(long logIndex, String caller, long id, String ext) {
        String logFlag = this.getClassName() + ".getDbTree";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getDbTree(logIndex, caller, id, ext);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getContentByPath(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".getContentByPath";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getContentByPath(logIndex, caller, strJson, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr checkRepeatPolicyName(long logIndex, String caller, String name, String ext) {
        String logFlag = this.getClassName() + ".checkRepeatPolicyName";
        logger.debug("[lid:{}][{}] name:{}", new Object[]{logIndex, logFlag, name});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().checkRepeatPolicyName(logIndex, caller, name, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr checkDbPolicyStatus(long logIndex, String caller, long id, String ext) {
        String logFlag = this.getClassName() + ".checkDbPolicyStatus";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().checkDbPolicyStatus(logIndex, caller, id, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr queryUnusedPolicyList(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".queryUnusedPolicyList";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().queryUnusedPolicyList(logIndex, caller, strJson, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getTransfersq(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".getTransfersq";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getTransfersq(logIndex, caller, strJson, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr addTask(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".addTask";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().addTask(logIndex, caller, strJson, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr delTask(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".delTask";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().delTask(logIndex, caller, strJson, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr updateTask(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".updateTask";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().updateTask(logIndex, caller, strJson, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getTask(long logIndex, String caller, long id, String ext) {
        String logFlag = this.getClassName() + ".getTask";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getTask(logIndex, caller, id, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getTaskList(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".getTaskList";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getTaskList(logIndex, caller, strJson, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr checkTaskLog(long logIndex, String caller, long id, String ext) {
        String logFlag = this.getClassName() + ".checkTaskLog";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().checkTaskLog(logIndex, caller, id, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getTaskLog(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".getTaskLog";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getTaskLog(logIndex, caller, strJson, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr updateTaskStatus(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".updateTaskStatus";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().updateTaskStatus(logIndex, caller, strJson, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getTaskStatus(long logIndex, String caller, long id, String ext) {
        String logFlag = this.getClassName() + ".getTaskStatus";
        logger.debug("[lid:{}][{}] id:{}", new Object[]{logIndex, logFlag, id});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getTaskStatus(logIndex, caller, id, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr checkTaskName(long logIndex, String caller, long id, String name, String ext) {
        String logFlag = this.getClassName() + ".checkTaskName";
        logger.debug("[lid:{}][{}] id:{} name:{}", new Object[]{logIndex, logFlag, id, name});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().checkTaskName(logIndex, caller, id, name, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr notifyStartFilexJob(long logIndex, String caller, long taskId, long policyId, String ext) throws Exception {
        String logFlag = this.getClassName() + ".notifyStartFilexJob";
        logger.debug("[lid:{}][{}] taskId:{} policyId:{}", new Object[]{logIndex, logFlag, taskId, policyId});
        RpcClientInfo<TaskManagerStub.Client> ci = this.getTaskManagerServiceClient(logIndex);
        if (ci == null) {
            logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
            return null;
        }
        ResStr res = ci.getClient().notifyStartFilexJob(logIndex, caller, taskId, policyId, null);
        this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
        return res;
    }

    public ResStr notifyRetryFilexJob(long logIndex, String caller, long taskId, long policyId, String ext) throws Exception {
        String logFlag = this.getClassName() + ".notifyRetryFilexJob";
        logger.debug("[lid:{}][{}] taskId:{} policyId:{}", new Object[]{logIndex, logFlag, taskId, policyId});
        RpcClientInfo<TaskManagerStub.Client> ci = this.getTaskManagerServiceClient(logIndex);
        if (ci == null) {
            logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
            return null;
        }
        ResStr res = ci.getClient().notifyRetryFilexJob(logIndex, caller, taskId, policyId, null);
        this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
        return res;
    }

    public void asyncNotifyStartFilexJob(long logIndex, String caller, long taskId, long policyId, String ext, RpcStubTaskManagerAsyncFactory.AbstractAsyncCallback callback) throws Exception {
        String logFlag = this.getClassName() + ".asyncNotifyStartFilexJob";
        logger.debug("[lid:{}][{}] taskId:{} policyId:{}", new Object[]{logIndex, logFlag, taskId, policyId});
        RpcClientInfo<TaskManagerStub.AsyncClient> ci = this.getTaskManagerServiceAsyncClient(logIndex);
        if (ci == null) {
            logger.warn("[lid:{}][{}] cannot get dataferry AsyncClient", (Object)logIndex, (Object)logFlag);
            return;
        }
        ci.getClient().notifyStartFilexJob(logIndex, caller, taskId, policyId, null, callback);
        try {
            while (!callback.isCompleted()) {
                Thread.sleep(30L);
            }
        }
        catch (InterruptedException e) {
            logger.warn("[lid:{}][{}] thread interrupted exception", (Object)logIndex, (Object)logFlag);
        }
        this.rpcTaskManagerStubAsyncPool.returnResource(logIndex, ci);
    }

    public ResStr notifyStopFilexJob(long logIndex, String caller, long taskId, long policyId, String ext) throws Exception {
        String logFlag = this.getClassName() + ".notifyStopFilexJob";
        logger.debug("[lid:{}][{}] taskId:{} policyId:{}", new Object[]{logIndex, logFlag, taskId, policyId});
        RpcClientInfo<TaskManagerStub.Client> ci = this.getTaskManagerServiceClient(logIndex);
        if (ci == null) {
            logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
            return null;
        }
        ResStr res = ci.getClient().notifyStopFilexJob(logIndex, caller, taskId, policyId, null);
        this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
        return res;
    }

    public void asyncNotifyStopFilexJob(long logIndex, String caller, long taskId, long policyId, String ext, RpcStubTaskManagerAsyncFactory.AbstractAsyncCallback callback) throws Exception {
        String logFlag = this.getClassName() + ".asyncNotifyStopFilexJob";
        logger.debug("[lid:{}][{}] taskId:{}, policyId:{}", new Object[]{logIndex, logFlag, taskId, policyId});
        RpcClientInfo<TaskManagerStub.AsyncClient> ci = this.getTaskManagerServiceAsyncClient(logIndex);
        if (ci == null) {
            logger.warn("[lid:{}][{}] cannot get dataferry AsyncClient", (Object)logIndex, (Object)logFlag);
            return;
        }
        ci.getClient().notifyStopFilexJob(logIndex, caller, taskId, policyId, null, callback);
        try {
            while (!callback.isCompleted()) {
                Thread.sleep(30L);
            }
        }
        catch (InterruptedException e) {
            logger.warn("[lid:{}][{}] thread interrupted exception", (Object)logIndex, (Object)logFlag);
        }
        this.rpcTaskManagerStubAsyncPool.returnResource(logIndex, ci);
    }

    public ResStr startTask(long logIndex, String caller, long taskId, long policyId) {
        String logFlag = this.getClassName() + ".startTask";
        logger.debug("[lid:{}][{}] taskId:{} policyId:{}", new Object[]{logIndex, logFlag, taskId, policyId});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().startTask(logIndex, caller, taskId, policyId, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            e.printStackTrace();
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return null;
        }
    }

    public ResStr retryTask(long logIndex, String caller, long taskId, long policyId) {
        String logFlag = this.getClassName() + ".retryTask";
        logger.debug("[lid:{}][{}] taskId:{} policyId:{}", new Object[]{logIndex, logFlag, taskId, policyId});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().retryTask(logIndex, caller, taskId, policyId, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            e.printStackTrace();
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return null;
        }
    }

    public ResStr stopTask(long logIndex, String caller, long taskId, long policyId) {
        String logFlag = this.getClassName() + ".stopTask";
        logger.debug("[lid:{}][{}] policyId:{}", new Object[]{logIndex, logFlag, policyId});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().stopTask(logIndex, caller, taskId, policyId, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            e.printStackTrace();
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return null;
        }
    }

    public ResStr reStartTask(long logIndex, String caller, long taskId, long policyId) {
        String logFlag = this.getClassName() + ".reStartTask";
        logger.debug("[lid:{}][{}] taskId:{} policyId:{}", new Object[]{logIndex, logFlag, taskId, policyId});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().reStartTask(logIndex, caller, taskId, policyId, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            e.printStackTrace();
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return null;
        }
    }

    public ResStr cleanDstTables(long logIndex, String caller, String driver, String url, String user, String pwd, Set<String> dstTableSet) {
        String logFlag = this.getClassName() + ".cleanDstTables";
        logger.debug("[lid:{}][{}]", (Object)logIndex, (Object)logFlag);
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().cleanDstTables(logIndex, caller, driver, url, user, pwd, dstTableSet, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            e.printStackTrace();
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return null;
        }
    }

    public ResStr cleanRemoteOldcfg(long logIndex, String caller, long policyId, int type) {
        String logFlag = this.getClassName() + ".cleanRemoteOldcfg";
        logger.debug("[lid:{}][{}] policyId:{}", new Object[]{logIndex, logFlag, policyId});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().cleanRemoteOldcfg(logIndex, caller, policyId, type, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            e.printStackTrace();
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return null;
        }
    }

    public ResStr restartService(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".restartService";
        logger.debug("[lid:{}][{}] safeFlag:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().restartService(logIndex, caller, strJson, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr notifyStartDataxJob(long logIndex, String caller, long taskId, long policyId) throws Exception {
        String logFlag = this.getClassName() + ".notifyStartDataxJob";
        logger.debug("[lid:{}][{}] taskId:{} policyId:{}", new Object[]{logIndex, logFlag, taskId, policyId});
        RpcClientInfo<TaskManagerStub.Client> ci = this.getTaskManagerServiceClient(logIndex);
        if (ci == null) {
            logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
            return null;
        }
        ResStr res = ci.getClient().notifyStartDataxJob(logIndex, caller, taskId, policyId, null);
        this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
        return res;
    }

    public ResStr notifyRetryDataxJob(long logIndex, String caller, long taskId, long policyId) throws Exception {
        String logFlag = this.getClassName() + ".notifyRetryDataxJob";
        logger.debug("[lid:{}][{}] taskId:{} policyId:{}", new Object[]{logIndex, logFlag, taskId, policyId});
        RpcClientInfo<TaskManagerStub.Client> ci = this.getTaskManagerServiceClient(logIndex);
        if (ci == null) {
            logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
            return null;
        }
        ResStr res = ci.getClient().notifyRetryDataxJob(logIndex, caller, taskId, policyId, null);
        this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
        return res;
    }

    public void asyncNotifyStartDataxJob(long logIndex, String caller, long taskId, long policyId, RpcStubTaskManagerAsyncFactory.AbstractAsyncCallback callback) throws Exception {
        String logFlag = this.getClassName() + ".asyncNotifyStartDataxJob";
        logger.debug("[lid:{}][{}] taskId:{} policyId:{}", new Object[]{logIndex, logFlag, taskId, policyId});
        RpcClientInfo<TaskManagerStub.AsyncClient> ci = this.getTaskManagerServiceAsyncClient(logIndex);
        if (ci == null) {
            logger.warn("[lid:{}][{}] cannot get dataferry AsyncClient", (Object)logIndex, (Object)logFlag);
            return;
        }
        ci.getClient().notifyStartDataxJob(logIndex, caller, taskId, policyId, null, callback);
        try {
            while (!callback.isCompleted()) {
                Thread.sleep(30L);
            }
        }
        catch (InterruptedException e) {
            logger.warn("[lid:{}][{}] thread interrupted exception", (Object)logIndex, (Object)logFlag);
        }
        this.rpcTaskManagerStubAsyncPool.returnResource(logIndex, ci);
    }

    public ResStr createDbAndTable(long logIndex, String caller, long policyId, String fontDbName, String dbip, List<String> tableList) {
        String logFlag = this.getClassName() + ".createDbAndTable";
        logger.debug("[lid:{}][{}] policyId:{}", new Object[]{logIndex, logFlag, policyId});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().createDbAndTable(logIndex, caller, policyId, fontDbName, dbip, tableList, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            e.printStackTrace();
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr dropTempDbOrDir(long logIndex, String caller, long id, int type) {
        String logFlag = this.getClassName() + ".dropTempDbOrDir";
        logger.debug("[lid:{}][{}] policyId:{} type:{}", new Object[]{logIndex, logFlag, id, type});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().dropTempDbOrDir(logIndex, caller, id, type, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            e.printStackTrace();
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getSrcTableConstructSql(long logIndex, String caller, int srcDbType, String srcDriver, String srcUrl, String srcUser, String srcPwd, String tableName) {
        String logFlag = this.getClassName() + ".getSrcTableConstructSql";
        logger.debug("[lid:{}][{}] srcDbType:{} type:{}", new Object[]{logIndex, logFlag, srcDbType, srcDriver});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getSrcTableConstructSql(logIndex, caller, srcDbType, srcDriver, srcUrl, srcUser, srcPwd, tableName, null);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            e.printStackTrace();
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr notifyStopDataxJob(long logIndex, String caller, long taskId) throws Exception {
        String logFlag = this.getClassName() + ".notifyStopDataxJob";
        logger.debug("[lid:{}][{}]", (Object)logIndex, (Object)logFlag);
        RpcClientInfo<TaskManagerStub.Client> ci = this.getTaskManagerServiceClient(logIndex);
        if (ci == null) {
            logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
            return null;
        }
        ResStr res = ci.getClient().notifyStopDataxJob(logIndex, caller, taskId, null);
        this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
        return res;
    }

    public void asyncNotifyStopDataxJob(long logIndex, String caller, long taskId, RpcStubTaskManagerAsyncFactory.AbstractAsyncCallback callback) throws Exception {
        String logFlag = this.getClassName() + ".asyncNotifyStopDataxJob";
        logger.debug("[lid:{}][{}] taskId:{}", new Object[]{logIndex, logFlag, taskId});
        RpcClientInfo<TaskManagerStub.AsyncClient> ci = this.getTaskManagerServiceAsyncClient(logIndex);
        if (ci == null) {
            logger.warn("[lid:{}][{}] cannot get dataferry AsyncClient", (Object)logIndex, (Object)logFlag);
            return;
        }
        ci.getClient().notifyStopDataxJob(logIndex, caller, taskId, null, callback);
        try {
            while (!callback.isCompleted()) {
                Thread.sleep(30L);
            }
        }
        catch (InterruptedException e) {
            logger.warn("[lid:{}][{}] thread interrupted exception", (Object)logIndex, (Object)logFlag);
        }
        this.rpcTaskManagerStubAsyncPool.returnResource(logIndex, ci);
    }

    public ResStr logAudit(long logIndex, String caller, long taskId, int taskType, String result, String ext) {
        String logFlag = this.getClassName() + ".logAudit";
        logger.debug("[lid:{}][{}] taskId:{} taskType:{} result:{}", new Object[]{logIndex, logFlag, taskId, taskType, result});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().logAudit(logIndex, caller, taskId, taskType, result, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getTaskProcess(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".getTaskProcess";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getTaskProcess(logIndex, caller, strJson, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr updateTaskMonitor(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".updateTaskMonitor";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskMonitorStub.Client> ci = null;
        try {
            ci = this.getTaskMonitorServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().updateTaskMonitor(logIndex, caller, strJson, null);
            this.rpcTaskMonitorStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskMonitorStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getTaskMonitor(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".getTaskMonitor";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskMonitorStub.Client> ci = null;
        try {
            ci = this.getTaskMonitorServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getTaskMonitor(logIndex, caller, strJson, null);
            this.rpcTaskMonitorStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskMonitorStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getFileExtDict(long logIndex, String caller, String condition, String ext) {
        String logFlag = this.getClassName() + ".getFileExtDict";
        logger.debug("[lid:{}][{}] condition:{}", new Object[]{logIndex, logFlag, condition});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getFileExtDict(logIndex, caller, condition, ext);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getTransformFunction(long logIndex, String caller, String ext) {
        String logFlag = this.getClassName() + ".getTransformFunction";
        logger.debug("[lid:{}][{}] caller:{}", new Object[]{logIndex, logFlag, caller});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getTransformFunction(logIndex, caller, ext);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getDictionaryListByRemote(long logIndex, String caller, String strJson) {
        String logFlag = this.getClassName() + ".getDictionaryListByRemote";
        logger.debug("[lid:{}][{}] caller:{}", new Object[]{logIndex, logFlag, caller});
        RpcClientInfo<SyncStrategyStub.Client> ci = null;
        try {
            ci = this.getSyncStrategyServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getDictionaryListByRemote(logIndex, caller, strJson);
            this.rpcSyncStrategyStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcSyncStrategyStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }

    public ResStr getSpace(long logIndex, String caller, String strJson, String ext) {
        String logFlag = this.getClassName() + ".getSpace";
        logger.debug("[lid:{}][{}] strJson:{}", new Object[]{logIndex, logFlag, strJson});
        RpcClientInfo<TaskManagerStub.Client> ci = null;
        try {
            ci = this.getTaskManagerServiceClient(logIndex);
            if (ci == null) {
                logger.warn("[lid:{}][{}] cannot get dataferry Client", (Object)logIndex, (Object)logFlag);
                return null;
            }
            ResStr res = ci.getClient().getSpace(logIndex, caller, strJson, null);
            this.rpcTaskManagerStubPool.returnResource(logIndex, ci);
            return res;
        }
        catch (TException e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, e});
            this.rpcTaskManagerStubPool.returnBrokenResource(logIndex, ci);
            return null;
        }
    }
}

