/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.binderdeposit;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import com.xdja.binderdeposit.IDeposit;
import com.xdja.binderdeposit.utils.BundleUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

class DepositClientBinder
extends IDeposit.Stub {
    private static final String TAG = "DepositClientBinder";
    private Context context;
    private WeakReference<Object> obj;
    private String objName;
    private HashMap<String, Method> methodMap = null;
    private Class interfaceClass;
    private WeakReference<IDeposit> weakRefDeposit;
    private static HashMap<String, DepositClientBinder> argObjBinderMap = new HashMap();
    private static boolean startFlag = false;
    private static final int SLEEP_TIME = 10000;

    private DepositClientBinder(Context context, Object obj, Class interfaceClass, IDeposit deposit) {
        this.interfaceClass = interfaceClass;
        this.weakRefDeposit = new WeakReference<IDeposit>(deposit);
        if (context == null) {
            throw new NullPointerException("Param is null!");
        }
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        this.obj = new WeakReference<Object>(obj);
        this.objName = obj.toString();
    }

    public static DepositClientBinder create(Context context, Object obj, Class interfaceClass, IDeposit deposit) {
        return new DepositClientBinder(context, obj, interfaceClass, deposit);
    }

    @Override
    public Bundle call(Bundle bundle) throws RemoteException {
        bundle.setClassLoader(this.interfaceClass.getClassLoader());
        if (!bundle.containsKey("methodName")) {
            return null;
        }
        String methodName = bundle.getString("methodName");
        Method method = this.getMethod(methodName);
        if (method == null) {
            return null;
        }
        ArrayList paramList = bundle.getStringArrayList("paramList");
        Object[] paramObjs = null;
        if (paramList != null && paramList.size() != 0) {
            paramObjs = new Object[paramList.size()];
            int i = 0;
            for (String key : paramList) {
                paramObjs[i++] = bundle.get(key);
            }
        }
        try {
            Object methodResult = paramObjs == null ? method.invoke(this.getObj(), new Object[0]) : method.invoke(this.getObj(), paramObjs);
            Bundle result = new Bundle();
            result.putInt("ret", 0);
            if (methodResult == null) {
                result.putString("result_null", null);
            } else {
                BundleUtils.putIntoBundle(result, "result", methodResult);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Method getMethod(String methodName) {
        HashMap<String, Method> methods = this.getMethods();
        return methods.get(methodName);
    }

    private HashMap<String, Method> getMethods() {
        Method[] methods;
        if (this.methodMap != null) {
            return this.methodMap;
        }
        this.methodMap = new HashMap();
        for (Method method : methods = this.interfaceClass.getMethods()) {
            this.methodMap.put(method.getName(), method);
        }
        return this.methodMap;
    }

    private Object getObj() {
        if (this.obj != null) {
            Object o = this.obj.get();
            if (o == null) {
                Log.e((String)"test", (String)("getObj o == null " + this.objName));
                argObjBinderMap.remove(this.objName);
                this.removeRemoteProxy();
            }
            return o;
        }
        return null;
    }

    private void removeRemoteProxy() {
        if (this.weakRefDeposit != null) {
            Bundle bundle = new Bundle();
            bundle.putString("methodName", "#_remove_remote_proxy_#");
            bundle.putBinder("Binder", (IBinder)this);
            try {
                IDeposit deposit = (IDeposit)this.weakRefDeposit.get();
                if (deposit != null) {
                    deposit.call(bundle);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static DepositClientBinder getDepositClientBinder(Context context, Object object, Class cls, IDeposit deposit) {
        DepositClientBinder.startThreadForClear();
        DepositClientBinder depositClientBinder = argObjBinderMap.get(object.toString());
        if (depositClientBinder == null) {
            depositClientBinder = DepositClientBinder.create(context, object, cls, deposit);
            argObjBinderMap.put(object.toString(), depositClientBinder);
        }
        return depositClientBinder;
    }

    private static void startThreadForClear() {
        if (startFlag) {
            return;
        }
        startFlag = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                block0: while (true) {
                    SystemClock.sleep((long)10000L);
                    Set keySet = argObjBinderMap.keySet();
                    Iterator iterator = keySet.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block0;
                        String key = (String)iterator.next();
                        DepositClientBinder binder = (DepositClientBinder)argObjBinderMap.get(key);
                        binder.getObj();
                    }
                    break;
                }
            }
        }).start();
    }
}

