/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.binderdeposit;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.binderdeposit.DepositClientBinder;
import com.xdja.binderdeposit.IDeposit;
import com.xdja.binderdeposit.ParamDeposit;
import com.xdja.binderdeposit.ParamKeyworlds;
import com.xdja.binderdeposit.ServiceName;
import com.xdja.binderdeposit.utils.BundleUtils;
import com.xdja.binderdeposit.utils.ForJudge;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;

public class DepositProxy
implements InvocationHandler {
    public static final String TAG = "DepositPorxy";
    private static HashMap<String, IDeposit> depositMap = new HashMap();
    private final Context context;
    private final String pkgName;
    private final Class<?> clz;
    private final String serviceName;
    private IDeposit depositBinder;

    private DepositProxy(Context context, String pkgName, Class<?> clz, String serviceName) {
        this.context = context;
        this.pkgName = TextUtils.isEmpty((CharSequence)pkgName) ? context.getPackageName() : pkgName;
        this.clz = clz;
        this.serviceName = serviceName;
    }

    private <T> T genProxy() {
        if (this.context == null || this.clz == null) {
            throw new NullPointerException("Param is null!");
        }
        if (!this.clz.isInterface()) {
            return null;
        }
        ClassLoader classLoader = this.clz.getClassLoader();
        boolean flag = this.init();
        if (!flag) {
            return null;
        }
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{this.clz}, (InvocationHandler)this);
    }

    public boolean init() {
        this.depositBinder = this.getDepositBinder(this.clz, this.serviceName);
        return this.depositBinder != null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws RemoteException, InterruptedException {
        String name = method.getName();
        if (name.equals("toString")) {
            return this.toString();
        }
        if (name.equals("hashCode")) {
            return this.hashCode();
        }
        if (name.equals("getClass")) {
            return this.getClass();
        }
        if (name.equals("equals")) {
            return this.equals(args[0]);
        }
        if (name.equals("notify")) {
            this.notify();
            return null;
        }
        if (name.equals("notifyAll")) {
            this.notify();
            return null;
        }
        if (name.equals("wait")) {
            if (args == null) {
                this.wait();
            } else if (args.length == 1) {
                this.wait((Long)args[0]);
            } else {
                this.wait((Long)args[0], (Integer)args[1]);
            }
            return null;
        }
        Object[] objArgs = this.convertArgs(method, args);
        Bundle bundle = new Bundle();
        bundle.putString("methodName", method.getName());
        Class<?>[] parameterTypes = method.getParameterTypes();
        ArrayList<String> paramList = new ArrayList<String>();
        int i = 0;
        for (Class<?> clz : parameterTypes) {
            String key = clz.getName() + "#" + i;
            paramList.add(key);
            BundleUtils.putIntoBundle(bundle, key, objArgs[i]);
            ++i;
        }
        bundle.putStringArrayList("paramList", paramList);
        IDeposit depositBinder = this.getDepositBinder(this.clz, this.serviceName);
        if (depositBinder == null) {
            throw new RemoteException("Remote BinderService Death!");
        }
        Bundle result = depositBinder.call(bundle);
        result.setClassLoader(method.getReturnType().getClassLoader());
        if (result.getInt("ret") == 0) {
            if (result.containsKey("result_null")) {
                return null;
            }
            return result.get("result");
        }
        return null;
    }

    private IDeposit getDepositBinder(Class clz, String serviceName) {
        String key;
        IDeposit binder;
        ServiceName annotation;
        if (TextUtils.isEmpty((CharSequence)serviceName) && (annotation = clz.getAnnotation(ServiceName.class)) != null) {
            serviceName = annotation.value();
        }
        if (serviceName == null) {
            serviceName = "";
        }
        if ((binder = this.getDepositBinderFromCache(key = ParamKeyworlds.getKey(clz, serviceName))) != null) {
            return binder;
        }
        Uri uri = Uri.parse((String)("content://" + this.pkgName + ".BinderDepositProvider"));
        int ret = ForJudge.forJudge(this.context, this.pkgName, uri);
        if (ret != 0) {
            return null;
        }
        Bundle extras = new Bundle();
        extras.putString("interfaceClassName", clz.getName());
        extras.putString("serviceName", serviceName);
        ContentResolver resolver = this.context.getContentResolver();
        Bundle result = resolver.call(uri, "getDepositBinder", "", extras);
        if (result == null) {
            return null;
        }
        if (result.getInt("ret") != 0) {
            return null;
        }
        binder = IDeposit.Stub.asInterface(result.getBinder("Binder"));
        if (binder == null) {
            return binder;
        }
        this.cacheDepositBinder(key, binder);
        this.linkToDeath(binder.asBinder(), key);
        return binder;
    }

    private void linkToDeath(final IBinder binder, final String key) {
        try {
            binder.linkToDeath(new IBinder.DeathRecipient(){

                public void binderDied() {
                    Log.e((String)DepositProxy.TAG, (String)("linkToDeath binder = " + binder.toString()));
                    depositMap.remove(key);
                    DepositProxy.this.depositBinder = null;
                }
            }, 0);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private IDeposit getDepositBinderFromCache(String key) {
        IDeposit iDeposit = depositMap.get(key);
        return iDeposit;
    }

    private void cacheDepositBinder(String key, IDeposit deposit) {
        depositMap.put(key, deposit);
    }

    private Object[] convertArgs(Method method, Object[] args) {
        if (args == null) {
            return null;
        }
        Object[] result = new Object[args.length];
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        block0: for (int i = 0; i < parameterAnnotations.length; ++i) {
            result[i] = args[i];
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                String name;
                Annotation annotation = parameterAnnotations[i][j];
                if (annotation == null || (name = annotation.toString()).indexOf(ParamDeposit.class.getName()) <= 0 || args[j] == null) continue;
                Class<?> parameterType = method.getParameterTypes()[i];
                if (!parameterType.isInterface()) {
                    throw new IllegalArgumentException(method.getName() + " " + parameterType.getName() + "  is not interface!");
                }
                DepositClientBinder depositClientBinder = DepositClientBinder.getDepositClientBinder(this.context, args[i], method.getParameterTypes()[i], this.getDepositBinder(this.clz, this.serviceName));
                result[i] = depositClientBinder;
                continue block0;
            }
        }
        return result;
    }

    public static class Builder {
        private String pkgName;
        private String serviceName;
        private Context context;

        public Builder setPkgName(String pkgName) {
            this.pkgName = pkgName;
            return this;
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public <T> T create(Class<?> clz) {
            if (this.context == null || clz == null) {
                return null;
            }
            DepositProxy proxy = new DepositProxy(this.context, this.pkgName, clz, this.serviceName);
            return (T)proxy.genProxy();
        }
    }
}

