/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.service;

import com.xdja.drs.service.IfaceColumn;
import com.xdja.drs.service.IfaceRow;
import com.xdja.drs.service.IfaceTable;
import com.xdja.drs.util.DataOperateType;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class IDURequest {
    private String version = "20140501";
    private String userId;
    private int transactionType = 1;
    private ArrayList<IfaceTable> table = new ArrayList();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(int transactionType) {
        this.transactionType = transactionType;
    }

    public ArrayList<IfaceTable> getTable() {
        return this.table;
    }

    public void setTable(ArrayList<IfaceTable> table) {
        this.table = table;
    }

    public String toString() {
        Document doc = DocumentHelper.createDocument();
        doc.setXMLEncoding("UTF-8");
        Element root = doc.addElement("Root");
        root.addElement("Version").setText(this.version);
        root.addElement("TransactionType").setText(String.valueOf(this.transactionType));
        Element tabs = root.addElement("Tables");
        for (IfaceTable it : this.table) {
            Element tab = tabs.addElement("Table");
            tab.addElement("Name").setText(it.getName());
            tab.addElement("IsMain").setText(it.isMainTable() ? "1" : "0");
            for (IfaceRow ir : it.getRow()) {
                Element row = tab.addElement("Row");
                row.addElement("Operate").setText(String.valueOf((Object)ir.getType()));
                Element data = row.addElement("Data");
                if (ir.getColumn() != null) {
                    for (IfaceColumn ic : ir.getColumn()) {
                        if (ic.getName() == null || ic.getValue() == null) continue;
                        data.addElement(ic.getName()).setText(ic.getValue() == null ? "" : ic.getValue());
                    }
                }
                if (ir.getType() != DataOperateType.update && ir.getType() != DataOperateType.delete || ir.getSrcCondition() == null) continue;
                row.addElement("Condition").setText(ir.getSrcCondition());
            }
        }
        return doc.asXML();
    }
}

