/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.service;

import com.xdja.basecode.util.HelpFunction;
import com.xdja.basecode.xml.XmlHelper;
import com.xdja.drs.parser.ParseIDUDocument;
import com.xdja.drs.service.IDURequest;
import com.xdja.drs.service.IDUResult;
import com.xdja.drs.service.QueryRequest;
import com.xdja.drs.service.QueryResult;
import com.xdja.drs.service.UserUnitInfo;
import com.xdja.drs.service.impl.DataRequestImpl;
import com.xdja.drs.util.ServiceException;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.dom4j.Document;
import org.dom4j.Element;

@WebService(targetNamespace="http://wsrpc.hxd.xdja/", serviceName="wsrpcService")
public class OldWSrpc {
    private static DataRequestImpl dri = new DataRequestImpl();

    @WebMethod(operationName="query")
    public String query(@WebParam(name="UserId") String UserId, @WebParam(name="ReqType") String ReqType, @WebParam(name="SearchType") String SearchType, @WebParam(name="DbSource") String DbSource, @WebParam(name="FieldList") String FieldList, @WebParam(name="Condition") String Condition, @WebParam(name="Rno") String Rno, @WebParam(name="Rlen") String Rlen) {
        QueryRequest rp = new QueryRequest();
        rp.setLocalTable(ReqType);
        rp.setDsid(DbSource);
        rp.setLocalFields(FieldList);
        rp.setCondition(Condition);
        rp.setPageSize(HelpFunction.getInt((String)Rlen, (int)3));
        rp.setPageNumber(this.getPageNumber(HelpFunction.getInt((String)Rno, (int)1), rp.getPageSize()));
        QueryResult qr = dri.query(rp);
        if (qr.getErrMsg() == null) {
            return qr.toString();
        }
        return "-1 " + qr.getErrMsg();
    }

    @WebMethod(operationName="queryE")
    public String queryE(@WebParam(name="QRequest") String QRequest) {
        Document doc = XmlHelper.getDoc((String)QRequest);
        if (doc == null) {
            return "-1 \u9519\u8bef\u7684XML\u683c\u5f0f";
        }
        Element root = doc.getRootElement();
        QueryRequest rp = new QueryRequest();
        if (root.element("UserId") != null) {
            rp.setUserId(root.elementTextTrim("UserId"));
        }
        rp.setLocalTable(root.elementTextTrim("ReqTable"));
        rp.setDsid(root.elementTextTrim("Source"));
        rp.setLocalFields(root.elementTextTrim("FieldList"));
        rp.setCondition(root.elementTextTrim("Condition"));
        rp.setPageSize(HelpFunction.getInt((String)root.elementTextTrim("Rlen"), (int)3));
        rp.setPageNumber(this.getPageNumber(HelpFunction.getInt((String)root.elementTextTrim("Rno"), (int)1), rp.getPageSize()));
        UserUnitInfo uuinfo = new UserUnitInfo();
        uuinfo.setPoliceName(root.elementTextTrim("UserName"));
        uuinfo.setPoliceSfzh(root.elementTextTrim("UserIDCard"));
        uuinfo.setUnitCode(root.elementTextTrim("DeptNo"));
        rp.setUuInfo(uuinfo);
        QueryResult qr = dri.query(rp);
        if (qr.getErrMsg() == null) {
            return qr.toString();
        }
        return "-1 " + qr.getErrMsg();
    }

    @WebMethod(operationName="getdsbylocalobject")
    public String getdsbylocalobject(@WebParam(name="LocalObject") String LocalObject) {
        return dri.getDS(LocalObject);
    }

    @WebMethod(operationName="operation")
    public String operation(@WebParam(name="SqlText") String SqlText) {
        try {
            Document doc = XmlHelper.getDoc((String)SqlText);
            if (doc == null) {
                throw new ServiceException("\u8bf7\u6c42XML\u683c\u5f0f\u9519\u8bef");
            }
            IDURequest idu = ParseIDUDocument.parse((Document)doc);
            IDUResult idur = dri.executeIDU(idu);
            return String.valueOf(idur.getState() == 1 ? -1 : 0) + "||" + idur.getErrMsg();
        }
        catch (Exception e) {
            return "-1||" + e.getMessage();
        }
    }

    private int getPageNumber(int startRowIndex, int pageSize) {
        int pageNumber = 1;
        if (startRowIndex <= 0) {
            startRowIndex = 1;
        }
        if (pageSize <= 0) {
            pageSize = 1;
        }
        pageNumber = startRowIndex <= 1 ? 1 : startRowIndex / pageSize + 1;
        return pageNumber;
    }
}

