/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.service;

import com.xdja.drs.service.Data;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class QueryResult
implements Serializable {
    private static final long serialVersionUID = -852250109663342536L;
    private int state;
    private long rowTotal;
    private int currRows;
    private String localTable;
    private String[] localFields;
    private List<Data[]> rows = new ArrayList<Data[]>();
    private String errMsg = null;

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public long getRowTotal() {
        return this.rowTotal;
    }

    public void setRowTotal(long rowTotal) {
        this.rowTotal = rowTotal;
    }

    public int getCurrRows() {
        return this.currRows;
    }

    public void setCurrRows(int currRows) {
        this.currRows = currRows;
    }

    public String getLocalTable() {
        return this.localTable;
    }

    public void setLocalTable(String localTable) {
        this.localTable = localTable;
    }

    public String[] getLocalFields() {
        return this.localFields;
    }

    public void setLocalFields(String[] localFields) {
        this.localFields = localFields;
    }

    public List<Data[]> getRows() {
        return this.rows;
    }

    public void setRows(List<Data[]> rows) {
        this.rows = rows;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        if (this.errMsg != null) {
            return this.errMsg;
        }
        Document doc = DocumentHelper.createDocument();
        doc.setXMLEncoding("UTF-8");
        Element root = doc.addElement("RequestAgent");
        root.addElement("Type").setText(this.localTable);
        Element values = root.addElement("Items").addElement("Values");
        Element firstRow = values.addElement("Row");
        if (this.errMsg != null) {
            firstRow.addElement("Data").setText("-1");
            firstRow.addElement("Data").setText(this.errMsg);
        } else {
            firstRow.addElement("Data").setText(String.valueOf(this.rowTotal));
            values.addElement("Row").addElement("Data").setText(String.valueOf(this.currRows));
            if (this.rowTotal > 0L) {
                Element threeRow = values.addElement("Row");
                String[] stringArray = this.localFields;
                int n = this.localFields.length;
                int n2 = 0;
                while (n2 < n) {
                    String fName = stringArray[n2];
                    threeRow.addElement("Data").setText(fName);
                    ++n2;
                }
                for (Data[] dataRow : this.rows) {
                    Element row = values.addElement("Row");
                    Data[] dataArray = dataRow;
                    int n3 = dataRow.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Data data = dataArray[n4];
                        Element dataEl = row.addElement("Data");
                        dataEl.addAttribute("IsCode", data.isCode() ? "1" : "0");
                        dataEl.addAttribute("CodeValue", data.getCodeValue() == null ? "" : data.getCodeValue());
                        if (data.getValue() != null) {
                            dataEl.setText(data.getValue());
                        }
                        ++n4;
                    }
                }
            }
        }
        return doc.asXML();
    }
}

