/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.hlj;

import com.alibaba.fastjson.JSON;
import com.xdja.basecode.util.HelpFunction;
import com.xdja.drs.business.hlj.dto.DataQueryDto;
import com.xdja.drs.business.hlj.dto.DataQueryResponseDto;
import com.xdja.drs.business.hlj.utils.DataQuerySoapRestUtils;
import com.xdja.drs.business.hlj.utils.DataQueryUtils;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.httpClient.iface.HttpClientOperate;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.model.OutsideTable;
import com.xdja.drs.service.QueryRequest;
import com.xdja.drs.util.BeanUtils;
import com.xdja.drs.util.DataOperateType;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.tools.OrganizeSql;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataQueryWebServiceFlow
implements WorkFlow {
    private static final Logger logger = LoggerFactory.getLogger(DataQueryWebServiceFlow.class);
    private static final HttpClientOperate httpClientOperate = (HttpClientOperate)BeanUtils.getBean(HttpClientOperate.class);

    public void process(WorkSheet sheet) throws ServiceException {
        logger.debug("start hlj webservice query");
        if (DataOperateType.query.equals((Object)sheet.getDoType())) {
            new OrganizeSql().process(sheet);
            this.processPageQuery(sheet);
            logger.debug("finish hlj webservice not query");
            return;
        }
        logger.debug("not query process!");
    }

    private void processPageQuery(WorkSheet sheet) throws ServiceException {
        QueryRequest rp = sheet.getQueryParameters();
        OutsideTable ot = sheet.getCurrOutTable();
        OutsideDataSource ds = DaoService.getDataSourceDao().getDS(ot.getOutdsId());
        if (HelpFunction.isEmpty((String)ot.getOwner()) || ot.getOwner().indexOf(",") == -1) {
            throw new ServiceException("\u9ed1\u9f99\u6c5f\u6570\u636e\u6e90,\u5916\u90e8\u6570\u636e\u5bf9\u8c61,\u6240\u6709\u8005\u914d\u7f6e\u9519\u8bef");
        }
        LinkedHashMap fields = sheet.getLocalOutMapFields();
        String translateWhereSql = sheet.getTranslateWhereSql();
        DataQueryDto dataQueryDto = this.initDataQueryDto(rp, ot, ds, fields, translateWhereSql);
        DataQueryResponseDto response = this.invokeSoap(ds.getUrl(), dataQueryDto);
        this.executeQueryResult(sheet, response);
    }

    private DataQueryResponseDto invokeSoap(String url, DataQueryDto dataQueryDto) throws ServiceException {
        String xml = DataQuerySoapRestUtils.buildRequest(dataQueryDto);
        logger.debug("hlj soap request is [{}]", (Object)xml);
        DataQueryResponseDto response = DataQuerySoapRestUtils.invokeWithHttpClient(url, xml, httpClientOperate);
        return response;
    }

    private void executeQueryResult(WorkSheet sheet, DataQueryResponseDto response) {
        sheet.setRowTotal(response.getTotal().longValue());
        logger.debug("\u672c\u6b21\u67e5\u8be2\u7ed3\u679c:" + JSON.toJSONString(response.getData()));
        sheet.setQueryResult(response.getData());
        logger.debug("hlj \u8f6c\u6362\u67e5\u8be2\u7ed3\u679c\u5b8c\u6bd5");
    }

    private DataQueryDto initDataQueryDto(QueryRequest rp, OutsideTable ot, OutsideDataSource ds, LinkedHashMap<String, String> fields, String translateWhereSql) throws ServiceException {
        int index = ot.getOwner().indexOf(",");
        if (index == -1) {
            throw new ServiceException("\u8bf7\u914d\u7f6e\u67e5\u8be2\u6761\u4ef6");
        }
        String serviceId = ot.getOwner().substring(0, index);
        String tjxhJson = ot.getOwner().substring(index + 1);
        DataQueryDto dataQueryDto = DataQueryUtils.buildDto(serviceId, ds.getUsername());
        dataQueryDto.setSfzh(rp.getUuInfo().getPoliceSfzh());
        Map<String, String> tjxhMap = DataQueryUtils.convertTjxhMap(tjxhJson);
        if (!DataQueryUtils.fillRequiredItems(dataQueryDto, fields)) {
            throw new ServiceException("\u8bf7\u63d0\u4f9b\u67e5\u8be2\u5b57\u6bb5");
        }
        if (!DataQueryUtils.fillCondition(dataQueryDto, translateWhereSql, tjxhMap)) {
            throw new ServiceException("\u521b\u5efa\u67e5\u8be2\u6761\u4ef6\u5931\u8d25!");
        }
        dataQueryDto.setPageNum(rp.getPageNumber());
        dataQueryDto.setRowsPerPage(rp.getPageSize());
        return dataQueryDto;
    }

    @Deprecated
    private void write(String xml) {
        StringBuffer curl = new StringBuffer();
        curl.append("curl -H 'Content-Type:text/xml;charset=utf-8;SOAPAction: \"test\"' -d").append(" '").append(xml).append("' http://10.112.57.131:8989/dataquery > response.log");
        try {
            String fileName = "request.log";
            FileUtils.writeStringToFile((File)new File("d:\\" + fileName), (String)curl.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

