/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.hlj.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import com.xdja.basecode.xml.XmlHelper;
import com.xdja.drs.business.hlj.dto.DataQueryDto;
import com.xdja.drs.business.hlj.dto.DataQueryResponseDto;
import com.xdja.drs.httpClient.bean.HttpResult;
import com.xdja.drs.httpClient.iface.HttpClientOperate;
import com.xdja.drs.util.ServiceException;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataQuerySoapRestUtils {
    private static final String PAGE_QUERY_BODY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><dat:PageQuery  xmlns:dat=\"http://dataquery.inf.com\"><dat:SenderID></dat:SenderID><dat:ServiceID></dat:ServiceID><dat:EndUser></dat:EndUser><dat:DataObjectCode></dat:DataObjectCode><dat:Condition></dat:Condition><dat:RequiredItems></dat:RequiredItems><dat:InfoCodeMode></dat:InfoCodeMode><dat:RowsPerPage></dat:RowsPerPage><dat:PageNum></dat:PageNum><dat:sfzh></dat:sfzh><dat:cxlb></dat:cxlb></dat:PageQuery>";
    private static final String UNION_CODE_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";
    private static final Logger logger = LoggerFactory.getLogger(DataQuerySoapRestUtils.class);
    private static final String XML_REQUEST_BODY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:dat=\"http://dataquery.inf.com\"><soapenv:Header/><soapenv:Body></soapenv:Body></soapenv:Envelope>";

    public static String buildRequest(DataQueryDto dataQueryDto) {
        Document document = XmlHelper.getDoc((String)PAGE_QUERY_BODY);
        Element pageQuery = document.getRootElement();
        pageQuery.element("SenderID").setText(dataQueryDto.getSenderId());
        pageQuery.element("ServiceID").setText(dataQueryDto.getServiceId());
        pageQuery.element("Condition").setText(dataQueryDto.getCondition());
        Element template = pageQuery.element("RequiredItems");
        pageQuery.remove(template);
        int index = 5;
        for (String item : dataQueryDto.getRequiredItems()) {
            Element copy = template.createCopy();
            copy.setText(item);
            pageQuery.elements().add(index, copy);
            ++index;
        }
        if (dataQueryDto.getRowsPerPage() == 0) {
            dataQueryDto.setRowsPerPage(10);
        }
        pageQuery.element("RowsPerPage").setText(String.valueOf(dataQueryDto.getRowsPerPage()));
        if (dataQueryDto.getPageNum() == 0) {
            dataQueryDto.setPageNum(1);
        }
        pageQuery.element("PageNum").setText(String.valueOf(dataQueryDto.getPageNum()));
        pageQuery.element("sfzh").setText(dataQueryDto.getSfzh());
        if (StringUtils.isNotBlank((CharSequence)dataQueryDto.getCxlb())) {
            pageQuery.element("cxlb").setText(dataQueryDto.getCxlb());
        } else {
            pageQuery.element("cxlb").setText("1");
        }
        Document soap = XmlHelper.getDoc((String)XML_REQUEST_BODY);
        Element body = soap.getRootElement().element("Body");
        body.add(pageQuery);
        return soap.getRootElement().asXML();
    }

    private static DataQueryResponseDto buildResponse(String response) throws ServiceException {
        response = response.replaceAll(UNION_CODE_REGEX, "");
        try {
            Document document = XmlHelper.getDoc((String)response);
            Element body = document.getRootElement().element("Body");
            Element fault = body.element("Fault");
            if (fault != null) {
                String faultCode = "";
                String faultString = "";
                try {
                    faultCode = fault.element("faultcode").getTextTrim();
                    faultString = fault.element("faultstring").getTextTrim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ServiceException("\u9ed1\u9f99\u6c5fwebservice\u8c03\u7528\u5931\u8d25!code=" + faultCode + "," + faultString);
            }
            Element queryResponse = body.element("PageQueryResponse");
            if (queryResponse == null) {
                throw new ServiceException("\u9ed1\u9f99\u6c5fwebservice\u8c03\u7528\u5931\u8d25 \u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a,QueryResponse");
            }
            Element element = queryResponse.element("return");
            if (element == null) {
                throw new ServiceException("\u9ed1\u9f99\u6c5fwebservice\u8c03\u7528\u5931\u8d25 \u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a,return");
            }
            String json = element.getText();
            JSONArray jsonArray = JSON.parseArray((String)json);
            if (jsonArray == null || jsonArray.size() == 0) {
                throw new ServiceException("\u9ed1\u9f99\u6c5fwebservice\u8c03\u7528\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
            }
            JSONArray message = jsonArray.getJSONArray(0);
            if (!"000".equals(message.get(0))) {
                throw new ServiceException("\u8c03\u7528\u7ed3\u679c\u8fd4\u56de\u4e0d\u6b63\u786e!");
            }
            DataQueryResponseDto responseDto = new DataQueryResponseDto();
            try {
                responseDto.setTotal(Long.valueOf(message.get(1).toString()));
            }
            catch (NumberFormatException e) {
                responseDto.setTotal(0L);
            }
            if (responseDto.getTotal() <= 0L) {
                return responseDto;
            }
            JSONArray headArray = jsonArray.getJSONArray(1);
            for (int i = 2; i < jsonArray.size(); ++i) {
                JSONArray returnArray = jsonArray.getJSONArray(i);
                LinkedHashMap data = Maps.newLinkedHashMap();
                int interrupt = 0;
                for (int j = 0; j < headArray.size(); ++j) {
                    String value = returnArray.getString(j);
                    data.put(headArray.getString(j), value);
                    if (!StringUtils.isEmpty((CharSequence)value)) continue;
                    ++interrupt;
                }
                if (interrupt >= returnArray.size()) {
                    logger.debug("\u68c0\u67e5\u5230\u5168\u7a7a\u6570\u636e,\u81ea\u52a8\u9000\u51fa\u5faa\u73af");
                    break;
                }
                responseDto.getData().add(data);
            }
            return responseDto;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("\u9ed1\u9f99\u6c5fwebservice\u8c03\u7528\u5931\u8d25!\u8fd4\u56de\u503c[{}]\u89e3\u6790\u5f02\u5e38!", (Object)response, (Object)e);
            throw new ServiceException("\u9ed1\u9f99\u6c5fwebservice\u8c03\u7528\u5931\u8d25!\u89e3\u6790\u5f02\u5e38!");
        }
    }

    public static DataQueryResponseDto invokeWithHttpClient(String url, String xml, HttpClientOperate httpClientOperate) throws ServiceException {
        HttpResult httpResult = httpClientOperate.doPostXML(url, xml);
        if (!httpResult.isSucc()) {
            logger.error("\u9ed1\u9f99\u6c5fwebService,http\u8c03\u7528webservice\u5931\u8d25!,request:[{}],response:[{}]", (Object)xml, (Object)httpResult.getErrMsg());
            throw new ServiceException("\u9ed1\u9f99\u6c5fwebService,http\u63a5\u53e3\u8c03\u7528\u5931\u8d25!");
        }
        String response = httpResult.getContent();
        if (StringUtils.isEmpty((CharSequence)response)) {
            logger.error("\u9ed1\u9f99\u6c5fwebService,http\u8c03\u7528webservice\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!,request:[{}],response:[{}]", (Object)xml, (Object)httpResult.getErrMsg());
            throw new ServiceException("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
        }
        return DataQuerySoapRestUtils.buildResponse(response);
    }
}

