/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.hlj.utils;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xdja.drs.business.hlj.dto.DataQueryConditionDto;
import com.xdja.drs.business.hlj.dto.DataQueryDto;
import com.xdja.drs.business.hlj.dto.DateQueryConditionDto;
import com.xdja.drs.service.UserUnitInfo;
import com.xdja.drs.util.ServiceException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataQueryUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataQueryUtils.class);
    private static final String QUERY_TYPE_KEY = "tjxh";
    private static Pattern pattern = Pattern.compile("[0-9]*");

    public static Map<String, String> convertTjxhMap(String json) throws ServiceException {
        LinkedHashMap response = Maps.newLinkedHashMap();
        if (StringUtils.isEmpty((CharSequence)json)) {
            return response;
        }
        try {
            JSONObject jsonObject = (JSONObject)JSON.parseObject((String)json, JSONObject.class);
            if (jsonObject.keySet().isEmpty()) {
                return response;
            }
            Set keys = jsonObject.keySet();
            for (String key : keys) {
                response.put(key, jsonObject.getString(key));
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u914d\u7f6e\u67e5\u8be2\u6761\u4ef6\u7f16\u7801\u683c\u5f0f\u5f02\u5e38!");
        }
        return response;
    }

    public static boolean fillEndUser(DataQueryDto dto, UserUnitInfo uuInfo) {
        String[] endUser = new String[]{uuInfo.getPoliceName(), uuInfo.getPoliceSfzh(), uuInfo.getUnitCode(), "  "};
        String json = JSON.toJSONString((Object)endUser);
        logger.debug("\u83b7\u53d6");
        dto.setEndUser(json);
        return true;
    }

    public static boolean fillRequiredItems(DataQueryDto dto, LinkedHashMap<String, String> fields) {
        ArrayList requiredItems = Lists.newArrayList();
        if (CollectionUtils.isEmpty(fields)) {
            return false;
        }
        for (String field : fields.values()) {
            if (StringUtils.isEmpty((CharSequence)field)) continue;
            requiredItems.add(field.toUpperCase());
        }
        dto.setRequiredItems(requiredItems);
        return true;
    }

    private static <K, V> V getFirstNotNull(Map<K, V> map) {
        Map.Entry<K, V> entry;
        V obj = null;
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext() && (obj = (V)(entry = iterator.next()).getValue()) == null) {
        }
        return obj;
    }

    public static boolean fillCondition(DataQueryDto dto, String translateWhereSql, Map<String, String> map) throws ServiceException {
        JSONObject response = new JSONObject();
        if (StringUtils.isEmpty((CharSequence)translateWhereSql)) {
            response.put(QUERY_TYPE_KEY, (Object)DataQueryUtils.getFirstNotNull(map));
            return true;
        }
        logger.debug("translateWhereSql [{}]", (Object)translateWhereSql);
        DateQueryConditionDto query = DataQueryUtils.fillConditions(dto, translateWhereSql, map);
        if (query == null) {
            throw new ServiceException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)query.getTjxh())) {
            throw new ServiceException("\u672a\u5305\u542b\u6709\u6548\u67e5\u8be2\u6761\u4ef6!");
        }
        dto.setCondition(JSON.toJSONString((Object)query, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseSingleQuotes}));
        return true;
    }

    private static DateQueryConditionDto fillConditions(DataQueryDto dto, String sql, Map<String, String> map) throws ServiceException {
        DateQueryConditionDto query = new DateQueryConditionDto();
        List<TableStat.Condition> druidConditions = DataQueryUtils.druidConditions(sql);
        ArrayList validConditions = Lists.newArrayList();
        for (TableStat.Condition condition : druidConditions) {
            if ("1".equals(condition.getColumn().getName())) {
                logger.debug("\u9ed8\u8ba4\u5b57\u6bb5");
                continue;
            }
            DataQueryConditionDto validCondition = new DataQueryConditionDto();
            validCondition.setOperator(condition.getOperator());
            if ("=".equals(condition.getOperator())) {
                validCondition.setOperator("1");
            } else if ("LIKE".equals(condition.getOperator())) {
                validCondition.setOperator("2");
            } else {
                throw new ServiceException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
            }
            validCondition.setName(condition.getColumn().getName());
            String tjxh = map.get(validCondition.getName());
            if (StringUtils.isEmpty((CharSequence)tjxh)) {
                logger.debug("\u975e\u67e5\u8be2\u6761\u4ef6,\u5ffd\u7565[{}]", (Object)validCondition.getName());
                continue;
            }
            if (condition.getValues().size() > 1) {
                logger.debug("\u540c\u4e00\u4e2a\u53c2\u6570\u591a\u4e2a\u503c[{}],\u53ea\u53d6\u7b2c\u4e00\u4e2a", (Object)validCondition.getName());
                validCondition.setValue(Lists.newArrayList((Object[])new Object[]{condition.getValues().get(0)}));
            } else {
                validCondition.setValue(condition.getValues());
            }
            validConditions.add(validCondition);
        }
        if (validConditions.isEmpty()) {
            throw new ServiceException("\u6ca1\u6709\u6709\u6548\u67e5\u8be2\u6761\u4ef6!");
        }
        if (validConditions.size() == 1) {
            DataQueryConditionDto oneCondition = (DataQueryConditionDto)validConditions.get(0);
            query.setTjxh(map.get(oneCondition.getName()));
            ArrayList values = Lists.newArrayList();
            for (Object value : oneCondition.getValue()) {
                if (value instanceof String) {
                    if (DataQueryUtils.isNumeric(String.valueOf(value))) {
                        values.add(value);
                        continue;
                    }
                    values.add(value.toString());
                    continue;
                }
                values.add(value);
            }
            query.setValue(values);
            dto.setCxlb(oneCondition.getOperator());
        } else {
            query = DataQueryUtils.fillMoreConditions(dto, validConditions, map);
            dto.setCxlb("1");
        }
        return query;
    }

    public static boolean isNumeric(String str) {
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    private static DateQueryConditionDto fillMoreConditions(DataQueryDto dto, List<DataQueryConditionDto> validConditions, Map<String, String> map) {
        DateQueryConditionDto query = new DateQueryConditionDto();
        query.setTjxh("#");
        ArrayList values = Lists.newArrayList();
        for (DataQueryConditionDto condition : validConditions) {
            LinkedHashMap json = Maps.newLinkedHashMap();
            json.put("\u53c2\u6570", condition.getName());
            json.put("\u503c", condition.getValue().get(0));
            if ("1".equals(condition.getOperator())) {
                json.put("\u67e5\u8be2\u7c7b\u578b", "\u7cbe\u786e");
            }
            if ("2".equals(condition.getOperator())) {
                json.put("\u67e5\u8be2\u7c7b\u578b", "\u6a21\u7cca");
            }
            values.add(json);
        }
        query.setValue(values);
        return query;
    }

    private static List<TableStat.Condition> druidConditions(String condition) throws ServiceException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("select 1 from dual where ").append(condition);
        try {
            MySqlStatementParser parser = new MySqlStatementParser(buffer.toString());
            SQLStatement statement = parser.parseStatement();
            MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
            statement.accept((SQLASTVisitor)visitor);
            return visitor.getConditions();
        }
        catch (Exception e) {
            logger.warn("\u8f6c\u6362\u673asql\u5f02\u5e38 sql[{}]", (Object)buffer, (Object)e);
            throw new ServiceException("\u67e5\u8be2\u6761\u4ef6\u5f02\u5e38!");
        }
    }

    public static DataQueryDto buildDto(String serviceId, String senderId) {
        DataQueryDto dto = new DataQueryDto();
        dto.setServiceId(serviceId);
        dto.setSenderId(senderId);
        return dto;
    }

    public static void main(String[] args) {
        String sql = "select 1 from dual where x   like   or y=1";
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        SQLStatement statement = parser.parseStatement();
        MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
        statement.accept((SQLASTVisitor)visitor);
        List conditons = visitor.getConditions();
        System.out.println(conditons.get(0));
    }
}

