/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.xz;

import com.alibaba.fastjson.JSON;
import com.dragonsoft.node.adapter.comm.RbspCall;
import com.dragonsoft.node.adapter.comm.RbspService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xdja.basecode.util.HelpFunction;
import com.xdja.basecode.xml.XmlHelper;
import com.xdja.drs.business.xz.DragonXZErrorDesc;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.model.OutsideTable;
import com.xdja.drs.service.QueryRequest;
import com.xdja.drs.service.UserUnitInfo;
import com.xdja.drs.util.DataOperateType;
import com.xdja.drs.util.DragonWSErrorDesc;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.tools.OrganizeSql;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragonSoftXZ
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(DragonSoftXZ.class);
    private static final Long dataSize = 1000L;

    public void process(WorkSheet sheet) throws ServiceException {
        String result;
        HashMap<String, String> condMap;
        if (DataOperateType.query == sheet.getDoType()) {
            new OrganizeSql().process(sheet);
            QueryRequest rp = sheet.getQueryParameters();
            OutsideTable ot = sheet.getCurrOutTable();
            OutsideDataSource ds = DaoService.getDataSourceDao().getDS(ot.getOutdsId());
            log.debug("\u5f00\u59cb\u751f\u6210\u8bf7\u6c42\u5ba2\u6237\u7aef\u3002\u3002\u3002");
            RbspCall call = this.createCall(ds.getUsername(), ot.getOwner(), ds.getUrl(), rp.getUuInfo());
            condMap = new HashMap<String, String>();
            Map<String, Object> params = this.generateParams(sheet, ot, condMap);
            result = call.invoke(params);
            log.debug("result:" + result);
            if (HelpFunction.isEmpty((String)result)) {
                throw new ServiceException("\u5de8\u9f99\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
        } else {
            throw new ServiceException("\u5de8\u9f99\u63a5\u53e3\u4e0d\u652f\u6301\u91c7\u96c6\u64cd\u4f5c");
        }
        this.processResult(sheet, result, condMap);
    }

    private RbspCall createCall(String senderId, String serviceId, String serviceUrl, UserUnitInfo userInfo) {
        log.debug("createCall\u65b9\u6cd5\u4e2d senderId:" + senderId + "serviceId:" + serviceId);
        RbspService service = new RbspService(senderId, serviceId);
        service.setUserCardId(userInfo.getPoliceSfzh());
        log.debug("PoliceSfzh:" + userInfo.getPoliceSfzh());
        service.setUserDept(userInfo.getUnitCode());
        log.debug("UnitCode:" + userInfo.getUnitCode());
        service.setUserName(userInfo.getPoliceName());
        log.debug("PoliceName:" + userInfo.getPoliceName());
        RbspCall call = service.createCall();
        call.setUrl("http://" + serviceUrl + "/node");
        log.debug("url:" + ("http://" + serviceUrl + "/node"));
        call.setMethod("SearchForMultiScope");
        return call;
    }

    private Map<String, Object> generateParams(WorkSheet sheet, OutsideTable ot, Map<String, String> condMap) {
        int pageNumber = sheet.getQueryParameters().getPageNumber();
        int pageSize = sheet.getQueryParameters().getPageSize();
        int startIndex = 1;
        if (pageNumber > 1) {
            startIndex = pageNumber * pageSize - pageSize + 1;
        }
        HashMap params = Maps.newHashMap();
        params.put("IsSynonym", "0");
        params.put("DataScope", ot.getId().substring(ot.getId().lastIndexOf(".") + 1).toUpperCase());
        log.debug("DataScope:" + ot.getId().substring(ot.getId().lastIndexOf(".") + 1).toUpperCase());
        params.put("IsContinue", "0");
        params.put("SearchID", "1");
        params.put("StartRow", startIndex);
        params.put("RowsNum", pageSize);
        String condition = DragonSoftXZ.processCondition(sheet.getTranslateWhereSql(), condMap);
        params.put("Condition", condition);
        log.debug("Condition:" + condition);
        Iterator it = sheet.getOutLocalMapFields().keySet().iterator();
        ArrayList qFieldList = Lists.newArrayList();
        while (it.hasNext()) {
            qFieldList.add(it.next());
        }
        params.put("RequiredItems", qFieldList.toArray(new String[qFieldList.size()]));
        log.debug(JSON.toJSONString((Object)params));
        return params;
    }

    private void fatchQueryResult(WorkSheet sheet, Element method) {
        List rowList = method.selectNodes("Items/Item/Value/Row");
        List cols = ((Element)rowList.get(1)).elements();
        int rowTotal = rowList.size() - 2;
        log.debug("\u8bb0\u5f55\u603b\u6570\uff1a" + sheet.getRowTotal());
        sheet.setRowTotal((long)rowTotal);
        ArrayList rows = new ArrayList();
        int pageNumber = sheet.getQueryParameters().getPageNumber();
        int pageSize = sheet.getQueryParameters().getPageSize();
        int startIndex = 2;
        if (pageNumber > 1) {
            startIndex = pageNumber * pageSize - pageSize + 1 + 1;
        }
        int endIndex = startIndex + pageSize - 1;
        for (int x = startIndex; x < rowList.size(); ++x) {
            List dataRows = ((Element)rowList.get(x)).elements();
            HashMap<String, String> row = new HashMap<String, String>();
            for (int y = 0; y < dataRows.size(); ++y) {
                row.put(((Element)cols.get(y)).getTextTrim().toLowerCase(), ((Element)dataRows.get(y)).getTextTrim());
            }
            rows.add(row);
            if (x == endIndex) break;
        }
        sheet.setQueryResult(rows);
    }

    private String getErrorDesc(String code) {
        if (HelpFunction.isEmpty((String)code)) {
            return "\u672a\u77e5\u9519\u8bef\u4ee3\u7801";
        }
        return DragonWSErrorDesc.getInstance().getDesc(code);
    }

    private void checkError(Element method) throws ServiceException {
        if (null == method) {
            throw new ServiceException("\u5de8\u9f99\u63a5\u53e3\u8fd4\u56de\u683c\u5f0f\u9519\u8bef");
        }
        Element failure = method.element("Failure");
        if (failure != null) {
            throw new ServiceException("\u5de8\u9f99\u63a5\u53e3\u9519\u8bef\uff1a" + failure.elementTextTrim("Code") + "," + failure.elementTextTrim("Comment"));
        }
        List rowList = method.selectNodes("Items/Item/Value/Row");
        if (null == rowList || rowList.isEmpty()) {
            throw new ServiceException("[92003]: \u5de8\u9f99\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e\u884c");
        }
        String retCode = ((Element)((Element)rowList.get(0)).elements().get(0)).getTextTrim();
        if (!"00".equals(retCode) && !"000".equals(retCode)) {
            log.error("\u5de8\u9f99\u63a5\u53e3\u8fd4\u56de\u9519\u8bef\u6d88\u606f\uff0cretCode=" + this.getErrorDesc(retCode));
            throw new ServiceException(this.getErrorDesc(retCode));
        }
    }

    private static String processCondition(String condition, Map<String, String> condMap) {
        String retCond;
        Object[] conds = condition.split("and");
        StringBuffer sb = new StringBuffer();
        if (!HelpFunction.isEmpty((Object[])conds)) {
            for (Object s : conds) {
                String[] array = ((String)s).split("=|>=|<=|>|<|like|in|!=|<>");
                if ("1".equals(array[0].trim())) continue;
                String key = array[0].trim();
                String value = array[1].trim();
                if (value.startsWith("'")) {
                    value = value.substring(1, value.length());
                }
                if (value.endsWith("'")) {
                    value = value.substring(0, value.length() - 1);
                }
                sb.append(value).append(" ");
                condMap.put(key.toLowerCase(), value);
            }
        }
        if ((retCond = sb.toString()).length() > 0) {
            retCond = retCond.substring(0, retCond.length() - 1);
        }
        return retCond;
    }

    private void processResult(WorkSheet sheet, String returnXml, Map<String, String> condMap) throws ServiceException {
        Document doc = XmlHelper.getDoc((String)returnXml);
        String data = doc.selectSingleNode("/RBSPMessage/Method/Items/Item/Value/Data").getText();
        log.debug("data=" + data);
        if (HelpFunction.isEmpty((String)data)) {
            throw new ServiceException("\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e\u884c");
        }
        doc = XmlHelper.getDoc((String)data);
        String code = doc.selectSingleNode("/SearchResult/ReturnCode").getText();
        log.debug("code=" + code);
        if (HelpFunction.isEmpty((String)code)) {
            throw new ServiceException("\u672a\u77e5\u9519\u8bef!");
        }
        if (!"000".equals(code)) {
            throw new ServiceException(DragonXZErrorDesc.getInstance().getDesc(code));
        }
        String numStr = doc.selectSingleNode("/SearchResult/ReturnNum").getText();
        sheet.setRowTotal(HelpFunction.isEmpty((String)numStr) ? 0L : (long)Integer.parseInt(numStr));
        List rows = doc.selectNodes("/SearchResult/Results/ResultScopes/Rows/Row");
        ArrayList retList = new ArrayList();
        if (rows != null && rows.size() > 1) {
            for (int i = 1; i < rows.size(); ++i) {
                HashMap<String, String> row = new HashMap<String, String>();
                Element rowEl = (Element)rows.get(i);
                Element dataEl = (Element)rowEl.selectNodes("Data").get(3);
                List itemEls = dataEl.selectNodes("ContentItems/Item");
                for (Element itemEl : itemEls) {
                    row.put(itemEl.attributeValue("colName").toLowerCase(), itemEl.getText());
                }
                boolean checkFalg = true;
                for (Map.Entry<String, String> entry : condMap.entrySet()) {
                    String condKey = entry.getKey();
                    log.debug("condKey={}", (Object)condKey);
                    String condValue = entry.getValue();
                    log.debug("condValue=" + condValue);
                    log.debug("row.containsKey(condKey)=" + row.containsKey(condKey));
                    log.debug("row.get(condKey)=" + (String)row.get(condKey));
                    if (!row.containsKey(condKey) || HelpFunction.isEmpty((String)((String)row.get(condKey))) || ((String)row.get(condKey)).indexOf(condValue) <= -1) {
                        checkFalg = false;
                    }
                    log.debug("---------------------------------------------");
                }
                if (!checkFalg) continue;
                retList.add(row);
            }
        }
        sheet.setQueryResult(retList);
    }

    public static void main(String[] args) {
        String str = "c_xm = '123' and c_age ='123'";
        DragonSoftXZ.processCondition(str, new HashMap<String, String>());
    }
}

