/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.xz;

import com.xdja.drs.util.Const;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DragonXZErrorDesc {
    private static final Logger log = LoggerFactory.getLogger(DragonXZErrorDesc.class);
    private static HashMap<String, String> codeDesc = new HashMap();
    private static DragonXZErrorDesc dragonDesc = null;

    private DragonXZErrorDesc() {
        this.init();
    }

    public static synchronized DragonXZErrorDesc getInstance() {
        if (dragonDesc == null) {
            dragonDesc = new DragonXZErrorDesc();
        }
        return dragonDesc;
    }

    public String getDesc(String code) {
        return codeDesc.get(code) == null ? "\u672a\u77e5\u9519\u8bef\u4ee3\u7801" : codeDesc.get(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        log.info("\u521d\u59cb\u5316\u897f\u85cf\u8d44\u6e90\u670d\u52a1\u603b\u7ebf\u63a5\u53e3\u9519\u8bef\u4ee3\u7801\u53ca\u63cf\u8ff0\u4fe1\u606f");
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(Const.DRAGON_XZ_ERR_DESC_FILE);
            p.loadFromXML(fis);
            Enumeration<Object> keys = p.keys();
            String key = null;
            while (keys.hasMoreElements()) {
                key = keys.nextElement().toString();
                codeDesc.put(key, p.getProperty(key));
            }
            log.info("\u5171\u8f7d\u5165\u3010" + codeDesc.size() + "\u3011\u6761\u9519\u8bef\u63cf\u8ff0\u4fe1\u606f");
        }
        catch (FileNotFoundException e) {
            log.error("\u6587\u4ef6\u3010" + Const.DRAGON_XZ_ERR_DESC_FILE + "\u3011\u672a\u627e\u5230");
        }
        catch (InvalidPropertiesFormatException e) {
            log.error("\u914d\u7f6e\u6587\u4ef6\u3010" + Const.DRAGON_XZ_ERR_DESC_FILE + "\u3011\u683c\u5f0f\u65e0\u6548");
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u3010" + Const.DRAGON_XZ_ERR_DESC_FILE + "\u3011\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e2) {}
            p = null;
            fis = null;
        }
    }
}

