/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.xz;

import com.alibaba.fastjson.JSON;
import com.xdja.basecode.util.HelpFunction;
import com.xdja.basecode.xml.XmlHelper;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.httpClient.bean.HttpResult;
import com.xdja.drs.httpClient.iface.HttpClientOperate;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.model.OutsideTable;
import com.xdja.drs.service.QueryRequest;
import com.xdja.drs.service.UserUnitInfo;
import com.xdja.drs.util.BeanUtils;
import com.xdja.drs.util.DataOperateType;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.tools.OrganizeSql;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class InSearchXZ
implements WorkFlow {
    private static final Logger logger = LoggerFactory.getLogger(InSearchXZ.class);
    String paramXmlTemplet = "<?xml version=\"1.0\" encoding=\"GBK\"?><request>\n\t<token>\n\t\t<userName></userName>\n\t\t<userIDCard></userIDCard>\n\t\t<userDept></userDept>\n\t</token>\n\t<params>\n\t\t<table></table>\n\t\t<condition></condition>\n\t\t<pageStart></pageStart>\n\t\t<pageSize></pageSize>\n\t\t<sort></sort>\n\t\t<returnFields></returnFields>\n\t</params>\n</request>\n";
    private static final String queryXmlTemplet = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"http://webservice.eagle.dragonsoft.com\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <web:searchSingleResource soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n         <xml xsi:type=\"soapenc:string\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"><![CDATA[@@]]></xml>\n      </web:searchSingleResource>\n   </soapenv:Body>\n</soapenv:Envelope>";
    private static final String SUCCESS_STATUS = "000";
    private static String serviceUrl;
    private static final HttpClientOperate httpClientOperate;

    public void process(WorkSheet sheet) throws ServiceException {
        logger.debug("\u2193\u2193\u2193\u2193\u2193\u2193\u2193\u2193\u2193\u2193 start InSearchXZ \u2193\u2193\u2193\u2193\u2193\u2193\u2193\u2193\u2193\u2193");
        Long startTime = System.currentTimeMillis();
        if (sheet.getDoType() == DataOperateType.query) {
            this.doQuery(sheet);
        }
        Long businessTime = System.currentTimeMillis() - startTime;
        logger.debug("\u2191\u2191\u2191\u2191\u2191\u2191\u2191\u2191\u2191\u2191 end InSearchXZ \u2191\u2191\u2191\u2191\u2191\u2191\u2191\u2191\u2191\u2191\u5171\u8017\u65f6:" + businessTime + "ms");
    }

    public void doQuery(WorkSheet sheet) throws ServiceException {
        logger.debug("@start query Business>>>>>>>>>>>>>>>>>>>>>");
        new OrganizeSql().process(sheet);
        String param = this.initParam(sheet);
        logger.debug("@\u4f20\u8f93\u53c2\u6570\u4fe1\u606f\uff1a" + param);
        Document document = this.invokeMethod(serviceUrl, param);
        this.fatchQueryResult(sheet, document);
        logger.debug("@end query Business<<<<<<<<<<<<<<<<<<<<<<<<");
    }

    private String initParam(WorkSheet sheet) {
        QueryRequest queryRequest = sheet.getQueryParameters();
        OutsideTable ot = sheet.getCurrOutTable();
        OutsideDataSource ds = DaoService.getDataSourceDao().getDS(ot.getOutdsId());
        serviceUrl = ds.getUrl();
        Document document = XmlHelper.getDoc((String)this.paramXmlTemplet);
        Element rootElem = document.getRootElement();
        UserUnitInfo unitInfo = queryRequest.getUuInfo();
        Element userNameElem = rootElem.element("token").element("userName");
        userNameElem.setText(unitInfo.getPoliceName());
        Element userIDCardElem = rootElem.element("token").element("userIDCard");
        userIDCardElem.setText(unitInfo.getPoliceSfzh());
        Element userDeptElem = rootElem.element("token").element("userDept");
        userDeptElem.setText(unitInfo.getUnitCode());
        String table = ot.getOwner();
        Element tableElem = rootElem.element("params").element("table");
        tableElem.setText(table);
        Set fieldSet = sheet.getOutLocalMapFields().keySet();
        StringBuffer strBuffer = new StringBuffer();
        for (String field : fieldSet) {
            strBuffer.append(field).append(",");
        }
        String fields = "";
        if (!StringUtils.isEmpty((Object)strBuffer.toString())) {
            fields = strBuffer.substring(0, strBuffer.length() - 1);
        }
        Element fieldsElem = rootElem.element("params").element("returnFields");
        fieldsElem.setText(fields);
        String condition = this.processCondition(sheet.getTranslateWhereSql());
        if (!StringUtils.isEmpty((Object)condition)) {
            Element conditionElem = rootElem.element("params").element("condition");
            conditionElem.setText(condition);
        }
        int pageNo = queryRequest.getPageNumber() == 0 ? 1 : queryRequest.getPageNumber();
        int pageSize = queryRequest.getPageSize() == 0 ? 10 : queryRequest.getPageSize();
        int pageStart = 0;
        if (pageNo > 1) {
            pageStart = (pageNo - 1) * pageSize;
        }
        Element pageStartElem = rootElem.element("params").element("pageStart");
        pageStartElem.setText(pageStart + "");
        Element pageSizeElem = rootElem.element("params").element("pageSize");
        pageSizeElem.setText(pageSize + "");
        return document.asXML();
    }

    private Document invokeMethod(String serviceUrl, String param) throws ServiceException {
        logger.debug("@start \u8c03\u7528webService\u63a5\u53e3..............................");
        String resultStr = null;
        String queryStr = queryXmlTemplet.replace("@@", param);
        logger.debug("@\u4f20\u8f93soup\u534f\u8bae\uff1a" + queryStr);
        HttpResult httpResult = httpClientOperate.doPostXML(serviceUrl, queryStr);
        if (!httpResult.isSucc()) {
            throw new ServiceException("\u897f\u85cfwebService-http\u63a5\u53e3\u8c03\u7528\u5931\u8d25!");
        }
        resultStr = httpResult.getContent();
        if (StringUtils.isEmpty((Object)resultStr)) {
            throw new ServiceException("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
        }
        Document document = XmlHelper.getDoc((String)resultStr);
        Element returnElem = document.getRootElement().element("Body").element("searchSingleResourceResponse").element("searchSingleResourceReturn");
        String returnStr = returnElem.getText();
        Document rootDom = XmlHelper.getDoc((String)returnStr);
        Element resElem = rootDom.getRootElement().element("response");
        String status1 = resElem.attributeValue("status");
        String desc1 = resElem.attributeValue("desc");
        if (!SUCCESS_STATUS.equals(status1)) {
            throw new ServiceException(desc1);
        }
        String status2 = resElem.element("result").element("head").element("status").getText();
        String desc2 = resElem.element("result").element("head").element("desc").getText();
        if (!SUCCESS_STATUS.equals(status2)) {
            throw new ServiceException(desc2);
        }
        logger.debug("@end \u8c03\u7528webService\u63a5\u53e3..............................");
        return rootDom;
    }

    private void fatchQueryResult(WorkSheet sheet, Document document) {
        logger.debug("@Start \u8f6c\u6362\u67e5\u8be2\u7ed3\u679c..................................");
        ArrayList mapList = new ArrayList();
        Element rootElem = document.getRootElement();
        String count = rootElem.element("response").element("result").element("head").element("count").getText();
        sheet.setRowTotal(StringUtils.isEmpty((Object)count) ? 0L : (long)Integer.parseInt(count));
        List elems = rootElem.element("response").element("result").element("body").selectNodes("data");
        for (Element dataElem : elems) {
            HashMap<String, String> map = new HashMap<String, String>();
            List fieldElems = dataElem.elements();
            for (Element elem : fieldElems) {
                map.put(elem.getName(), elem.getText());
            }
            mapList.add(map);
        }
        logger.debug("\u672c\u6b21\u67e5\u8be2\u7ed3\u679c:" + JSON.toJSONString(mapList));
        sheet.setQueryResult(mapList);
        logger.debug("@End \u8f6c\u6362\u67e5\u8be2\u7ed3\u679c....................................");
    }

    private String processCondition(String conditionStr) {
        String condition = null;
        if (StringUtils.isEmpty((Object)conditionStr)) {
            return condition;
        }
        Object[] conds = conditionStr.split("and");
        StringBuffer sb = new StringBuffer();
        if (!HelpFunction.isEmpty((Object[])conds)) {
            for (Object s : conds) {
                String[] array = ((String)s).split("=|>=|<=|>|<|like|in|!=|<>");
                if ("1".equals(array[0].trim())) continue;
                String key = array[0].trim();
                String value = array[1].trim();
                if (value.startsWith("'")) {
                    value = value.substring(1);
                }
                if (value.endsWith("'")) {
                    value = value.substring(0, value.length() - 1);
                }
                sb.append(value).append(" ");
            }
        }
        if ((condition = sb.toString()).length() > 0) {
            condition = condition.substring(0, condition.length() - 1);
        }
        return condition;
    }

    public static void main(String[] args) throws ServiceException {
        String resultMsgxml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:searchSingleResourceResponse soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"http://webservice.eagle.dragonsoft.com\"><searchSingleResourceReturn xsi:type=\"soapenc:string\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;\n&lt;return&gt;\n  &lt;request&gt;\n    &lt;condition&gt;&#x738B;&#x521A;&lt;/condition&gt;\n    &lt;pageStart&gt;0&lt;/pageStart&gt;\n    &lt;pageSize&gt;5&lt;/pageSize&gt;\n    &lt;table&gt;8a3c7abb661fc9ef01662a79f07a7e44&lt;/table&gt;\n    &lt;sort&gt;&lt;/sort&gt;\n    &lt;returnFields&gt;WHCD,ZZDW_XZQHDM,BZLBDM,SLDW_XZQHDM,JLRKSJ,QFJG_GAJGJGDM,BZ,SSPCS_GAJGMC,SSPCS_GAJGJGDM,XM,SJLYSD,QFRQ,CJSYDM,XMHYPY,XBDM,HKSZD_XZQHDM,SFGJGZRY_PDBZ,XCZJ_ZJHM,ZP,MZDM,ZYMBH,XCZJ_CYZJDM,ZZMMDM,ZJ_YXQJZRQ,RQX_GJHDQDM,CYZJDM,SLSJ,XXZJBH,FWCS,SFDM,GMSFHM,LXDH,XZZ_DZMC,XLDM,ZJHM,CSRQ,JLGXSJ,YDDH,CSD_GJHDQDM&lt;/returnFields&gt;\n  &lt;/request&gt;\n  &lt;response status=&quot;000&quot; desc=&quot;&#x6B63;&#x5E38;&quot; totalCount=&quot;2&quot;&gt;\n    &lt;result&gt;\n      &lt;head&gt;\n        &lt;status&gt;000&lt;/status&gt;\n        &lt;desc&gt;&#x6B63;&#x5E38;&lt;/desc&gt;\n        &lt;table&gt;8a3c7abb661fc9ef01662a79f07a7e44&lt;/table&gt;\n        &lt;name&gt;&#x4EBA;&#x5458;-&#x62A4;&#x7167;&#x529E;&#x7406;&#x4FE1;&#x606F;&lt;/name&gt;\n        &lt;qTime&gt;0&lt;/qTime&gt;\n        &lt;totleTime&gt;22&lt;/totleTime&gt;\n        &lt;count&gt;2&lt;/count&gt;\n      &lt;/head&gt;\n      &lt;body&gt;\n        &lt;data key=&quot;540000LA0021606&quot;&gt;\n          &lt;WHCD displayName=&quot;&#x6587;&#x5316;&#x7A0B;&#x5EA6;&quot;&gt;&#x4E2D;&#x4E13;&lt;/WHCD&gt;\n          &lt;ZZDW_XZQHDM displayName=&quot;&#x5236;&#x8BC1;&#x5355;&#x4F4D;&#x533A;&#x5212;&quot;&gt;5400&lt;/ZZDW_XZQHDM&gt;\n          &lt;BZLBDM displayName=&quot;&#x529E;&#x8BC1;&#x7C7B;&#x522B;&#x4EE3;&#x7801;&quot;&gt;&#x666E;&#x901A;&#x62A4;&#x7167;&lt;/BZLBDM&gt;\n          &lt;SLDW_XZQHDM displayName=&quot;&#x53D7;&#x7406;&#x5355;&#x4F4D;&#x533A;&#x5212;&quot;&gt;540000&lt;/SLDW_XZQHDM&gt;\n          &lt;JLRKSJ displayName=&quot;&#x8BB0;&#x5F55;&#x5165;&#x5E93;&#x65F6;&#x95F4;&#xFF08;&#x9996;&#x6B21;&#x5165;&#x5E93;&#x65F6;&#x95F4;&#xFF09;&quot;&gt;20170623122935&lt;/JLRKSJ&gt;\n          &lt;QFJG_GAJGJGDM displayName=&quot;&#x7B7E;&#x53D1;&#x673A;&#x5173;&#x4EE3;&#x7801;&#x7B7E;&#x53D1;&#x673A;&#x5173;&#x4EE3;&#x7801;&quot;&gt;540000&lt;/QFJG_GAJGJGDM&gt;\n          &lt;BZ displayName=&quot;&#x5907;&#x6CE8;&quot;&gt;&lt;/BZ&gt;\n          &lt;SSPCS_GAJGMC displayName=&quot;&#x6240;&#x5C5E;&#x6D3E;&#x51FA;&#x6240;&#x540D;&#x79F0;&quot;&gt;&#x516B;&#x5ED3;&#x8857;&lt;/SSPCS_GAJGMC&gt;\n          &lt;SSPCS_GAJGJGDM displayName=&quot;&#x6240;&#x5C5E;&#x6D3E;&#x51FA;&#x6240;&#x4EE3;&#x7801;&quot;&gt;&lt;/SSPCS_GAJGJGDM&gt;\n          &lt;XM displayName=&quot;&#x59D3;&#x540D;&quot;&gt;&#x738B;&#x521A;&#x6797;&lt;/XM&gt;\n          &lt;SJLYSD displayName=&quot;&#x6570;&#x636E;&#x6765;&#x6E90;&#x5C5E;&#x5730;&#xFF08;6&#x4F4D;&#x884C;&#x653F;&#x533A;&#x5212;&#x4EE3;&#x7801;&#xFF09;&quot;&gt;&lt;/SJLYSD&gt;\n          &lt;QFRQ displayName=&quot;&#x7B7E;&#x53D1;&#x65E5;&#x671F;&quot;&gt;20030812&lt;/QFRQ&gt;\n          &lt;CJSYDM displayName=&quot;&#x51FA;&#x5883;&#x4E8B;&#x7531;&#x4EE3;&#x7801;&quot;&gt;&#x5546;&#x52A1;&lt;/CJSYDM&gt;\n          &lt;XMHYPY displayName=&quot;&#x59D3;&#x540D;&#x6C49;&#x8BED;&#x62FC;&#x97F3;&quot;&gt;WANGGANGLIN&lt;/XMHYPY&gt;\n          &lt;XBDM displayName=&quot;&#x6027;&#x522B;&#x4EE3;&#x7801;&quot;&gt;&#x7537;&lt;/XBDM&gt;\n          &lt;HKSZD_XZQHDM displayName=&quot;&#x6237;&#x53E3;&#x6240;&#x5728;&#x5730;&#x533A;&#x5212;&quot;&gt;540000&lt;/HKSZD_XZQHDM&gt;\n          &lt;SFGJGZRY_PDBZ displayName=&quot;&#x662F;&#x5426;&#x56FD;&#x5BB6;&#x5DE5;&#x4F5C;&#x4EBA;&#x5458;&quot;&gt;&lt;/SFGJGZRY_PDBZ&gt;\n          &lt;XCZJ_ZJHM displayName=&quot;&#x73B0;&#x6301;&#x8BC1;&#x4EF6;_&#x8BC1;&#x4EF6;&#x53F7;&#x7801;&quot;&gt;&lt;/XCZJ_ZJHM&gt;\n          &lt;ZP displayName=&quot;&#x7167;&#x7247;&quot;&gt;&lt;/ZP&gt;\n          &lt;MZDM displayName=&quot;&#x6C11;&#x65CF;&#x4EE3;&#x7801;&quot;&gt;&lt;/MZDM&gt;\n          &lt;ZYMBH displayName=&quot;&#x8F6C;&#x5370;&#x819C;&#x7F16;&#x53F7;&quot;&gt;&lt;/ZYMBH&gt;\n          &lt;XCZJ_CYZJDM displayName=&quot;&#x73B0;&#x6301;&#x8BC1;&#x4EF6;_&#x5E38;&#x7528;&#x8BC1;&#x4EF6;&#x4EE3;&#x7801;&quot;&gt;&lt;/XCZJ_CYZJDM&gt;\n          &lt;ZZMMDM displayName=&quot;&#x653F;&#x6CBB;&#x9762;&#x8C8C;&#x4EE3;&#x7801;&quot;&gt;&#x4E2D;&#x56FD;&#x5171;&#x4EA7;&#x515A;&#x515A;&#x5458;&lt;/ZZMMDM&gt;\n          &lt;ZJ_YXQJZRQ displayName=&quot;&#x8BC1;&#x4EF6;_&#x6709;&#x6548;&#x671F;&#x622A;&#x6B62;&#x65E5;&#x671F;&quot;&gt;20080811&lt;/ZJ_YXQJZRQ&gt;\n          &lt;RQX_GJHDQDM displayName=&quot;&#x4EBA;&#x53BB;&#x5411;_&#x56FD;&#x5BB6;&#x548C;&#x5730;&#x533A;&quot;&gt;&#x5C3C;&#x6CCA;&#x5C14;&lt;/RQX_GJHDQDM&gt;\n          &lt;CYZJDM displayName=&quot;&#x5E38;&#x7528;&#x8BC1;&#x4EF6;&#x4EE3;&#x7801;&quot;&gt;&lt;/CYZJDM&gt;\n          &lt;SLSJ displayName=&quot;&#x53D7;&#x7406;&#x65F6;&#x95F4;&quot;&gt;20030811&lt;/SLSJ&gt;\n          &lt;XXZJBH displayName=&quot;&#x4FE1;&#x606F;&#x4E3B;&#x952E;&#x7F16;&#x53F7;&quot;&gt;540000LA0021606&lt;/XXZJBH&gt;\n          &lt;FWCS displayName=&quot;&#x5DE5;&#x4F5C;&#x5355;&#x4F4D;&quot;&gt;&#x4E2D;&#x56FD;&#x65C5;&#x6E38;&#x5546;&#x8D38;&#x603B;&#x516C;&#x53F8;&#x897F;&#x85CF;&#x516C;&#x53F8;&lt;/FWCS&gt;\n          &lt;SFDM displayName=&quot;&#x8EAB;&#x4EFD;&#x4EE3;&#x7801;&quot;&gt;&#x8463;&#x4E8B;&#x957F;&#x3001;&#x76D1;&#x4E8B;&#x957F;&#x3001;&#x603B;&#x7ECF;&#x7406;&#x3001;&#x5382;&#x957F;&#x3001;&#x7ECF;&#x7406;&#x3001;&#x4E66;&#x8BB0;&lt;/SFDM&gt;\n          &lt;GMSFHM displayName=&quot;&#x516C;&#x6C11;&#x8EAB;&#x4EFD;&#x53F7;&#x7801;&quot;&gt;540102670702351&lt;/GMSFHM&gt;\n          &lt;LXDH displayName=&quot;&#x8054;&#x7CFB;&#x7535;&#x8BDD;&quot;&gt;6335021&lt;/LXDH&gt;\n          &lt;XZZ_DZMC displayName=&quot;&#x73B0;&#x4F4F;&#x5740;_&#x5730;&#x5740;&#x540D;&#x79F0;&quot;&gt;&#x62C9;&#x8428;&#x5E02;&#x52A0;&#x63AA;&#x65B0;&#x6751;&lt;/XZZ_DZMC&gt;\n          &lt;XLDM displayName=&quot;&#x5B66;&#x5386;&#x4EE3;&#x7801;&quot;&gt;4&lt;/XLDM&gt;\n          &lt;ZJHM displayName=&quot;&#x8BC1;&#x4EF6;&#x53F7;&#x7801;&quot;&gt;G06274529&lt;/ZJHM&gt;\n          &lt;CSRQ displayName=&quot;&#x51FA;&#x751F;&#x65E5;&#x671F;&quot;&gt;19670702&lt;/CSRQ&gt;\n          &lt;JLGXSJ displayName=&quot;&#x8BB0;&#x5F55;&#x66F4;&#x65B0;&#x65F6;&#x95F4;&#xFF08;&#x6BCF;&#x6B21;&#x64CD;&#x4F5C;&#x65F6;&#x95F4;&#xFF09;&quot;&gt;20170623122935&lt;/JLGXSJ&gt;\n          &lt;YDDH displayName=&quot;&#x79FB;&#x52A8;&#x7535;&#x8BDD;&quot;&gt;&lt;/YDDH&gt;\n          &lt;CSD_GJHDQDM displayName=&quot;&#x51FA;&#x751F;&#x5730;&quot;&gt;&#x897F;&#x85CF;&lt;/CSD_GJHDQDM&gt;\n        &lt;/data&gt;\n        &lt;data key=&quot;540000L00012529&quot;&gt;\n          &lt;WHCD displayName=&quot;&#x6587;&#x5316;&#x7A0B;&#x5EA6;&quot;&gt;&lt;/WHCD&gt;\n          &lt;ZZDW_XZQHDM displayName=&quot;&#x5236;&#x8BC1;&#x5355;&#x4F4D;&#x533A;&#x5212;&quot;&gt;5400&lt;/ZZDW_XZQHDM&gt;\n          &lt;BZLBDM displayName=&quot;&#x529E;&#x8BC1;&#x7C7B;&#x522B;&#x4EE3;&#x7801;&quot;&gt;&#x666E;&#x901A;&#x62A4;&#x7167;&lt;/BZLBDM&gt;\n          &lt;SLDW_XZQHDM displayName=&quot;&#x53D7;&#x7406;&#x5355;&#x4F4D;&#x533A;&#x5212;&quot;&gt;540000&lt;/SLDW_XZQHDM&gt;\n          &lt;JLRKSJ displayName=&quot;&#x8BB0;&#x5F55;&#x5165;&#x5E93;&#x65F6;&#x95F4;&#xFF08;&#x9996;&#x6B21;&#x5165;&#x5E93;&#x65F6;&#x95F4;&#xFF09;&quot;&gt;20170623123103&lt;/JLRKSJ&gt;\n          &lt;QFJG_GAJGJGDM displayName=&quot;&#x7B7E;&#x53D1;&#x673A;&#x5173;&#x4EE3;&#x7801;&#x7B7E;&#x53D1;&#x673A;&#x5173;&#x4EE3;&#x7801;&quot;&gt;540000&lt;/QFJG_GAJGJGDM&gt;\n          &lt;BZ displayName=&quot;&#x5907;&#x6CE8;&quot;&gt;&lt;/BZ&gt;\n          &lt;SSPCS_GAJGMC displayName=&quot;&#x6240;&#x5C5E;&#x6D3E;&#x51FA;&#x6240;&#x540D;&#x79F0;&quot;&gt;&#x516C;&#x5FB7;&#x6797;&#x6D3E;&#x51FA;&#x6240;&lt;/SSPCS_GAJGMC&gt;\n          &lt;SSPCS_GAJGJGDM displayName=&quot;&#x6240;&#x5C5E;&#x6D3E;&#x51FA;&#x6240;&#x4EE3;&#x7801;&quot;&gt;540102230000&lt;/SSPCS_GAJGJGDM&gt;\n          &lt;XM displayName=&quot;&#x59D3;&#x540D;&quot;&gt;&#x738B;&#x5FD7;&#x521A;&lt;/XM&gt;\n          &lt;SJLYSD displayName=&quot;&#x6570;&#x636E;&#x6765;&#x6E90;&#x5C5E;&#x5730;&#xFF08;6&#x4F4D;&#x884C;&#x653F;&#x533A;&#x5212;&#x4EE3;&#x7801;&#xFF09;&quot;&gt;&lt;/SJLYSD&gt;\n          &lt;QFRQ displayName=&quot;&#x7B7E;&#x53D1;&#x65E5;&#x671F;&quot;&gt;20130608&lt;/QFRQ&gt;\n          &lt;CJSYDM displayName=&quot;&#x51FA;&#x5883;&#x4E8B;&#x7531;&#x4EE3;&#x7801;&quot;&gt;&#x5546;&#x52A1;&lt;/CJSYDM&gt;\n          &lt;XMHYPY displayName=&quot;&#x59D3;&#x540D;&#x6C49;&#x8BED;&#x62FC;&#x97F3;&quot;&gt;WANGZHIGANG&lt;/XMHYPY&gt;\n          &lt;XBDM displayName=&quot;&#x6027;&#x522B;&#x4EE3;&#x7801;&quot;&gt;&#x7537;&lt;/XBDM&gt;\n          &lt;HKSZD_XZQHDM displayName=&quot;&#x6237;&#x53E3;&#x6240;&#x5728;&#x5730;&#x533A;&#x5212;&quot;&gt;540100&lt;/HKSZD_XZQHDM&gt;\n          &lt;SFGJGZRY_PDBZ displayName=&quot;&#x662F;&#x5426;&#x56FD;&#x5BB6;&#x5DE5;&#x4F5C;&#x4EBA;&#x5458;&quot;&gt;&lt;/SFGJGZRY_PDBZ&gt;\n          &lt;XCZJ_ZJHM displayName=&quot;&#x73B0;&#x6301;&#x8BC1;&#x4EF6;_&#x8BC1;&#x4EF6;&#x53F7;&#x7801;&quot;&gt;&lt;/XCZJ_ZJHM&gt;\n          &lt;ZP displayName=&quot;&#x7167;&#x7247;&quot;&gt;&lt;/ZP&gt;\n          &lt;MZDM displayName=&quot;&#x6C11;&#x65CF;&#x4EE3;&#x7801;&quot;&gt;&#x6C49;&#x65CF;&lt;/MZDM&gt;\n          &lt;ZYMBH displayName=&quot;&#x8F6C;&#x5370;&#x819C;&#x7F16;&#x53F7;&quot;&gt;0019851789&lt;/ZYMBH&gt;\n          &lt;XCZJ_CYZJDM displayName=&quot;&#x73B0;&#x6301;&#x8BC1;&#x4EF6;_&#x5E38;&#x7528;&#x8BC1;&#x4EF6;&#x4EE3;&#x7801;&quot;&gt;&lt;/XCZJ_CYZJDM&gt;\n          &lt;ZZMMDM displayName=&quot;&#x653F;&#x6CBB;&#x9762;&#x8C8C;&#x4EE3;&#x7801;&quot;&gt;&lt;/ZZMMDM&gt;\n          &lt;ZJ_YXQJZRQ displayName=&quot;&#x8BC1;&#x4EF6;_&#x6709;&#x6548;&#x671F;&#x622A;&#x6B62;&#x65E5;&#x671F;&quot;&gt;20230607&lt;/ZJ_YXQJZRQ&gt;\n          &lt;RQX_GJHDQDM displayName=&quot;&#x4EBA;&#x53BB;&#x5411;_&#x56FD;&#x5BB6;&#x548C;&#x5730;&#x533A;&quot;&gt;&#x5C3C;&#x6CCA;&#x5C14;&lt;/RQX_GJHDQDM&gt;\n          &lt;CYZJDM displayName=&quot;&#x5E38;&#x7528;&#x8BC1;&#x4EF6;&#x4EE3;&#x7801;&quot;&gt;&lt;/CYZJDM&gt;\n          &lt;SLSJ displayName=&quot;&#x53D7;&#x7406;&#x65F6;&#x95F4;&quot;&gt;20130524113406&lt;/SLSJ&gt;\n          &lt;XXZJBH displayName=&quot;&#x4FE1;&#x606F;&#x4E3B;&#x952E;&#x7F16;&#x53F7;&quot;&gt;540000L00012529&lt;/XXZJBH&gt;\n          &lt;FWCS displayName=&quot;&#x5DE5;&#x4F5C;&#x5355;&#x4F4D;&quot;&gt;&#x5B89;&#x5168;&#x5385;&lt;/FWCS&gt;\n          &lt;SFDM displayName=&quot;&#x8EAB;&#x4EFD;&#x4EE3;&#x7801;&quot;&gt;&lt;/SFDM&gt;\n          &lt;GMSFHM displayName=&quot;&#x516C;&#x6C11;&#x8EAB;&#x4EFD;&#x53F7;&#x7801;&quot;&gt;540102196602023615&lt;/GMSFHM&gt;\n          &lt;LXDH displayName=&quot;&#x8054;&#x7CFB;&#x7535;&#x8BDD;&quot;&gt;13989911828&lt;/LXDH&gt;\n          &lt;XZZ_DZMC displayName=&quot;&#x73B0;&#x4F4F;&#x5740;_&#x5730;&#x5740;&#x540D;&#x79F0;&quot;&gt;&#x62C9;&#x8428;&#x5E02;&#x57CE;&#x5173;&#x533A;&#x91D1;&#x73E0;&#x4E2D;&#x8DEF;82&#x53F7;&lt;/XZZ_DZMC&gt;\n          &lt;XLDM displayName=&quot;&#x5B66;&#x5386;&#x4EE3;&#x7801;&quot;&gt;&lt;/XLDM&gt;\n          &lt;ZJHM displayName=&quot;&#x8BC1;&#x4EF6;&#x53F7;&#x7801;&quot;&gt;E00100188&lt;/ZJHM&gt;\n          &lt;CSRQ displayName=&quot;&#x51FA;&#x751F;&#x65E5;&#x671F;&quot;&gt;19660202&lt;/CSRQ&gt;\n          &lt;JLGXSJ displayName=&quot;&#x8BB0;&#x5F55;&#x66F4;&#x65B0;&#x65F6;&#x95F4;&#xFF08;&#x6BCF;&#x6B21;&#x64CD;&#x4F5C;&#x65F6;&#x95F4;&#xFF09;&quot;&gt;20170623123103&lt;/JLGXSJ&gt;\n          &lt;YDDH displayName=&quot;&#x79FB;&#x52A8;&#x7535;&#x8BDD;&quot;&gt;&lt;/YDDH&gt;\n          &lt;CSD_GJHDQDM displayName=&quot;&#x51FA;&#x751F;&#x5730;&quot;&gt;&#x5C71;&#x4E1C;&lt;/CSD_GJHDQDM&gt;\n        &lt;/data&gt;\n      &lt;/body&gt;\n    &lt;/result&gt;\n  &lt;/response&gt;\n&lt;/return&gt;</searchSingleResourceReturn></ns1:searchSingleResourceResponse></soapenv:Body></soapenv:Envelope> ";
        HttpResult httpResult = new HttpResult(true, resultMsgxml, 2);
        String resultStr = httpResult.getContent();
        if (StringUtils.isEmpty((Object)resultStr)) {
            throw new ServiceException("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
        }
        Document document = XmlHelper.getDoc((String)resultStr);
        logger.debug(document.asXML());
        Element returnElem = document.getRootElement().element("Body").element("searchSingleResourceResponse").element("searchSingleResourceReturn");
        String returnStr = returnElem.getText();
        Document rootDom = XmlHelper.getDoc((String)returnStr);
    }

    static {
        httpClientOperate = (HttpClientOperate)BeanUtils.getBean(HttpClientOperate.class);
    }
}

