/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz;

import com.xdja.basecode.db.DBUtil;
import com.xdja.drs.service.impl.Row;
import com.xdja.drs.service.impl.Table;
import com.xdja.drs.util.DBConnectPool;
import com.xdja.drs.util.DataOperateType;
import com.xdja.drs.util.FtpUtil;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.business.common.DatabaseAdapter;
import com.xdja.drs.workflow.tools.OrganizeSql;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clyt
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(Clyt.class);

    public void process(WorkSheet sheet) throws ServiceException {
        String[] owner = sheet.getCurrOutTable().getOwner().split("#");
        if (sheet.getDoType() != DataOperateType.query) {
            ((Table)sheet.getIdup().getTables().get(0)).getOutTable().setOutDataObject(owner[0]);
        }
        new OrganizeSql().process(sheet);
        if (sheet.getDoType() == DataOperateType.query) {
            String ownerStr = sheet.getCurrOutTable().getOwner();
            String outDataObject = sheet.getCurrOutTable().getOutDataObject();
            sheet.getCurrOutTable().setOwner("");
            sheet.getCurrOutTable().setOutDataObject(owner[0]);
            try {
                this.query(sheet);
            }
            catch (Exception e) {
                sheet.getCurrOutTable().setOwner(ownerStr);
                sheet.getCurrOutTable().setOutDataObject(outDataObject);
                throw new ServiceException(e.getMessage());
            }
            sheet.getCurrOutTable().setOwner(ownerStr);
            sheet.getCurrOutTable().setOutDataObject(outDataObject);
        } else if (((Row)((Table)sheet.getIdup().getTables().get(0)).getRows().get(0)).getType() == DataOperateType.insert) {
            this.executeInsert(sheet);
        } else {
            this.executeUpdate(sheet);
        }
    }

    private void query(WorkSheet sheet) throws ServiceException {
        log.debug("\u67e5\u8be2: " + sheet.getQueryParameters().getLocalTable());
        DatabaseAdapter dataBaseAdapter = new DatabaseAdapter();
        dataBaseAdapter.process(sheet);
    }

    private void executeInsert(WorkSheet sheet) throws ServiceException {
        log.debug("\u5f55\u5165\u57fa\u7840\u6570\u636e");
        Connection con = this.getConnection(sheet);
        try {
            if (DBUtil.executeBatchUpdate((Connection)con, (ArrayList)sheet.getIdup().getpSqls(), (ArrayList)sheet.getIdup().getParameters())) {
                sheet.setReturnResult("0||ok");
            }
        }
        catch (SQLException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    private void executeUpdate(WorkSheet sheet) throws ServiceException {
        Connection con = this.getConnection(sheet);
        try {
            if (DBUtil.executeBatchUpdate((Connection)con, (ArrayList)sheet.getIdup().getpSqls(), (ArrayList)sheet.getIdup().getParameters())) {
                sheet.setReturnResult("0||ok");
            }
        }
        catch (SQLException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    private Connection getConnection(WorkSheet sheet) {
        return DBConnectPool.getInstance().getConnection(sheet.getCurrOutTable().getOutdsId());
    }

    private String updataFtp(String[] ftpInfo, InputStream is, String fileName) throws IOException, ServiceException {
        String path = "";
        FTPClient client = FtpUtil.getInstance((String)ftpInfo[1], (int)21, (String)ftpInfo[2], (String)ftpInfo[3], (String)"GBK", (int)2);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHH");
        String strDate = df.format(new Date());
        String hour = strDate.substring(8);
        strDate = strDate.substring(0, 8);
        String workDir = strDate + "/" + hour;
        if (client.cwd(strDate) == 250) {
            if (client.cwd(hour) != 250) {
                client.makeDirectory(hour);
                client.cwd(hour);
            }
        } else {
            client.makeDirectory(strDate);
            client.makeDirectory(workDir);
            client.cwd(workDir);
        }
        if (!client.storeFile(fileName, is)) {
            log.error("\u6307\u5b9a\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            throw new ServiceException("\u6307\u5b9a\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
        }
        path = "JWT/" + workDir + "/" + fileName;
        FtpUtil.closeFtp();
        return path;
    }
}

