/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz;

import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.model.OutsideTable;
import com.xdja.drs.util.ServiceClient;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCityList
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(GetCityList.class);
    private static final Namespace soap = Namespace.getNamespace((String)"soap", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final Namespace ns1 = Namespace.getNamespace((String)"ns1", (String)"http://tempuri.org/");

    public void process(WorkSheet sheet) throws ServiceException {
        log.debug("GetCityList...");
        String condition = sheet.getQueryParameters().getCondition();
        OutsideTable outsideTable = sheet.getCurrOutTable();
        log.debug("\u539f\u59cb\u7684\u67e5\u8be2\u6761\u4ef6\uff1a" + condition);
        OutsideDataSource ods = DaoService.getDataSourceDao().getDS(sheet.getCurrOutTable().getOutdsId());
        String url = ods.getUrl();
        log.debug("\u6570\u636e\u6e90url\uff1a" + url);
        if (StringUtils.isBlank((String)condition)) {
            throw new ServiceException("\u8bf7\u8f93\u5165\u67e5\u8be2\u6761\u4ef6");
        }
        String str = condition.substring(condition.indexOf("=") + 1).trim();
        String xml = this.getReturnXml(str, url);
        log.debug("\u8bf7\u6c42GFT\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c" + xml);
        this.fetchReturnResult(sheet, xml);
    }

    private void fetchReturnResult(WorkSheet sheet, String xml) throws ServiceException {
        SAXBuilder saxb = new SAXBuilder();
        Document doc = null;
        Element root = null;
        StringReader strreader = null;
        if (StringUtils.isNotBlank((String)xml)) {
            xml = xml.toLowerCase();
        }
        try {
            strreader = new StringReader(xml);
            doc = saxb.build((Reader)strreader);
            root = doc.getRootElement();
            List<Element> list = root.getChildren("city");
            int count = list.size();
            int rno = (sheet.getQueryParameters().getPageNumber() - 1) * sheet.getQueryParameters().getPageSize();
            int rlen = rno + sheet.getQueryParameters().getPageSize();
            list = this.getListPage(list, String.valueOf(rno), String.valueOf(rlen));
            sheet.setRowTotal((long)count);
            if (list != null && list.size() > 0) {
                for (Element element : list) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("id", element.getChild("c_id").getTextTrim());
                    hashMap.put("csmc", element.getChild("c_csmc").getTextTrim());
                    sheet.getQueryResultList().add(hashMap);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    private String getReturnXml(String str, String url) {
        String xml = "";
        String soapreq = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:tem=\"http://tempuri.org/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <tem:GetCityList>\n         <tem:CityCode>" + str + "</tem:CityCode>\n      </tem:GetCityList>\n   </soapenv:Body>\n</soapenv:Envelope>";
        ServiceClient sc = new ServiceClient(url, soapreq);
        if (sc.excute()) {
            String soapResponse = sc.responseBody;
            SAXBuilder saxb = new SAXBuilder();
            Document doc = null;
            Element root = null;
            StringReader strreader = null;
            try {
                strreader = new StringReader(soapResponse);
                doc = saxb.build((Reader)strreader);
                root = doc.getRootElement();
                xml = root.getChild("Body", soap).getChild("GetCityListResponse", ns1).getChild("GetCityListResult", ns1).getText();
                return xml;
            }
            catch (Exception e) {
                log.debug("\u8bf7\u6c42GFT\u63a5\u53e3\u51fa\u9519.");
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private List<Element> getListPage(List<Element> list, String sno, String eno) {
        List<Object> rslist = new ArrayList();
        try {
            int s = Integer.parseInt(sno);
            int e = Integer.parseInt(eno);
            s = s == 0 ? 1 : s;
            e = e == 0 ? 1 : e;
            e = s + e - 1;
            int i = list.size();
            if (e < s || s < 0 || e < 0) {
                rslist = list;
            } else if (i >= e) {
                for (int j = s; j <= e; ++j) {
                    rslist.add(list.get(j - 1));
                }
            } else if (i >= s && i <= e) {
                for (int j = s; j <= i; ++j) {
                    rslist.add(list.get(j - 1));
                }
            }
        }
        catch (Exception e) {
            log.debug("\u5206\u9875\u8f6c\u6362\u5f02\u5e38");
            rslist = list;
        }
        return rslist;
    }
}

