/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz;

import com.xdja.basecode.db.DBUtil;
import com.xdja.drs.service.QueryRequest;
import com.xdja.drs.util.DBConnectPool;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.tools.OrganizeSql;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class GetGcZpBusiness
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(GetGcZpBusiness.class);

    public void process(WorkSheet sheet) throws ServiceException {
        new OrganizeSql().process(sheet);
        QueryRequest rp = sheet.getQueryParameters();
        String conditionSql = sheet.getTranslateQuerySql().replaceAll(sheet.getCurrOutTable().getOutDataObject(), "t_gctp");
        Connection connection = null;
        ArrayList rows = null;
        connection = DBConnectPool.getInstance().getConnection(sheet.getCurrOutTable().getOutdsId());
        try {
            rows = DBUtil.query((Connection)connection, (String)conditionSql, (Object[])sheet.getqMaskParameters(), (HashMap)sheet.getDateFormat(), (int)rp.getPageNumber(), (int)rp.getPageSize(), (boolean)true);
            HashMap dataMap = (HashMap)rows.get(0);
            String tplj = (String)dataMap.get("tplj");
            String tp1 = (String)dataMap.get("tp1");
            String zpUrl = tplj + tp1;
            log.debug("zpUrl:" + zpUrl);
            HttpPost httpPost = new HttpPost(zpUrl);
            DefaultHttpClient httpClient = new DefaultHttpClient();
            httpPost.setHeader("Connection", "close");
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new ServiceException("http \u8bf7\u6c42\u7167\u7247\u5f02\u5e38");
            }
            InputStream inputStream = httpResponse.getEntity().getContent();
            BASE64Encoder base64Encoder = new BASE64Encoder();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int i = 0;
            while ((i = inputStream.read()) != -1) {
                byteArrayOutputStream.write(i);
            }
            String base64Str = base64Encoder.encode(byteArrayOutputStream.toByteArray());
            dataMap.remove("tp1");
            dataMap.put("tp1", base64Str);
            sheet.setRowTotal((long)rows.size());
            sheet.setQueryResult((List)rows);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException("-1\u83b7\u53d6\u8fc7\u8f66\u7167\u7247\u5931\u8d25:" + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            connection = null;
        }
    }
}

