/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz;

import com.xdja.basecode.db.DBUtil;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.sql.SqlUtils;
import com.xdja.drs.util.DBConnectPool;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.tools.OrganizeSql;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetJWSQ
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(GetJWSQ.class);

    public void process(WorkSheet sheet) throws ServiceException {
        log.debug(">>>>>\u5f00\u59cb\u6267\u884c\u90d1\u5dde\u90d1\u5dde\u8b66\u52a1\u793e\u533a\u7279\u6b8a\u5904\u7406\u7c7b");
        new OrganizeSql().process(sheet);
        String condition = sheet.getQueryParameters().getCondition();
        LinkedHashMap maps = SqlUtils.fetchQueryCondition((String)sheet.getTranslateWhereSql());
        log.debug("\u539f\u59cb\u7684\u8bf7\u6c42\u7684\u67e5\u8be2\u6761\u4ef6\u4e3a" + condition);
        if (StringUtils.isBlank((String)condition) || condition.indexOf("jh") == -1) {
            throw new ServiceException("-1|\u67e5\u8be2\u6761\u4ef6\u6ca1\u6709\u8b66\u5458\u8b66\u53f7\uff0c\u65e0\u6cd5\u83b7\u5f97\u6240\u5c5e\u8f96\u533a\uff01");
        }
        OutsideDataSource ods = DaoService.getDataSourceDao().getDS(sheet.getCurrOutTable().getOutdsId());
        String errorMsg = "";
        if (ods == null) {
            errorMsg = "\u5916\u90e8\u6570\u636e\u6e90\u4e3anull";
            throw new ServiceException(errorMsg);
        }
        log.debug("\u7ffb\u8bd1\u540e\u7684whereSql:" + sheet.getTranslateWhereSql());
        String sql = "select JWsQ FROM GXSYS_USERLIST where " + sheet.getTranslateWhereSql();
        log.debug("\u7ec4\u88c5\u540e\u7684SQL\u4e3a" + sql);
        String dsid = sheet.getCurrOutTable().getOutdsId();
        log.debug("\u5916\u90e8\u6570\u636e\u6e90ID\u4e3a" + dsid);
        Connection connection = DBConnectPool.getInstance().getConnection(dsid);
        if (connection == null) {
            throw new ServiceException("-1|\u83b7\u53d6\u6570\u636e\u6e90\u51fa\u73b0\u5f02\u5e38\u7528\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            ArrayList resultList = DBUtil.query((Connection)connection, (String)sql);
            if (resultList == null || resultList.size() <= 0) {
                throw new ServiceException("\u6ca1\u6709\u67e5\u8be2\u5230\u6240\u5c5e\u8f96\u533a\uff01");
            }
            HashMap result = (HashMap)resultList.get(0);
            String jwsq = (String)result.get("jwsq");
            log.debug("\u8b66\u52a1\u793e\u533a\u4e3a" + jwsq);
            if (StringUtils.isBlank((String)jwsq)) {
                throw new ServiceException("\u6ca1\u6709\u67e5\u8be2\u5230\u6240\u5c5e\u8f96\u533a\uff01");
            }
            sheet.setRowTotal(1L);
            HashMap hashMap = new HashMap();
            hashMap.put("jh", maps.get("jh"));
            hashMap.put("ssxq", jwsq);
            sheet.getQueryResultList().add(hashMap);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }
}

