/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz;

import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.sql.SqlUtils;
import com.xdja.drs.util.DBConnectPool;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.tools.OrganizeSql;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPK
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(GetPK.class);
    private String strGXTableName;
    private String strGXGroupNO;
    private String strSQLCondition;

    public void process(WorkSheet sheet) throws ServiceException {
        log.debug("GetPK...");
        String strRtn = "";
        new OrganizeSql().process(sheet);
        this.checkInValue(sheet);
        strRtn = this.generateSQL(sheet);
        log.debug("\u4ea7\u751frtnsql" + strRtn);
        if (strRtn.length() < 1 || strRtn == "") {
            throw new ServiceException("\u751f\u6210SQL\u8bed\u53e5\u51fa\u9519\uff01");
        }
        OutsideDataSource ods = DaoService.getDataSourceDao().getDS(sheet.getCurrOutTable().getOutdsId());
        String errorMsg = "";
        if (ods == null) {
            errorMsg = "\u5916\u90e8\u6570\u636e\u6e90\u4e3anull";
            throw new ServiceException(errorMsg);
        }
        if ((strRtn = this.doDB(strRtn, sheet)).startsWith("-1")) {
            throw new ServiceException(strRtn);
        }
        sheet.setRowTotal(1L);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SECTNO", strRtn);
    }

    public void checkInValue(WorkSheet sheet) throws ServiceException {
        String localFields = sheet.getQueryParameters().getLocalFields();
        log.debug("GetPK\u7c7b  checkInValue\u65b9\u6cd5  localFields \uff1a" + localFields);
        StringBuilder strColumnsB = new StringBuilder();
        String[] strArray = localFields.split(",");
        for (int i = 0; i < strArray.length; ++i) {
            if (strArray[i].compareToIgnoreCase("c_sectno") == 0) continue;
            strColumnsB.append(strArray[i]);
        }
        if (strColumnsB.length() > 0) {
            log.debug("\u8bf7\u6c42\u5b57\u6bb5\u5fc5\u987bc_sectNO\uff0c\u672c\u6b21\u4e3a:" + strColumnsB.toString());
            throw new ServiceException("\u8bf7\u6c42\u5b57\u6bb5\u5fc5\u987bc_sectNO\uff0c\u672c\u6b21\u4e3a:" + strColumnsB.toString());
        }
        LinkedHashMap maps = SqlUtils.fetchQueryCondition((String)sheet.getTranslateWhereSql());
        if (StringUtils.isBlank((String)((String)maps.get("tablename"))) || StringUtils.isBlank((String)((String)maps.get("groupno")))) {
            throw new ServiceException("\u8f93\u5165\u53c2\u6570\u9519\u8bef\uff0c\u83b7\u5f97\u4e3b\u952e\u65f6\u987b\u901a\u8fc7\u5355\u4f4d\u7f16\u7801\u548c\u8868\u540d");
        }
    }

    public String generateSQL(WorkSheet sheet) {
        String strRTNSQL = "";
        String strSQLTablename = "";
        String strConditionTablename = "";
        String strConditionGroupNo = "";
        strSQLTablename = (this.isNull(sheet.getCurrOutTable().getOwner()) ? "" : sheet.getCurrOutTable().getOwner() + ".") + "gxsys_sequence";
        LinkedHashMap maps = SqlUtils.fetchQueryCondition((String)sheet.getTranslateWhereSql());
        strConditionGroupNo = (String)maps.get("groupno");
        strConditionTablename = (String)maps.get("tablename");
        if ("GX_JZRKXX".equalsIgnoreCase(strConditionTablename)) {
            log.debug("\u83b7\u5f97\u5bc4\u4f4f\u4eba\u5458\u8868");
            this.strGXTableName = strConditionTablename;
            this.strGXGroupNO = "J" + this.rPad(strConditionGroupNo, '0', 12);
        } else if ("GX_CYRYJBXX".equalsIgnoreCase(strConditionTablename)) {
            log.debug("\u4ece\u4e1a\u4eba\u5458\u57fa\u672c\u4fe1\u606f");
            this.strGXTableName = strConditionTablename;
            this.strGXGroupNO = "Y" + this.rPad(strConditionGroupNo, '0', 12);
        } else if ("GX_DWJBXX".equalsIgnoreCase(strConditionTablename)) {
            log.debug("\u5355\u4f4d\u57fa\u672c\u4fe1\u606f\u8868\u4e3b\u952e\u83b7\u53d6");
            this.strGXTableName = strConditionTablename;
            this.strGXGroupNO = "DWJB";
        } else if ("GX_RYTMTZXX".equalsIgnoreCase(strConditionTablename)) {
            log.debug("\u4eba\u5458\u4f53\u8c8c\u7279\u5f81\u4fe1\u606f\u8868\u4e3b\u952e\u83b7\u53d6");
            this.strGXTableName = strConditionTablename;
            this.strGXGroupNO = "RTM";
        } else if ("GX_RYLXFS".equalsIgnoreCase(strConditionTablename)) {
            log.debug("\u4eba\u5458\u8054\u7cfb\u65b9\u5f0f\u8868\u4e3b\u952e\u83b7\u53d6");
            this.strGXTableName = strConditionTablename;
            this.strGXGroupNO = "";
        } else if ("GX_HYCSDWZAJCXX".equalsIgnoreCase(strConditionTablename)) {
            log.debug("\u884c\u4e1a\u573a\u6240\u5355\u4f4d\u6cbb\u5b89\u68c0\u67e5\u4fe1\u606f\u8868\u4e3b\u952e\u83b7\u53d6");
            this.strGXTableName = strConditionTablename;
            this.strGXGroupNO = "JC";
        } else if ("GX_QBXX".equalsIgnoreCase(strConditionTablename)) {
            log.debug("\u793e\u533a\u60c5\u62a5\u4fe1\u606f\u91c7\u96c6\u8868\u4e3b\u952e\u83b7\u53d6");
            this.strGXTableName = strConditionTablename;
            this.strGXGroupNO = "X" + this.rPad(strConditionGroupNo.substring(0, 9), '0', 9) + new SimpleDateFormat("yyyy").format(new Date());
        } else if ("GX_DZZXX".equalsIgnoreCase(strConditionTablename)) {
            log.debug("\u5355\u4f4d\u4f4f\u5740\u8868\u4e3b\u952e\u83b7\u53d6");
            this.strGXTableName = strConditionTablename;
            this.strGXGroupNO = "D" + this.rPad(strConditionGroupNo, '0', 12);
        } else if ("JWT_CLYTCLXXB".equalsIgnoreCase(strConditionTablename)) {
            log.debug("\u67e5\u5f55\u4e00\u4f53\u8f66\u8f86\u8868\u4e3b\u952e\u83b7\u53d6");
            this.strGXTableName = strConditionTablename;
            this.strGXGroupNO = "CLYTCL" + strConditionGroupNo.substring(0, 6) + new SimpleDateFormat("yyyy").format(new Date());
        } else if ("JWT_CLYTRYXXB".equalsIgnoreCase(strConditionTablename)) {
            log.debug("\u67e5\u5f55\u4e00\u4f53\u4eba\u5458\u8868\u4e3b\u952e\u83b7\u53d6");
            this.strGXTableName = strConditionTablename;
            this.strGXGroupNO = "CLYTRY" + strConditionGroupNo.substring(0, 6) + new SimpleDateFormat("yyyy").format(new Date());
        } else {
            log.debug("\u6ca1\u6709\u5bf9\u5e94\u8868\u540d:" + strConditionTablename + "\u65e0\u6cd5\u83b7\u53d6\u8be5\u8868\u7684\u4e3b\u952e\uff01");
        }
        this.strSQLCondition = this.strGXGroupNO.length() < 1 || "".equals(this.strGXGroupNO) ? "tablename='" + this.strGXTableName.toUpperCase() + "' " : "tablename='" + this.strGXTableName.toUpperCase() + "' and groupno='" + this.strGXGroupNO + "'";
        strRTNSQL = "select sectNo ,groupno,sysdate as time from " + strSQLTablename + " where " + this.strSQLCondition + " for update wait 5";
        return strRTNSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doDB(String strSQL, WorkSheet sheet) throws ServiceException {
        String strRTNPK = "";
        String strTableName = "";
        String sql = "";
        sql = strSQL;
        String ls_sectno = "";
        String ls_groupno = "";
        String ls_time = "";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        ResultSet rs = null;
        int i = 0;
        Connection conn = DBConnectPool.getInstance().getConnection(sheet.getCurrOutTable().getOutdsId());
        if (conn == null) {
            log.debug("\u83b7\u53d6\u6570\u636e\u6e90\u51fa\u73b0\u5f02\u5e38\u7528\uff0c\u8bf7\u68c0\u67e5\uff01");
            throw new ServiceException("\u83b7\u53d6\u6570\u636e\u6e90\u51fa\u73b0\u5f02\u5e38\u7528\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            conn.setAutoCommit(false);
            PreparedStatement pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getString("SECTNO") == "") continue;
                ls_sectno = rs.getString("SECTNO");
                ls_groupno = rs.getString("groupno");
                ls_time = df.format(rs.getDate("time"));
                ++i;
            }
            if (i > 1) {
                log.debug("\u6309\u7167\uff1a" + strSQL + "\u67e5\u8be2\uff0c\u8fd4\u56de\u503c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\uff01");
                String string = "-1|\u6309\u7167\uff1a" + strSQL + "\u67e5\u8be2\uff0c\u8fd4\u56de\u503c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\uff01";
                return string;
            }
            if (i < 1) {
                sql = "insert into " + (this.isNull(sheet.getCurrOutTable().getOwner()) ? "" : sheet.getCurrOutTable().getOwner() + ".") + "gxsys_sequence (tablename,sectno,groupno,keyflag,keytime)";
                sql = sql + "values('" + this.strGXTableName.toUpperCase() + "',0,'" + this.strGXGroupNO + "' ,0,'" + df.format(new Date()) + "')";
                log.debug("sql" + sql);
                pstmt = conn.prepareStatement(sql);
                if (pstmt.execute()) {
                    log.debug("\u65b0\u589e\u4e3b\u952e\u8bb0\u5f55\u65f6\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u68c0\u9a8c\uff01");
                    String string = "-1|\u65b0\u589e\u4e3b\u952e\u8bb0\u5f55\u65f6\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u68c0\u9a8c\uff01";
                    return string;
                }
                ls_groupno = this.strGXGroupNO;
                ls_sectno = "0";
            }
            sql = "Update " + (this.isNull(sheet.getCurrOutTable().getOwner()) ? "" : sheet.getCurrOutTable().getOwner() + ".") + "gxsys_sequence set sectNo=" + Integer.toString(Integer.parseInt(ls_sectno) + 1) + " where " + this.strSQLCondition;
            log.debug("update sql:" + sql);
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
            conn.commit();
            if (ls_sectno.length() < 1 || ls_sectno == "") {
                log.debug("\u83b7\u5f97\u8868\u7684\u4e3b\u952e\u65f6\uff0c\u6d41\u6c34\u51fa\u5e2d\u7a7a\u503c\u5bfc\u81f4\u65e0\u6cd5\u83b7\u53d6\u4e3b\u952e\u4e3b\uff01");
                strRTNPK = "-1|\u83b7\u5f97\u8868\u7684\u4e3b\u952e\u65f6\uff0c\u51fa\u73b0\u9519\u8bef";
            }
            strRTNPK = this.generatePK(this.strGXGroupNO, Integer.toString(Integer.parseInt(ls_sectno) + 1), this.strGXTableName);
            log.debug("\u4ea7\u751f" + strRTNPK);
            String string = strRTNPK;
            return string;
        }
        catch (Exception e) {
            log.debug("\u83b7\u5f97\u8868\u7684\u4e3b\u952e\u65f6\uff0c\u51fa\u73b0\u9519\u8bef");
            e.printStackTrace();
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            strRTNPK = "-1|\u83b7\u5f97\u8868\u7684\u4e3b\u952e\u65f6\uff0c\u51fa\u73b0\u9519\u8bef";
        }
        finally {
            try {
                conn.commit();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                strRTNPK = "-1|\u83b7\u5f97\u8868\u7684\u4e3b\u952e\u65f6\uff0c\u51fa\u73b0\u9519\u8bef";
            }
            try {
                conn.close();
            }
            catch (Exception e) {
                log.debug("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u65f6\uff0c\u51fa\u5728\u5f02\u5e38\uff01");
                e.printStackTrace();
                strRTNPK = "-1|\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u65f6\uff0c\u51fa\u5728\u5f02\u5e38";
            }
        }
        return strRTNPK;
    }

    public String generatePK(String groupno, String sectno, String strTableName) {
        String strRTN = "";
        if (strTableName.trim().compareToIgnoreCase("GX_JZRKXX") == 0) {
            log.debug("\u83b7\u5f97\u5bc4\u4f4f\u4eba\u5458\u8868\u4e3b\u952e");
            strRTN = groupno + this.lPad(sectno, '0', 17);
        } else if (strTableName.trim().compareToIgnoreCase("GX_CYRYJBXX") == 0) {
            log.debug("\u4ece\u4e1a\u4eba\u5458\u57fa\u672c\u4fe1\u606f");
            strRTN = groupno + this.lPad(sectno, '0', 7);
        } else if (strTableName.trim().compareToIgnoreCase("GX_DWJBXX") == 0) {
            log.debug("\u5355\u4f4d\u57fa\u672c\u4fe1\u606f\u8868\u4e3b\u952e\u83b7\u53d6");
            strRTN = groupno + this.lPad(sectno, '0', 26);
        } else if (strTableName.trim().compareToIgnoreCase("GX_RYTMTZXX") == 0) {
            log.debug("\u4eba\u5458\u4f53\u8c8c\u7279\u5f81\u4fe1\u606f\u8868\u4e3b\u952e\u83b7\u53d6");
            strRTN = groupno + this.lPad(sectno, '0', 27);
        } else if (strTableName.trim().compareToIgnoreCase("GX_HYCSDWZAJCXX") == 0) {
            log.debug("\u884c\u4e1a\u573a\u6240\u5355\u4f4d\u6cbb\u5b89\u68c0\u67e5\u4fe1\u606f\u8868\u4e3b\u952e\u83b7\u53d6");
            strRTN = groupno + this.lPad(sectno, '0', 18);
        } else if (strTableName.trim().compareToIgnoreCase("GX_QBXX") == 0) {
            log.debug("\u793e\u533a\u60c5\u62a5\u4fe1\u606f\u91c7\u96c6\u8868\u4e3b\u952e\u83b7\u53d6");
            strRTN = groupno + this.lPad(sectno, '0', 6);
        } else if (strTableName.trim().compareToIgnoreCase("GX_DZZXX") == 0) {
            log.debug("\u5355\u4f4d\u4f4f\u5740\u8868\u4e3b\u952e\u83b7\u53d6");
            strRTN = groupno + this.lPad(sectno, '0', 17);
        } else if ("JWT_CLYTCLXXB".equalsIgnoreCase(strTableName.trim())) {
            log.debug("\u67e5\u5f55\u4e00\u4f53\u8f66\u8f86\u8868\u4e3b\u952e\u83b7\u53d6");
            strRTN = groupno + this.lPad(sectno, '0', 14);
        } else if (strTableName.trim().compareToIgnoreCase("JWT_CLYTRYXXB") == 0) {
            log.debug("\u67e5\u5f55\u4e00\u4f53\u4eba\u5458\u8868\u4e3b\u952e\u83b7\u53d6");
            strRTN = groupno + this.lPad(sectno, '0', 14);
        } else if (strTableName.trim().compareToIgnoreCase("GX_RYLXFS") == 0) {
            log.debug("\u4eba\u5458\u8054\u7cfb\u65b9\u5f0f\u8868\u4e3b\u952e\u83b7\u53d6");
            strRTN = this.lPad(sectno, '0', 20);
        } else {
            strRTN = "-1|\u6ca1\u6709\u8981\u67e5\u8be2\u7684\u5916\u90e8\u8868\uff01";
        }
        return strRTN;
    }

    public String lPad(String strP, char chP, int length) {
        int k = 0;
        StringBuilder strRtnB = new StringBuilder();
        k = length - strP.length();
        if (k > 0) {
            for (int l = 0; l < k; ++l) {
                strRtnB.append(chP);
            }
            strRtnB.append(strP);
        } else {
            strRtnB.append(strP);
        }
        return strRtnB.toString();
    }

    public String rPad(String strP, char chP, int length) {
        int k = 0;
        String result = "";
        StringBuilder strRtnB = new StringBuilder();
        k = length - strP.length();
        if (k > 0) {
            for (int l = 0; l < k; ++l) {
                strRtnB.append(chP);
            }
            result = strP + strRtnB.toString();
        } else {
            strRtnB.append(strP);
            result = strRtnB.toString();
        }
        return result;
    }

    public boolean isNull(String val) {
        return val == null || "".equals(val) || val.compareToIgnoreCase("null") == 0;
    }
}

