/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz;

import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.util.ServiceClient;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetResouceInfoSimple
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(GetResouceInfoSimple.class);
    private static final Namespace soap = Namespace.getNamespace((String)"soap", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final Namespace ns1 = Namespace.getNamespace((String)"ns1", (String)"http://tempuri.org/");

    public void process(WorkSheet sheet) throws ServiceException {
        log.debug("GetResouceInfoSimple...");
        String condition = sheet.getQueryParameters().getCondition();
        log.debug("\u539f\u59cb\u7684\u67e5\u8be2\u6761\u4ef6\uff1a" + condition);
        OutsideDataSource ods = DaoService.getDataSourceDao().getDS(sheet.getCurrOutTable().getOutdsId());
        String url = ods.getUrl();
        log.debug("\u6570\u636e\u6e90url\uff1a" + url);
        if (StringUtils.isBlank((String)condition)) {
            throw new ServiceException("\u8bf7\u8f93\u5165\u67e5\u8be2\u6761\u4ef6");
        }
        String[] strs = condition.split(",");
        String xml = this.getReturnXml(strs, url);
        log.debug("\u8bf7\u6c42GFT\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c" + xml);
        this.fetchReturnResult(sheet, xml);
    }

    private void fetchReturnResult(WorkSheet sheet, String xml) throws ServiceException {
        SAXBuilder saxb = new SAXBuilder();
        Document doc = null;
        Element root = null;
        StringReader strreader = null;
        try {
            strreader = new StringReader(xml);
            doc = saxb.build((Reader)strreader);
            root = doc.getRootElement();
            List<Element> list = root.getChildren("simple");
            int count = list.size();
            int rno = (sheet.getQueryParameters().getPageNumber() - 1) * sheet.getQueryParameters().getPageSize();
            int rlen = rno + sheet.getQueryParameters().getPageSize();
            list = this.getListPage(list, String.valueOf(rno), String.valueOf(rlen));
            sheet.setRowTotal((long)count);
            if (list != null && list.size() > 0) {
                for (Element element : list) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("id", element.getChild("ID").getTextTrim());
                    hashMap.put("content", element.getChild("content").getTextTrim());
                    sheet.getQueryResultList().add(hashMap);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException("\u67e5\u65e0\u6570\u636e\uff01");
        }
    }

    private String getReturnXml(String[] strs, String url) {
        String xml = "";
        String soapreq = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:tem=\"http://tempuri.org/\">    <soapenv:Header/>    <soapenv:Body>       <tem:GetResouceInfoSimple>      <tem:TableName>" + strs[0].trim() + "</tem:TableName>          <tem:StrQuery>" + strs[1].trim() + "</tem:StrQuery>          <tem:CityCode>" + strs[2].trim() + "</tem:CityCode>       </tem:GetResouceInfoSimple>    </soapenv:Body> </soapenv:Envelope>";
        ServiceClient sc = new ServiceClient(url, soapreq);
        if (sc.excute()) {
            String soapResponse = sc.responseBody;
            SAXBuilder saxb = new SAXBuilder();
            Document doc = null;
            Element root = null;
            StringReader strreader = null;
            try {
                strreader = new StringReader(soapResponse);
                doc = saxb.build((Reader)strreader);
                root = doc.getRootElement();
                xml = root.getChild("Body", soap).getChild("GetResouceInfoSimpleResponse", ns1).getChild("GetResouceInfoSimpleResult", ns1).getText();
                return xml;
            }
            catch (Exception e) {
                log.debug("\u8bf7\u6c42GFT\u63a5\u53e3\u51fa\u9519.");
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private List<Element> getListPage(List<Element> list, String sno, String eno) {
        List<Object> rslist = new ArrayList();
        try {
            int s = Integer.parseInt(sno);
            int e = Integer.parseInt(eno);
            s = s == 0 ? 1 : s;
            e = e == 0 ? 1 : e;
            e = s + e - 1;
            Integer i = list.size();
            if (e < s || s < 0 || e < 0) {
                rslist = list;
            } else if (i >= e) {
                for (int j = s; j <= e; ++j) {
                    rslist.add(list.get(j - 1));
                }
            } else if (i >= s && i <= e) {
                for (int j = s; j <= i; ++j) {
                    rslist.add(list.get(j - 1));
                }
            }
        }
        catch (Exception e) {
            log.debug("\u5206\u9875\u8f6c\u6362\u5f02\u5e38");
            rslist = list;
        }
        return rslist;
    }
}

