/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.drs.business.zz.PicHubInfoCloudServicePlugin;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.service.IDUResult;
import com.xdja.drs.service.impl.Column;
import com.xdja.drs.service.impl.IDUParameters;
import com.xdja.drs.service.impl.Row;
import com.xdja.drs.service.impl.Table;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import hprose.client.HproseHttpClient;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUploadHandler
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(ImageUploadHandler.class);

    public void process(WorkSheet sheet) throws ServiceException {
        OutsideDataSource outsideDataSource = DaoService.getDataSourceDao().getDS(sheet.getCurrOutTable().getOutdsId());
        String systemId = outsideDataSource.getUsername();
        String userId = outsideDataSource.getPassword();
        HproseHttpClient client = new HproseHttpClient(outsideDataSource.getUrl());
        PicHubInfoCloudServicePlugin cs = (PicHubInfoCloudServicePlugin)client.useService(PicHubInfoCloudServicePlugin.class);
        IDUParameters iDUParameters = sheet.getIdup();
        ArrayList tableList = iDUParameters.getTables();
        for (Table table : tableList) {
            List rowList = table.getRows();
            for (Row row : rowList) {
                List columnList = row.getColumns();
                StringBuffer retKeys = new StringBuffer("");
                for (Column column : columnList) {
                    String imageStr = column.getValue();
                    String key = this.getUploadImageReturnResult(imageStr, cs, systemId, userId);
                    if (StringUtils.isBlank((String)key)) {
                        throw new ServiceException("upload img fail!");
                    }
                    retKeys.append(key + ",");
                }
                retKeys.deleteCharAt(retKeys.lastIndexOf(","));
                log.info("retKeys:{}", (Object)retKeys);
                IDUResult iDUResult = new IDUResult();
                iDUResult.setState(0);
                iDUResult.setErrMsg(retKeys.toString());
                sheet.setIduResult(iDUResult);
            }
        }
    }

    private String getUploadImageReturnResult(String base64Str, PicHubInfoCloudServicePlugin cs, String systemId, String userId) {
        byte[] bs = Base64.decodeBase64((String)base64Str);
        String returnJson = cs.addSSYTHJZXXWithOutHkey(systemId, userId, bs);
        log.info("\u4e0a\u4f20\u7167\u7247\u8fd4\u56de\u7684json=" + returnJson);
        JSONObject jo = JSON.parseObject((String)returnJson);
        if (jo == null) {
            return null;
        }
        String key = jo.getString("responseContent");
        log.info("returnKey=" + key);
        return key;
    }
}

