/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz;

import com.xdja.basecode.db.DBUtil;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideTable;
import com.xdja.drs.util.DBConnectPool;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGISServer
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(PGISServer.class);
    private static final double EARTH_RADIUS = 6378137.0;

    public void process(WorkSheet sheet) throws ServiceException {
        log.debug(">>>>>\u5f00\u59cb\u6267\u884c \u90d1\u5dde\u7b7e\u5230\u529f\u80fdPGIS\u7cfb\u7edf\u5bf9\u63a5\u4e1a\u52a1");
        String returnMsg = "";
        String condition = sheet.getQueryParameters().getCondition();
        log.debug("\u8bf7\u6c42\u7684\u6761\u4ef6\u4e3a" + condition);
        String zbx = null;
        String zby = null;
        String dwbm = null;
        String jwsbm = null;
        String[] xy = new String[2];
        String[] zb = condition.substring(condition.indexOf("=") + 1, condition.length()).split("#");
        zbx = zb[0];
        zby = zb[1];
        log.debug("zbx:" + zbx + "   zby:" + zby);
        dwbm = zb[2];
        log.debug("\u63a5\u53d7\u7f51\u683c\u5355\u4f4d\u7f16\u7801:" + dwbm);
        if (dwbm.length() < 2) {
            log.debug("\u63a5\u53d7\u7f51\u683c\u5355\u4f4d\u7f16\u7801\u9519\u8bef: " + dwbm);
            returnMsg = "0|\u672a\u5173\u8054\u5230\u6240\u5c5e\u8b66\u52a1\u5ba4\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458";
            throw new ServiceException(returnMsg);
        }
        dwbm = dwbm.substring(0, dwbm.length() - 2) + "00";
        jwsbm = this.queryJWSBM(dwbm);
        log.debug("\u8b66\u52a1\u5ba4\u7f16\u7801\u4e3a\uff1a" + jwsbm);
        if (StringUtils.isBlank((String)jwsbm)) {
            log.debug("\u7531\u7f51\u683c\u5355\u4f4d\u7f16\u7801\u83b7\u53d6\u4e0d\u5230\u8b66\u52a1\u5ba4\u7f16\u7801\uff1a" + dwbm);
            returnMsg = "0|\u672a\u5173\u8054\u5230\u6240\u5c5e\u8b66\u52a1\u5ba4\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458";
            throw new ServiceException(returnMsg);
        }
        xy = this.queryJWSXY(jwsbm);
        if (xy == null) {
            log.debug("\u7531\u7f51\u683c\u5355\u4f4d\u7f16\u7801\u83b7\u53d6\u4e0d\u5230\u8b66\u52a1\u5ba4\u7f16\u7801\uff1a" + dwbm);
            returnMsg = "0|\u672a\u5173\u8054\u5230\u6240\u5c5e\u8b66\u52a1\u5ba4\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458";
            throw new ServiceException(returnMsg);
        }
        if (!this.checkPointInCenter(zbx, zby, xy)) {
            returnMsg = "1|0|\u4e0d\u5728\u8b66\u52a1\u5ba42\u516c\u91cc\u5185";
            throw new ServiceException(returnMsg);
        }
        returnMsg = "1|1|\u5728\u8b66\u52a1\u5ba42\u516c\u91cc\u5185";
        this.fatchQueryResult(sheet, returnMsg);
    }

    private void fatchQueryResult(WorkSheet sheet, String returnMsg) throws ServiceException {
        sheet.setRowTotal(1L);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("result", returnMsg);
        sheet.getQueryResultList().add(hashMap);
    }

    private String queryJWSBM(String dwbm) {
        log.debug("\u5f00\u59cb\u83b7\u53d6\u8b66\u52a1\u5ba4\u7f16\u7801");
        String jwsbm = null;
        String sql = "select jwsbm from WGGL_WGJWSDZB where wgdw = '" + dwbm + "'";
        List outsideTableList = DaoService.getOutTableDao().getOutsideTable("DS-00000002..WGGL_WGJWSDZB");
        if (outsideTableList == null || outsideTableList.size() <= 0) {
            log.error("\u83b7\u53d6DS-00000002..WGGL_WGJWSDZB\u5916\u90e8\u8868\u9519\u8bef");
            return null;
        }
        OutsideTable outsideTable = (OutsideTable)outsideTableList.get(0);
        Connection connection = DBConnectPool.getInstance().getConnection(outsideTable.getOutdsId());
        if (connection == null) {
            log.error("\u83b7\u53d6DS-00000002..WGGL_WGJWSDZB\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef");
            return null;
        }
        log.debug("SQL\uff1a" + sql);
        try {
            ArrayList resultList = DBUtil.query((Connection)connection, (String)sql);
            if (resultList == null || resultList.size() <= 0) {
                log.debug("\u6ca1\u6709\u627e\u5230\u5355\u4f4d\u4ee3\u7801\u4e3a: " + dwbm + " \u7684\u7f51\u683c\u5bf9\u5e94\u7684\u8b66\u52a1\u5ba4\u4ee3\u7801");
                return null;
            }
            jwsbm = (String)((HashMap)resultList.get(0)).get("jwsbm");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return jwsbm;
    }

    private String[] queryJWSXY(String jwsbm) {
        log.debug("\u83b7\u53d6\u8b66\u52a1\u5ba4\u5750\u6807");
        String x = null;
        String y = null;
        String sql = "select zbx,zby from t_sqjw_jwsjbxx where jwsbm='" + jwsbm + "'";
        log.debug("SQL: " + sql);
        List outsideTableList = DaoService.getOutTableDao().getOutsideTable("DS-00000058..T_SQJW_JWSJBXX");
        if (outsideTableList == null || outsideTableList.size() <= 0) {
            log.error("DS-00000058..T_SQJW_JWSJBXX\u5916\u90e8\u8868\u9519\u8bef");
            return null;
        }
        OutsideTable outsideTable = (OutsideTable)outsideTableList.get(0);
        Connection connection = DBConnectPool.getInstance().getConnection(outsideTable.getOutdsId());
        if (connection == null) {
            log.error("DS-00000058..T_SQJW_JWSJBXX\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef");
            return null;
        }
        log.debug("SQL\uff1a" + sql);
        try {
            ArrayList resultList = DBUtil.query((Connection)connection, (String)sql);
            if (resultList == null || resultList.size() <= 0) {
                log.debug("\u6ca1\u6709\u627e\u5230\u8b66\u52a1\u5ba4\u4ee3\u7801\u4e3a: " + jwsbm + " \u7684XY\u5750\u6807");
                return null;
            }
            x = (String)((HashMap)resultList.get(0)).get("zbx");
            y = (String)((HashMap)resultList.get(0)).get("zby");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        String[] xy = new String[]{x, y};
        return xy;
    }

    private boolean checkPointInCenter(String x, String y, String[] xy) {
        String jwsX = xy[0];
        String jwsY = xy[1];
        double length = this.GetDistance(Double.valueOf(y), Double.valueOf(x), Double.valueOf(jwsY), Double.valueOf(jwsX));
        log.info("\u70b9\uff1a" + x + "," + y + "  \u8b66\u52a1\u5ba4\uff1a" + xy[0] + "," + xy[1]);
        log.info("\u8ddd\u79bb\uff1a" + length);
        double checkValue = 2000.0;
        return !(length > checkValue);
    }

    public double GetDistance(double lat1, double lng1, double lat2, double lng2) {
        double radLat1 = this.rad(lat1);
        double radLat2 = this.rad(lat2);
        double a = radLat1 - radLat2;
        double b = this.rad(lng1) - this.rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6378137.0;
        s = Math.round(s * 10000.0) / 10000L;
        return s;
    }

    private double rad(double d) {
        return d * Math.PI / 180.0;
    }
}

