/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz;

import com.xdja.basecode.db.DBConnectionPool;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.sql.SqlUtils;
import com.xdja.drs.util.DBConnectPool;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.tools.OrganizeSql;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class QbRyxxBdBusiness
implements WorkFlow {
    private static final String RYDLBMC = "RYDLBMC";
    private static final String ZZRYLB = "zzrylb";
    private static final String LBID = "lbid";

    public void process(WorkSheet sheet) throws ServiceException {
        new OrganizeSql().process(sheet);
        OutsideDataSource outsideDataSource = DaoService.getDataSourceDao().getDS(sheet.getCurrOutTable().getOutdsId());
        String condition = sheet.getQueryParameters().getCondition();
        LinkedHashMap maps = SqlUtils.fetchQueryCondition((String)condition);
        Connection connection = DBConnectPool.getInstance().getConnection(outsideDataSource.getId());
        try {
            if (connection == null || connection.isClosed()) {
                throw new ServiceException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
        String sfzh = (String)maps.get("sfzh");
        ResultSet resultSet = this.getResultSet(connection, sfzh, sheet);
        this.packageResult(resultSet, sheet);
    }

    private void packageResult(ResultSet resultSet, WorkSheet sheet) {
        LinkedList<HashMap<String, String>> resultList = new LinkedList<HashMap<String, String>>();
        Long total = 0L;
        Set columnKeyList = sheet.getOutLocalMapFields().keySet();
        columnKeyList.remove(ZZRYLB);
        try {
            while (resultSet != null && resultSet.next()) {
                Long l = total;
                total = total + 1L;
                Long l2 = total;
                HashMap<String, String> resultMap = new HashMap<String, String>();
                for (String key : columnKeyList) {
                    String result = resultSet.getString(key);
                    this.transformResult(key, result, resultMap);
                }
                resultList.add(resultMap);
            }
            sheet.setRowTotal(total.longValue());
            sheet.setQueryResult(resultList);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void transformResult(String key, String result, HashMap<String, String> resultMap) {
        resultMap.put(key, result);
        if (!LBID.equalsIgnoreCase(key)) {
            return;
        }
        if (result.startsWith("005011")) {
            result = "\u90e8\u7a33\u63a7\u4eba\u5458-\u7a33\u63a7\u62a5\u6307\u6325\u90e8(69620376)";
            resultMap.put(ZZRYLB, result);
            return;
        }
        if (result.startsWith("005")) {
            result = "\u60c5\u62a5\u6d89\u7a33\u4eba\u5458-\u7a33\u63a7\u62a5\u6307\u6325\u90e8(69620376)";
            resultMap.put(ZZRYLB, result);
            return;
        }
        List<String> rylbList = Arrays.asList(KeyPerson.ZDRY.rylb.split(","));
        for (String rylb : rylbList) {
            if (!result.startsWith(rylb)) continue;
            result = "\u516c\u5b89\u90e8\u4e03\u7c7b\u91cd\u70b9\u4eba\u5458-\u76d8\u67e5\u65e0\u5acc\u7591\u540e\u653e\u884c";
            resultMap.put(ZZRYLB, result);
            return;
        }
        resultMap.put(ZZRYLB, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ResultSet getResultSet(Connection connection, String sfzh, WorkSheet sheet) {
        CallableStatement cs = null;
        ResultSet resultSet = null;
        try {
            cs = connection.prepareCall("{call rygl.p_get_ryxx(?,?)}");
            cs.setString(1, sfzh);
            cs.registerOutParameter(2, -10);
            cs.execute();
            resultSet = (ResultSet)cs.getObject(2);
            this.packageResult(resultSet, sheet);
        }
        catch (SQLException sQLException) {
            DBConnectionPool.getInstance().closeAll(resultSet, (Statement)cs, connection);
            catch (Throwable throwable) {
                DBConnectionPool.getInstance().closeAll(resultSet, (Statement)cs, connection);
                throw throwable;
            }
        }
        DBConnectionPool.getInstance().closeAll(resultSet, (Statement)cs, connection);
        return resultSet;
    }

    private static enum KeyPerson {
        ZDRY("001001,001002,001003,001004,001005,001006,001007");

        private String rylb = "";

        private KeyPerson(String rylb) {
            this.rylb = rylb;
        }
    }
}

