/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz.jcbk;

import com.xdja.basecode.xml.XmlHelper;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.model.OutsideTable;
import com.xdja.drs.service.impl.Column;
import com.xdja.drs.service.impl.IDUParameters;
import com.xdja.drs.service.impl.Row;
import com.xdja.drs.service.impl.Table;
import com.xdja.drs.sql.SqlUtils;
import com.xdja.drs.util.DataOperateType;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.tools.OrganizeSql;
import com.xdja.drs.wsclient.zz.jcbk.RmJaxRpcOutAccessServiceStub;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcbkInvokeBusinessbak
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(JcbkInvokeBusinessbak.class);
    private static final String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><root></root>";

    public void process(WorkSheet sheet) throws ServiceException {
        OutsideTable outsideTable = sheet.getCurrOutTable();
        OutsideDataSource ods = DaoService.getDataSourceDao().getDS(outsideTable.getOutdsId());
        String owner = outsideTable.getOwner();
        String jkid = owner.split(",")[0];
        log.debug("jkid:" + jkid);
        String jkxlh = owner.split(",")[1];
        log.debug("jkxlh:" + jkxlh);
        String xtlb = jkid.substring(0, 2);
        String nodeName = owner.split(",")[2];
        log.debug("nodeName:" + nodeName);
        String urls = ods.getUrl();
        log.debug("urls:" + urls);
        String url = this.getWorkUrl(urls);
        log.debug("url:" + url);
        new OrganizeSql().process(sheet);
        if (sheet.getDoType() == DataOperateType.query) {
            log.debug("query business");
            LinkedHashMap maps = SqlUtils.fetchQueryCondition((String)sheet.getTranslateWhereSql());
            Document document = XmlHelper.getDoc((String)xml);
            Element nodeNameElement = document.getRootElement().addElement(nodeName);
            try {
                for (Map.Entry entry : maps.entrySet()) {
                    nodeNameElement.addElement((String)entry.getKey()).setText(URLEncoder.encode((String)entry.getValue(), "utf-8"));
                }
                log.debug("queryDocument:" + document.asXML());
                RmJaxRpcOutAccessServiceStub accessServiceStub = new RmJaxRpcOutAccessServiceStub(url);
                RmJaxRpcOutAccessServiceStub.QueryObjectOut queryObjectOut = new RmJaxRpcOutAccessServiceStub.QueryObjectOut();
                queryObjectOut.setJkid(jkid);
                queryObjectOut.setJkxlh(jkxlh);
                queryObjectOut.setXtlb(xtlb);
                queryObjectOut.setUTF8XmlDoc(document.asXML());
                String returnResult = accessServiceStub.queryObjectOut(queryObjectOut).getQueryObjectOutReturn();
                log.debug("query returnResult\uff1a" + returnResult);
                Document retDoc = XmlHelper.getDoc((String)returnResult);
                String code = retDoc.selectSingleNode("root/head/code").getText();
                if (!"1".equals(code)) {
                    String errorMsg = retDoc.selectSingleNode("root/head/message").getText();
                    throw new ServiceException(errorMsg);
                }
                String rownum = retDoc.selectSingleNode("root/head/rownum").getText();
                sheet.setRowTotal(Long.parseLong(rownum));
                ArrayList dataList = new ArrayList();
                List elements = retDoc.selectNodes("root/body/" + nodeName);
                int pageNumber = sheet.getQueryParameters().getPageNumber();
                int pageSize = sheet.getQueryParameters().getPageSize();
                int startIndex = 1;
                if (pageNumber > 1) {
                    startIndex = pageNumber * pageSize - pageSize + 1 + 1;
                }
                int endIndex = startIndex + pageSize - 1;
                for (int x = startIndex - 1; (long)x < Long.parseLong(rownum) && x != endIndex; ++x) {
                    List elements2 = ((Element)elements.get(x)).selectNodes("*");
                    HashMap<String, String> data = new HashMap<String, String>();
                    for (Element element2 : elements2) {
                        data.put(element2.getName().toLowerCase(), element2.getText());
                    }
                    dataList.add(data);
                }
                sheet.setQueryResult(dataList);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ServiceException("query business error:" + e.getMessage());
            }
        }
        log.debug("insert business");
        try {
            RmJaxRpcOutAccessServiceStub accessServiceStub = new RmJaxRpcOutAccessServiceStub(url);
            IDUParameters iduParameters = sheet.getIdup();
            List rows = ((Table)iduParameters.getTables().get(0)).getRows();
            Document insertDoc = XmlHelper.getDoc((String)xml);
            Element rootElement = insertDoc.getRootElement();
            Element nodeElement = rootElement.addElement(nodeName);
            for (Row row : rows) {
                List columns = row.getColumns();
                for (Column column : columns) {
                    nodeElement.addElement(column.getOutColumn().getFieldEnName().toLowerCase()).setText(column.getValue());
                }
            }
            log.debug("insertdoc:" + insertDoc.asXML());
            RmJaxRpcOutAccessServiceStub.WriteObjectOut writeObjectOut = new RmJaxRpcOutAccessServiceStub.WriteObjectOut();
            writeObjectOut.setJkid(jkid);
            writeObjectOut.setJkxlh(jkxlh);
            writeObjectOut.setXtlb(xtlb);
            writeObjectOut.setUTF8XmlDoc(insertDoc.asXML());
            String returnResult = accessServiceStub.writeObjectOut(writeObjectOut).getWriteObjectOutReturn();
            log.debug("returnResult:" + returnResult);
            Document retDoc = XmlHelper.getDoc((String)returnResult);
            String code = retDoc.selectSingleNode("root/head/code").getText();
            if (!"1".equals(code)) {
                String errorMsg = retDoc.selectSingleNode("root/head/message").getText();
                throw new ServiceException(errorMsg);
            }
            sheet.setReturnResult("0||success");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWorkUrl(String urls) {
        if (StringUtils.isBlank((String)urls)) {
            return "";
        }
        String[] urlArray = urls.split(",");
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setIntParameter("http.connection.timeout", 500);
        httpClient.getParams().setIntParameter("http.socket.timeout", 500);
        HttpResponse httpResponse = null;
        HttpGet httpGet = null;
        for (int i = 0; i < 3; ++i) {
            for (String url : urlArray) {
                try {
                    httpGet = new HttpGet(url + "?a=" + System.currentTimeMillis());
                    httpGet.setHeader("connection", "close");
                    httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                    if (httpResponse.getStatusLine().getStatusCode() != 200) continue;
                    String string = url;
                    return string;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    httpClient.getConnectionManager().shutdown();
                    httpGet = null;
                    httpResponse = null;
                }
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return "";
    }
}

