/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz.jcbk;

import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.model.OutsideTable;
import com.xdja.drs.sql.SqlUtils;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.tools.OrganizeSql;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class QueryGcZpBusiness
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(QueryGcZpBusiness.class);

    public void process(WorkSheet sheet) throws ServiceException {
        log.debug("start QueryGcZpBusiness");
        new OrganizeSql().process(sheet);
        OutsideTable outsideTable = sheet.getCurrOutTable();
        OutsideDataSource ods = DaoService.getDataSourceDao().getDS(outsideTable.getOutdsId());
        String url = ods.getUrl();
        log.debug("url:" + url);
        LinkedHashMap maps = SqlUtils.fetchQueryCondition((String)sheet.getTranslateWhereSql());
        String gcxh = (String)maps.get("gcxh");
        log.debug("gcxh:" + gcxh);
        String picUrl = url + "&gcxh=" + gcxh;
        log.debug("picUrl:" + picUrl);
        HttpPost httpPost = null;
        DefaultHttpClient httpClient = null;
        HttpResponse httpResponse = null;
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            ArrayList rows = new ArrayList();
            HashMap<String, String> dataMap = new HashMap<String, String>();
            httpPost = new HttpPost(picUrl);
            httpClient = new DefaultHttpClient();
            httpPost.setHeader("Connection", "close");
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new ServiceException("http \u8bf7\u6c42\u7167\u7247\u5f02\u5e38");
            }
            inputStream = httpResponse.getEntity().getContent();
            BASE64Encoder base64Encoder = new BASE64Encoder();
            byteArrayOutputStream = new ByteArrayOutputStream();
            int i = 0;
            while ((i = inputStream.read()) != -1) {
                byteArrayOutputStream.write(i);
            }
            String base64Str = base64Encoder.encode(byteArrayOutputStream.toByteArray());
            dataMap.put("gcxh", gcxh);
            dataMap.put("gczp", base64Str);
            rows.add(dataMap);
            sheet.setRowTotal(1L);
            sheet.setQueryResult(rows);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServiceException("\u83b7\u53d6\u8fc7\u8f66\u7167\u7247\u5931\u8d25:" + e.getMessage());
        }
        finally {
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            inputStream = null;
            httpPost = null;
            httpResponse = null;
            byteArrayOutputStream = null;
        }
    }
}

