/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.drs.business.zz.jglhy;

import com.xdja.basecode.util.HelpFunction;
import com.xdja.basecode.xml.XmlHelper;
import com.xdja.drs.cache.FieldsMapCache;
import com.xdja.drs.dao.DaoService;
import com.xdja.drs.model.OutsideDataSource;
import com.xdja.drs.model.OutsideTable;
import com.xdja.drs.model.OutsideTableColumn;
import com.xdja.drs.sql.SqlUtils;
import com.xdja.drs.util.Const;
import com.xdja.drs.util.DataOperateType;
import com.xdja.drs.util.ServiceException;
import com.xdja.drs.workflow.WorkFlow;
import com.xdja.drs.workflow.WorkSheet;
import com.xdja.drs.workflow.tools.OrganizeSql;
import com.xdja.drs.wsclient.zz.jglhy.TmriJaxRpcOutNewAccessServiceStub;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JglhyBusiness
implements WorkFlow {
    private static final Logger log = LoggerFactory.getLogger(JglhyBusiness.class);
    private static String sfjc = "";
    private static String xlh = "";
    private String cjsqbh = "";
    private String xtlb = "";
    private String xmlDoc = "";
    private static String localhostip = "127.0.0.1";
    private static Pattern p = Pattern.compile("[\u4e00-\u9fa5]");

    public void process(WorkSheet sheet) throws ServiceException {
        log.debug("start JglhyBusiness");
        new OrganizeSql().process(sheet);
        OutsideTable ot = sheet.getCurrOutTable();
        OutsideDataSource ods = DaoService.getDataSourceDao().getDS(ot.getOutdsId());
        String[] owners = ot.getOwner().split(",");
        String jkid = null;
        jkid = owners[0];
        log.debug("jkid=" + jkid);
        this.cjsqbh = owners[1];
        log.debug("cjsqbh=" + this.cjsqbh);
        if (sheet.getDoType() == DataOperateType.query) {
            log.debug("query business");
            String urls = ods.getUrl();
            log.debug("urls:" + urls);
            String url = this.getWorkUrl(urls);
            log.debug("url:" + url);
            this.xtlb = jkid.substring(0, 2);
            log.debug("xtlb:" + this.xtlb);
            LinkedHashMap maps = SqlUtils.fetchQueryCondition((String)sheet.getTranslateWhereSql());
            Document queryDoc = this.getQueryDoc(maps, ot, sheet);
            this.xmlDoc = queryDoc.asXML();
            log.debug("queryDoc:" + queryDoc.asXML());
            try {
                TmriJaxRpcOutNewAccessServiceStub accessServiceStub = new TmriJaxRpcOutNewAccessServiceStub(url);
                TmriJaxRpcOutNewAccessServiceStub.QueryObjectOutNew queryObjectOutNew = new TmriJaxRpcOutNewAccessServiceStub.QueryObjectOutNew();
                queryObjectOutNew.setCjsqbh(this.cjsqbh);
                queryObjectOutNew.setDwjgdm("");
                queryObjectOutNew.setDwmc("");
                queryObjectOutNew.setJkid(jkid);
                queryObjectOutNew.setJkxlh(xlh);
                queryObjectOutNew.setUTF8XmlDoc(this.xmlDoc);
                queryObjectOutNew.setXtlb(this.xtlb);
                queryObjectOutNew.setYhbz("");
                queryObjectOutNew.setYhxm("");
                queryObjectOutNew.setZdbs(localhostip);
                String returnXml = accessServiceStub.queryObjectOutNew(queryObjectOutNew).getQueryObjectOutNewReturn();
                log.debug("returnXml:" + returnXml);
                this.processQueryResult(returnXml, sheet, jkid);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ServiceException("ERROR_INVOKE_TRAFFIC\u8c03\u7528\u4ea4\u7ba1\u516d\u5408\u4e00\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
            }
        } else {
            log.debug("insert business");
        }
    }

    public Document getQueryDoc(LinkedHashMap<String, String> maps, OutsideTable ot, WorkSheet sheet) {
        Document queryDoc = DocumentHelper.createDocument();
        queryDoc.setXMLEncoding("GBK");
        Element root = queryDoc.addElement("root");
        Element qc = root.addElement("QueryCondition");
        maps.remove("1");
        if (maps.size() > 0) {
            String sf = "";
            for (Map.Entry<String, String> entry : maps.entrySet()) {
                OutsideTableColumn otc = FieldsMapCache.getOutColumn((String)ot.getId(), (String)entry.getKey());
                log.debug("key:" + entry.getKey() + "  outFieldEnName:" + otc.getFieldEnName() + "  Value:" + entry.getValue());
                if ("sf".equalsIgnoreCase(otc.getFieldEnName()) && StringUtils.isNotBlank((String)entry.getValue())) {
                    log.debug("\u8fdb\u5165\u7701\u4efd\u5904\u7406");
                    sf = entry.getValue();
                    sheet.setSf(sf);
                } else {
                    sf = sfjc;
                }
                if (otc.getCutType() > 0 && this.isChineseChar(entry.getValue())) {
                    qc.addElement(entry.getKey()).setText(entry.getValue().substring(1));
                    continue;
                }
                qc.addElement(entry.getKey()).setText(entry.getValue());
            }
        }
        return queryDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWorkUrl(String urls) {
        if (StringUtils.isBlank((String)urls)) {
            return "";
        }
        String[] urlArray = urls.split(",");
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setIntParameter("http.connection.timeout", 500);
        httpClient.getParams().setIntParameter("http.socket.timeout", 500);
        HttpResponse httpResponse = null;
        HttpGet httpGet = null;
        for (String url : urlArray) {
            try {
                httpGet = new HttpGet(url + "?a=" + System.currentTimeMillis());
                httpGet.setHeader("connection", "close");
                httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                if (httpResponse.getStatusLine().getStatusCode() != 200) continue;
                String string = url;
                return string;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                httpClient.getConnectionManager().shutdown();
                httpGet = null;
                httpResponse = null;
            }
        }
        return "";
    }

    private boolean isChineseChar(String str) {
        boolean temp = false;
        Matcher m = p.matcher(str);
        if (m.find()) {
            temp = true;
        }
        return temp;
    }

    private void processQueryResult(String wsResult, WorkSheet sheet, String jkid) throws ServiceException {
        try {
            wsResult = URLDecoder.decode(wsResult.replaceAll("%(?![0-9a-fA-F]{2})", "%25"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("[93003]: \u4f7f\u7528UTF-8\u7f16\u7801\u89e3\u6790\u7ed3\u679c\u5931\u8d25");
            throw new ServiceException("[93003]: \u4f7f\u7528UTF-8\u7f16\u7801\u89e3\u6790\u7ed3\u679c\u5931\u8d25");
        }
        log.info("\u516d\u5408\u4e00\u63a5\u53e3\u67e5\u8be2\u8fd4\u56de\uff1a" + wsResult);
        Document resultDoc = XmlHelper.getDoc((String)wsResult);
        Element head = resultDoc.getRootElement().element("head");
        if (!"1".equals(head.elementTextTrim("code"))) {
            throw new ServiceException("ERROR_INVOKE_TRAFFIC\u4ea4\u7ba1\u516d\u5408\u4e00\u63a5\u53e3\u8fd4\u56de\u9519\u8bef\u6d88\u606f\uff1a" + head.elementTextTrim("message"));
        }
        int rowCount = HelpFunction.getInt((String)head.elementTextTrim("rownum"), (int)0);
        log.debug("\u63a5\u53e3\u8fd4\u56de\u8bb0\u5f55\u6570\uff1a" + rowCount);
        sheet.setRowTotal((long)rowCount);
        if (rowCount == 0) {
            return;
        }
        int pageNumber = sheet.getQueryParameters().getPageNumber();
        int pageSize = sheet.getQueryParameters().getPageSize();
        int startIndex = 0;
        if (pageNumber > 1) {
            startIndex = pageNumber * pageSize - pageSize;
        }
        int endIndex = startIndex + pageSize - 1;
        List wsRows = resultDoc.getRootElement().element("body").elements();
        for (int x = startIndex; x < wsRows.size(); ++x) {
            Element row = (Element)wsRows.get(x);
            LinkedHashMap outFields = sheet.getOutLocalMapFields();
            Iterator it = outFields.keySet().iterator();
            String key = null;
            String value = null;
            HashMap<String, String> kvMaps = new HashMap<String, String>();
            while (it.hasNext()) {
                key = (String)it.next();
                value = "02C05".equals(jkid) && "zpStr".equalsIgnoreCase(key) ? row.elementText("zpStr") : row.elementTextTrim(key);
                kvMaps.put(key, value);
            }
            sheet.getQueryResultList().add(kvMaps);
            if (x == endIndex) break;
        }
    }

    static {
        String cfgFile = Const.JG_FILE;
        log.debug("\u4ea4\u7ba1\u63a5\u53e3\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\uff1a" + cfgFile);
        Document cfg = XmlHelper.getDocAsFilePath((String)cfgFile);
        sfjc = XmlHelper.getValue((Node)cfg, (String)"/root/province", (String)"\u8c6b");
        xlh = XmlHelper.getValue((Node)cfg, (String)"/root/jkxh", (String)"");
        localhostip = XmlHelper.getValue((Node)cfg, (String)"/root/Localhost_ip", (String)"127.0.0.1");
    }
}

